package testantiswapgun;

import java.awt.geom.Point2D;
import java.util.Vector;

import java.util.Hashtable;

import robocode.util.*;
import robocode.*;

public class MovSim {
	
	private double systemMaxTurnRate = Math.toRadians(10.0);
	private double systemMaxVelocity = 8.0;
	private double maxBraking = 2.0;
	private double maxAcceleration = 1.0;
	
	private Hashtable<String, Hashtable<Long, Double>> velocitys = new Hashtable<String, Hashtable<Long, Double>>();
	private Hashtable<String, Hashtable<Long, Double>> headings = new Hashtable<String, Hashtable<Long, Double>>();
	
	
	public MovSim() {};
		
	
	public MovSimStat[] futurePos(int steps, AdvancedRobot b) { return futurePos(steps, b, systemMaxVelocity, systemMaxTurnRate); }
		
	public MovSimStat[] futurePos(int steps, AdvancedRobot b, double maxVel, double maxTurnRate) {
		double ahead[] = new double[2];
		ahead[0] = b.getDistanceRemaining();
		ahead[1] = maxVel;
		ahead = nextVelocityAndAcceleration(b.getName(), b.getVelocity(), b.getTime());
		//System.out.println("expected ahead*vel:"+b.getDistanceRemaining()*b.getVelocity()+" ahead: "+ahead[0]+" maxvel: "+ahead[1]);
		

		return futurePos(steps, b.getX(), b.getY(), b.getVelocity(), ahead[1], b.getHeadingRadians(), ahead[0], b.getTurnRemainingRadians(), maxTurnRate, b.getBattleFieldWidth(), b.getBattleFieldHeight());
	}
	
	private double[] nextVelocityAndAcceleration(String name, double velocity, long time){
		double enAhead[] = new double[2];
		enAhead[0] = 1000*velocity;
		enAhead[1] = Rules.MAX_VELOCITY;
		Hashtable<Long, Double> next = new Hashtable<Long, Double>();
		next.put(time+1, velocity);
		velocitys.put(name, next);
		
		if (velocitys.get(name) != null){
			long bestLogTime = time;
			while(velocitys.get(name).get(time)==null){
				time--;
				if (time<0)
					break;
			}
			time = time<0?bestLogTime+1:time;
			
			//se accellera
			if ( velocity > velocitys.get(name).get(time) ) //accellera al max
				enAhead[0] = velocity*1000;
			
			//se frena
			if ( velocity < velocitys.get(name).get(time) )//frena al max
				enAhead[0] = -velocity*1000;
				
			//se uguale
			if ( velocity == velocitys.get(name).get(time) ){//mantine la velocità
				enAhead[0] = velocity*1000;
				enAhead[1] = velocity;
			}
		}
		return enAhead;
	}
/*	
	private double nextRotation(String name, double heading){
		double expectedMaxTurnRate = maxTurnRate;
		double enRot = 0;

		if (lastHeading.get(b.getName()) != null)
			enRot = b.getHeadingRadians() - lastHeading.get(b.getName());
		lastHeading.put(name(), heading);
		
		if (Math.abs(b.getTurnRemainingRadians()) > maxTurnRate)
			System.out.print("expected rotation: "+maxTurnRate);
		else
			System.out.print("expected rotation: "+b.getTurnRemainingRadians());
		System.out.println(" rotation: "+enRot);
		return enRot;
	}
*/	
	public MovSimStat[] futurePos(int steps, AdvancedRobot b, ScannedRobotEvent e) { 
		return futurePos(steps, b, e, systemMaxVelocity, systemMaxTurnRate);
	}
	
	public MovSimStat[] futurePos(int steps, AdvancedRobot b, ScannedRobotEvent e, double maxVel, double maxTurnRate) {
		double absoluteBearing = b.getHeadingRadians() + e.getBearingRadians();
		
		double enemyX = b.getX() + e.getDistance() * Math.sin(absoluteBearing);
		double enemyY = b.getY() + e.getDistance() * Math.cos(absoluteBearing);

		
		double expectedMaxVel = maxVel;
		double enAhead[] = new double[2];
		enAhead[0] = 1000*e.getVelocity();
		enAhead[1] = systemMaxVelocity;
		enAhead = nextVelocityAndAcceleration(e.getName(),e.getVelocity(), e.getTime()); 
		
		double expectedMaxTurnRate = maxTurnRate;
		double enRot = 0;

		return futurePos(steps, enemyX, enemyY, e.getVelocity(), enAhead[1], e.getHeadingRadians(), enAhead[0], enRot, expectedMaxTurnRate, b.getBattleFieldWidth(), b.getBattleFieldHeight());
	}
	
	private MovSimStat[] futurePos(int steps, double x, double y, double velocity, double maxVelocity, double heading, double distanceRemaining, double angleToTurn, double maxTurnRate, double battleFieldW, double battleFieldH) {

		MovSimStat[] pos = new MovSimStat[steps];
		double acceleration = 0;
		boolean slowingDown = false;
		double moveDirection;
		
		if (distanceRemaining == 0) moveDirection = 0; else if (distanceRemaining < 0.0) moveDirection = -1; else moveDirection = 1;
		
		//heading, accel, velocity, distance
		for (int i=0; i<steps; i++) {
			//heading
			double lastHeading = heading;
			double turnRate = Math.min(maxTurnRate, ((0.4 + 0.6 * (1.0 - (Math.abs(velocity) / systemMaxVelocity))) * systemMaxTurnRate));
			if (angleToTurn > 0.0) {
	    		if (angleToTurn < turnRate) { heading += angleToTurn; angleToTurn = 0.0; } 
				else { heading += turnRate; angleToTurn -= turnRate; }
			} else if (angleToTurn < 0.0) {
	    		if (angleToTurn > -turnRate) { heading += angleToTurn; angleToTurn = 0.0; } 
				else { heading -= turnRate;	angleToTurn += turnRate; }
			}
			heading = Utils.normalAbsoluteAngle(heading);
			//movement
			if (distanceRemaining != 0.0 || velocity != 0.0) { 
				//lastX = x; lastY = y;
				if (!slowingDown && moveDirection == 0) {
					slowingDown = true;
					if (velocity > 0.0) moveDirection = 1;
					else if (velocity < 0.0) moveDirection = -1;
					else moveDirection = 0;
			    }
			    double desiredDistanceRemaining = distanceRemaining;
	    		if (slowingDown) {
					if (moveDirection == 1 && distanceRemaining < 0.0) desiredDistanceRemaining = 0.0;
					else if (moveDirection == -1 && distanceRemaining > 1.0) desiredDistanceRemaining = 0.0;
			    }
	    		double slowDownVelocity	= (double) (int) (maxBraking / 2.0 * ((Math.sqrt(4.0 * Math.abs(desiredDistanceRemaining)+ 1.0)) - 1.0));
		    	if (moveDirection == -1) slowDownVelocity = -slowDownVelocity;
		    	if (!slowingDown) {
					if (moveDirection == 1) {
		    			if (velocity < 0.0) acceleration = maxBraking;
			    		else acceleration = maxAcceleration;
				    	if (velocity + acceleration > slowDownVelocity) slowingDown = true;
					} else if (moveDirection == -1) {
				    	if (velocity > 0.0) acceleration = -maxBraking;
		    			else acceleration = -maxAcceleration;
		    			if (velocity + acceleration < slowDownVelocity)	slowingDown = true;
					}
			    }
	    		if (slowingDown) {
					if (distanceRemaining != 0.0 && Math.abs(velocity) <= maxBraking && Math.abs(distanceRemaining) <= maxBraking) slowDownVelocity = distanceRemaining;
					double perfectAccel = slowDownVelocity - velocity;
					if (perfectAccel > maxBraking) perfectAccel = maxBraking;
					else if (perfectAccel < -maxBraking) perfectAccel = -maxBraking;
					acceleration = perfectAccel;
		    	}
			    if (velocity > maxVelocity || velocity < -maxVelocity) acceleration = 0.0;
		    	velocity += acceleration;
			    if (velocity > maxVelocity)	velocity -= Math.min(maxBraking, velocity - maxVelocity);
		    	if (velocity < -maxVelocity) velocity += Math.min(maxBraking, -velocity - maxVelocity);
		    	double dx = velocity * Math.sin(heading); double dy = velocity * Math.cos(heading);
			    x += dx; y += dy;
			    //boolean updateBounds = false;
	    		//if (dx != 0.0 || dy != 0.0) updateBounds = true;
			    if (slowingDown && velocity == 0.0) { distanceRemaining = 0.0; moveDirection = 0; slowingDown = false; acceleration = 0.0; }
			    //if (updateBounds) updateBoundingBox();
	    		distanceRemaining -= velocity;
				if (x<18 || y<18 || x>battleFieldW-18 || y>battleFieldH-18) {
					distanceRemaining = 0;
					angleToTurn = 0;
					velocity = 0;
					moveDirection = 0;
					x = Math.max(18,Math.min(battleFieldW-18,x));
					y = Math.max(18,Math.min(battleFieldH-18,y));
				}
			}
			//add position
			pos[i] = new MovSimStat(x,y,velocity,heading,Utils.normalRelativeAngle(heading-lastHeading));
		}
		return pos;		
	}
		
}

