package uji;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;

import robocode.AdvancedRobot;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import util.Vector;

public class Antique extends AdvancedRobot
{
	final double gunSpeed=0.34906585039886591538473815369772;
	ArrayList<ScanEvent>scans=new ArrayList<ScanEvent>();
	ScanEvent target;
	double bulletPower=2;
	double lastDir=1;
	boolean firstScan=true;
	double turnAngle;
	double dirOnScan=0;
	long fireTime;
	public void run()
	{
		setTurnRadarRight(Double.MAX_VALUE);
		setAhead(Double.MAX_VALUE);
		setAdjustRadarForRobotTurn(true);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setColors(new Color(245,245,220),new Color(150,113,23),new Color(212,175,55));
		while(true)
		{
			if(scans.size()>=1)
			{
				target=findShortest();
				if(getShortestDistanceToWall()<75)
				{
					setMaxVelocity(getShortestDistanceToWall()*0.1);
					setTurnLeftRadians(180*lastDir);
				}
				else
				{
					setTurnLeftRadians(target.getBearing());
					if(target.getBearing()>0)
						lastDir=-1;
					else
						lastDir=1;
					setMaxVelocity(8);
				}
				for(int i=0;i<scans.size();i++)
				{
					scans.get(i).update();
				}
				doGun();
			}
			execute();
		}
	}
	private double getShortestDistanceToWall()
	{
		double x=Math.min(getX(),getBattleFieldWidth()-getX());
		double y=Math.min(getY(),getBattleFieldHeight()-getY());
		return Math.min(x,y);
	}
	private class ScanEvent
	{
		private double x,y,dist,bearing;
		private String name;
		private Vector speed;
		public ScanEvent(String name,double x,double y,double dist,double bearing,Vector speed)
		{
			this.x=x;
			this.y=y;
			this.dist=dist;
			this.name=name;
			this.bearing=bearing;
			this.speed=speed;
		}
		public double getBearing()
		{
			return bearing;
		}
		public void setBearing(double in)
		{
			bearing=in;
		}
		public double getX()
		{
			return x;
		}
		public double getY()
		{
			return y;
		}
		public void setX(double in)
		{
			x=in;
		}
		public void setY(double in)
		{
			y=in;
		}
		public void setDistance(double in)
		{
			dist=in;
		}
		public double getDistance()
		{
			return dist;
		}
		public String getName()
		{
			return name;
		}
		public Vector getSpeed()
		{
			return speed;
		}
		public void setSpeed(Vector v)
		{
			speed=v;
		}
		public void update()
		{
			x+=speed.x;
			y+=speed.y;
		}
	}
	
	ScanEvent findShortest()
	{
		double lowest=scans.get(0).getDistance();
		int lowestIndex=0;
		for(int i=0;i<scans.size();i++)
		{
			if(scans.get(i).getDistance()<lowest)
			{
				lowest=scans.get(i).getDistance();
				lowestIndex=i;
			}
		}
		return scans.get(lowestIndex);
	}
	void doGun()
	{
		double power;
		if(getEnergy()<10)
			power=getEnergy()/3;
		else
			power=2;
		double[]list=util.Tools.linearPredict(this,getX(),getY(),target.getX(),target.getY(),target.getSpeed(),power);
		util.Tools.shootAt(this,list[0],list[1],power);
	}
	public void onPaint(Graphics2D g)
	{
		g.setColor(Color.red);
		for(int i=0;i<scans.size();i++)
		{
			g.drawOval((int)(getX()+(scans.get(i).getDistance()*Math.sin(Utils.normalAbsoluteAngle(dirOnScan+scans.get(i).getBearing())))-5),(int)(getY()+(scans.get(i).getDistance()*Math.cos(Utils.normalAbsoluteAngle(dirOnScan+scans.get(i).getBearing())))-5),10,10);
		}
	}
	public void onScannedRobot(ScannedRobotEvent e)
	{
		boolean found=false;
		for(int i=0;i<scans.size();i++)
		{
			if(scans.get(i).getName().equals(e.getName()))
			{
				scans.get(i).setBearing(e.getBearingRadians());
				scans.get(i).setDistance(e.getDistance());
				scans.get(i).setX(getX()+(e.getDistance()*Math.sin(Utils.normalAbsoluteAngle(getHeadingRadians()+e.getBearingRadians()))));
				scans.get(i).setY(getY()+(e.getDistance()*Math.cos(Utils.normalAbsoluteAngle(getHeadingRadians()+e.getBearingRadians()))));
				scans.get(i).setSpeed(new Vector(0,0,e.getVelocity()*Math.sin(e.getHeadingRadians()),e.getVelocity()*Math.cos(e.getHeadingRadians())));
				
				found=true;
				break;
			}
		}
		if(!found)
		{
			scans.add(new ScanEvent(e.getName(),
					getX()+(e.getDistance()*Math.sin(Utils.normalAbsoluteAngle(getHeadingRadians()+e.getBearingRadians()))),
					getY()+(e.getDistance()*Math.cos(Utils.normalAbsoluteAngle(getHeadingRadians()+e.getBearingRadians()))),
					e.getDistance(),
					e.getBearingRadians(),
					new Vector(0,0,e.getVelocity()*Math.sin(e.getHeadingRadians()),e.getVelocity()*Math.cos(e.getHeadingRadians()))));
		}
	}
	public void onHitRobot(HitRobotEvent e)
	{
		back(40);
		setAhead(Double.MAX_VALUE);
	}
	public void onRobotDeath(RobotDeathEvent e)
	{
		for(int i=0;i<scans.size();i++)
		{
			if(scans.get(i).getName().equals(e.getName()))
			{
				scans.remove(i);
				break;
			}
		}
	}
	public void onHitWall(HitWallEvent e)
	{
		setMaxVelocity(8);
		turnRight(e.getBearing()+180);
		ahead(50);
		setAhead(Double.MAX_VALUE);
	}
}
