package bayen.nut;
import robocode.*;
import robocode.util.*;
import java.util.*;
import java.awt.geom.*;
import java.awt.Color;
import java.awt.Graphics2D;
import java.lang.String;
import java.awt.*;
import java.io.*;

/**
 * AcornSlingshot - Squirrel's gun
 */
public class AcornSlingshot
{
	AdvancedRobot Squirrel;
	ScannedRobotEvent lastScan;
	static double BULLET_POWER = 3.0;
	RobotState me, target; // these aren't static,
	                       //so they will be reset every round
	static Vector guns; // this Vector (and all its
	                    //contents) will persist from round to round
	static Vector virtualBullets = new Vector();
	Rectangle2D.Double battlefield;
	boolean gameOver = false;
	boolean starting = true;
	static double shots = 0;
	static double hits = 0;
	static double accuracy = 1.0;
	boolean firing = true;
	static Gun bestGun;
	static double firepower = 3;
	static double weightn = 20;
	static boolean TC;
	
	public AcornSlingshot(AdvancedRobot robot, boolean TC) {
		Squirrel = robot;
		this.TC = TC;
		renderables = new Vector();
	}

	public void onPaint(Graphics2D g){
		/*Iterator j = guns.iterator();
		while(j.hasNext()){
			Gun gun = (Gun) j.next();
			gun.onPaint(g);
		}
		Iterator i = renderables.iterator();
		while(i.hasNext()){
			Renderable r = (Renderable) i.next();
			r.render(g);
		}
		renderables.clear();*/
		
		if(!gameOver){
		Iterator i = virtualBullets.iterator();
		while(i.hasNext()){
			VirtualBullet virtualBullet = (VirtualBullet) i.next();
			g.setColor(virtualBullet.gunUsed.getColor());
			g.fillOval((int)virtualBullet.x - 3, (int)virtualBullet.y
			-3, 6, 6);
		}}
		
		int numberOfGuns = guns.size();
		for(int j = 0; j < numberOfGuns; j++){
			Gun gun = (Gun) guns.elementAt(j);
			g.setColor(Color.WHITE);
			String strAccuracy = gun.accuracy + " ";
			g.drawString(gun.getName() + ": " + gun.hits + (gun == bestGun?" BEST GUN":""), 20, 5 + j*15);
			g.setColor(gun.getColor());
			g.fillOval(5, 5 + j * 15, 10, 10);
		}
	}
	
	public void run() {
		if(Squirrel.getOthers() > 1)
		weightn = 3;
		battlefield = new Rectangle2D.Double(0,0,Squirrel.getBattleFieldWidth(), Squirrel.getBattleFieldHeight());
		
		if(guns == null){
			guns = new Vector();
			
			Gun defaultGun = new GFGun1();
			defaultGun.hits = 1;
			defaultGun.accuracy = 1.01;
			guns.add(defaultGun);
			//guns.add(new GFGun2());
			//guns.add(new GFGun3());
			//guns.add(new GFGun4());
			guns.add(new GFGun5());
			//guns.add(new AntiSurfGun1());
			//guns.add(new AntiSurfGun2());
			//guns.add(new AntiSurfGun3());
			//guns.add(new GFGun());
			//guns.add(new CTGun());
			//guns.add(new LTGun());
			//guns.add(new HeadOnGun());
			//guns.add(new LTGunTwo());
			//guns.add(new RTGun());
			if(bestGun == null)
		bestGun = defaultGun;
		}
		
		System.out.println("Using " + bestGun.getName());
		virtualBullets.clear();
		Iterator i = guns.iterator();
		while(i.hasNext()){
			Gun gun = (Gun) i.next();
			gun.run(Squirrel);
		}
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		if(Squirrel.getTime()<30){
		lastScan = e;
		starting = true;
		}
		else {
			starting = false;
		}
		Iterator j = guns.iterator();
		while(j.hasNext()){
			Gun gun = (Gun) j.next();
			gun.onScannedRobot(e);
		}
		me = new RobotState();
		me.name = Squirrel.getName();
		me.velocity = Squirrel.getVelocity();
		me.heading = Squirrel.getHeadingRadians();
		me.x = Squirrel.getX();
		me.y = Squirrel.getY();
		// Create a new RobotState object to represent the enemy's current state
		target = new RobotState();
		target.setLocation(me.project(e.getBearingRadians() + Squirrel.getHeadingRadians(), e.getDistance()));
		target.heading = e.getHeadingRadians();
		target.velocity = e.getVelocity();
		target.name = e.getName();
		//drawLine(new Point2D.Double(me.x,me.y),new Point2D.Double(target.x,target.y),Color.blue);
		BULLET_POWER = (TC?3.0:Squirrel.getEnergy() / (e.getDistance() / 25));
		if(BULLET_POWER < 0.1)
		BULLET_POWER = 0.1;
		if(BULLET_POWER > 3.0)
		BULLET_POWER = 3.0;
			//Move each virtual bullet forward one tick. After moving, check if they are off the field or near the target.
			Iterator i = virtualBullets.iterator();
			while(i.hasNext()){
				VirtualBullet virtualBullet = (VirtualBullet) i.next();
				virtualBullet.setLocation(virtualBullet.project(virtualBullet.heading, virtualBullet.velocity));
				if(!gameOver)
				if(virtualBullet.distance(target) < 25){ //check if the virtual bullet "hit" the enemy
					//if(virtualBullet.gunUsed == bestGun /*&& !firing*/)
				    //accuracy = rollingAverage(accuracy, 1, 5);
					virtualBullet.gunUsed.hits += 1;
					//System.out.println(virtualBullet.gunUsed.getName() + " at " + Squirrel.getTime() + " hit.");
					//System.out.println(virtualBullet.gunUsed.accuracy);
					virtualBullet.gunUsed.accuracy = rollingAverage(virtualBullet.gunUsed.accuracy, 1.0, weightn);
					//System.out.println(virtualBullet.gunUsed.accuracy);
					i.remove();
				} else if(!battlefield.contains(virtualBullet)){ //check if the virtual bullet is off the field\\
				//} else if(virtualBullet.distance(me) < lastScan.getDistance()) {
					//if(virtualBullet.gunUsed == bestGun /*&& !firing*/)
					//accuracy = rollingAverage(accuracy, 0, 5);
					//System.out.println(virtualBullet.gunUsed.getName() + " at " + Squirrel.getTime() + " missed.");
					//System.out.println(virtualBullet.gunUsed.accuracy);
					virtualBullet.gunUsed.accuracy = rollingAverage(virtualBullet.gunUsed.accuracy, 0, weightn);
					//System.out.println(virtualBullet.gunUsed.accuracy);
					i.remove();
				}
			}
			
			if(target != null) gun(e);
			lastScan = e;
	}
	public void onDeath(DeathEvent e){
		endRound();
	}
	
	public void onWin(WinEvent e){
		endRound();
	}
	
	public void endRound(){
		Iterator i = guns.iterator();
		//Squirrel.out.println();
		//Squirrel.out.println("Virtual bullet hit table");
		//Squirrel.out.println("------------------------");
		while(i.hasNext()){
			Gun gun = (Gun) i.next();
			String strAccuracy = gun.accuracy + " ";
			gun.endRound();
			//Squirrel.out.println(gun.getName() + ": " + strAccuracy.subSequence(2,4) + "." + strAccuracy.subSequence(4,6) + "%");
		}
		//Squirrel.out.println();
		
		//So we don't keep firing
		target = null;
		gameOver = true;
	}
	public void gun(ScannedRobotEvent e){
		
		//Select the best gun
		double bestScore = -1;
		bestGun = null;
		Iterator i = guns.iterator();
		while(i.hasNext()){
			Gun gun = (Gun) i.next();
			if(gun.hits > bestScore){
				bestScore = gun.hits;
				bestGun = gun;
			}
		}
		
		//select Bullet Power
		/*
		if(accuracy > .4)
		BULLET_POWER = 3.0;
		else if(accuracy > .2)
		BULLET_POWER = 2.0;
		else if(accuracy > .05)
		BULLET_POWER = 1.0;
		else
		BULLET_POWER = 0.1;*/
		//BULLET_POWER = Math.min(3.0, accuracy * (100 - e.getDistance() / 10));
		//if(Squirrel.getEnergy() / 5 > BULLET_POWER)
		//BULLET_POWER = Squirrel.getEnergy() / 5;
		//BULLET_POWER = 3.0;
		//BULLET_POWER = Math.min(BULLET_POWER, Squirrel.getEnergy() - .1);
		// create new virtual bullets only if we actually
		// fired this turn
		boolean virtualFire = false;
		//if(accuracy < .75 && Squirrel.getEnergy() <= 5) firing = false;
		//if(accuracy >=.75 || Squirrel.getEnergy() > 5) firing = true;
		if(e.getEnergy() == 0)
		BULLET_POWER = 0.1;
		Squirrel.setTurnGunRightRadians(
		normalizeRelativeAngle(bestGun.getFiringAngle(BULLET_POWER) - 
		Squirrel.getGunHeadingRadians()));
		RobotState tempState = target;
		tempState.setLocation(me.project(bestGun.getFiringAngle(BULLET_POWER),500000));
		//drawLine(new Point2D.Double(me.x,me.y),new Point2D.Double(tempState.x,tempState.y),Color.blue);
		drawText(bestGun.getName(),me.x+25,me.y+25,Color.white);
			if((firing && Squirrel.getEnergy() > BULLET_POWER) || e.getEnergy() == 0 || TC){
		if(Squirrel.getGunTurnRemaining() < 100){
		Bullet b = Squirrel.setFireBullet(BULLET_POWER);
		virtualFire = false;
		if(b!= null) virtualFire = true;}}
		//else if(Squirrel.getTime()%16==0) virtualFire = true;
		//else virtualFire = false;
		//virtualFire = true;
		if(virtualFire){
			shots++;
			//System.out.println("BEST GUN: " + bestGun.getName());
			//System.out.println("BULLET POWER: " + BULLET_POWER);
			//Squirrel.out.println(hits/shots);
			i = guns.iterator();
			while(i.hasNext()){
				Gun gun = (Gun) i.next();
				gun.shoot(BULLET_POWER);
				VirtualBullet newVirtualBullet = new VirtualBullet();
				newVirtualBullet.setLocation(me);
				newVirtualBullet.heading = gun.getFiringAngle(3);
				newVirtualBullet.velocity = 20.0 - 3.0 * BULLET_POWER;
				newVirtualBullet.gunUsed = gun;
				virtualBullets.add(newVirtualBullet);
			}
		}
	}
	//Draw the virtual bullets on screen - this will
	// only work with a recent version of robocode
	// and "Paint" turned on in the robot's console
	//public void onPaint(Graphics2D g){
		/*
		if(!gameOver){
		Iterator i = virtualBullets.iterator();
		while(i.hasNext()){
			VirtualBullet virtualBullet = (VirtualBullet) i.next();
			g.setColor(virtualBullet.gunUsed.getColor());
			g.fillOval((int)virtualBullet.x - 3, (int)virtualBullet.y
			-3, 6, 6);
		}}
		
		int numberOfGuns = guns.size();
		for(int j = 0; j < numberOfGuns; j++){
			Gun gun = (Gun) guns.elementAt(j);
			g.setColor(Color.WHITE);
			String strAccuracy = gun.accuracy + " ";
			g.drawString(gun.getName() + ": " + gun.hits + (gun == bestGun?" BEST GUN":""), 20, 5 + j*15);
			g.setColor(gun.getColor());
			g.fillOval(5, 5 + j * 15, 10, 10);
		}*/
	//}
	
	//This method ensures that angles are between -180 and 180 degrees, for turning radar / gun 
	public static double normalizeRelativeAngle(double angle){
		while(angle <= -Math.PI){
			angle += 2.0 * Math.PI;
		}
		while(angle > Math.PI){
			angle -= 2.0 * Math.PI;
		}
		return angle;
	}
	public void onBulletHit(BulletHitEvent e) {
		Iterator j = guns.iterator();
		while(j.hasNext()){
			Gun gun = (Gun) j.next();
			gun.onBulletHit(e);
		}
		hits++;
		accuracy = rollingAverage(accuracy, 1, weightn);
		//accuracy = rollingAverage(accuracy, 1, 5);
	}
	public void onBulletMissed(BulletMissedEvent e) {
		accuracy = rollingAverage(accuracy, 0, weightn);
		//accuracy = rollingAverage(accuracy, 0, 5);
	}
	private double normalRelativeAngle(double angle) {
        angle = Math.toRadians(angle);
        return Math.toDegrees(Math.atan2(
               Math.sin(angle), Math.cos(angle))); 
    }
	public double rollingAverage(double oldVal, double newVal, double weight) {
		//if(newVal == 0) System.out.println("LOWERED:");
		//else System.out.println("HIGHTENED:");
		//System.out.println("OLD: " + oldVal);
		//System.out.println("NEW: " + ((weight - 1.0) * oldVal + newVal) / weight);
		return ((weight - 1.0) * oldVal + newVal) / weight;
	}
public static abstract class Renderable{
	public abstract void render(Graphics2D g);
	
	public static class Circle extends Renderable{
		Point2D.Double center;
		double radius;
		Color color;
		public Circle(Point2D.Double center, double radius, Color color){
			this.center = center;
			this.radius = radius;
			this.color = color;
		}
		public void render(Graphics2D g) {
			g.setColor(color);
			g.drawOval(	(int)Math.round(center.x - radius),
						(int)Math.round(center.y - radius),
						(int)Math.round(2 * radius),
						(int)Math.round(2 * radius));
		}
	}
	
	public static class Dot extends Renderable{
		Point2D.Double point;
		double radius;
		Color color;
		public Dot(Point2D.Double point, Color color){
			this.point = point;
			this.radius = 2;
			this.color = color;
		}
		public void render(Graphics2D g) {
			g.setColor(color);
			g.fillOval(	(int)Math.round(point.x - radius),
						(int)Math.round(point.y - radius),
						(int)Math.round(2 * radius),
						(int)Math.round(2 * radius));
		}
	}
	
	public static class Line extends Renderable{
		Point2D.Double p1, p2;
		Color color;
		
		double radius;
		public Line(Point2D.Double p1, Point2D.Double p2, Color color){
			this.p1 = p1;
			this.p2 = p2;
			this.color = color;
		}
		public void render(Graphics2D g) {
			g.setColor(color);
			g.drawLine(	(int)Math.round(p1.x),
						(int)Math.round(p1.y),
						(int)Math.round(p2.x),
						(int)Math.round(p2.y));
		}
	}
	
	public static class Text extends Renderable{
		String text;
		double x, y;
		Color color;
		
		double radius;
		public Text(String text, double x, double y, Color color){
			this.text = text;
			this.x = x;
			this.y = y;
			this.color = color;
		}
		public void render(Graphics2D g) {
			g.setColor(color);
			g.drawString(text, (float)x, (float)y);
		}
	}
	}
	
	
	
	public static Vector renderables;
	
	
	public static void drawLine(Point2D.Double p1, Point2D.Double p2, Color color){
		renderables.add(new Renderable.Line(p1, p2, color));
	}
	
	public static void drawCircle(Point2D.Double center, double radius, Color color){
		renderables.add(new Renderable.Circle(center, radius, color));
	}
	
	public static void drawPoint(Point2D.Double p1, Color color){
		renderables.add(new Renderable.Dot(p1, color));
	}
	
	public static void drawText(String text, double x, double y, Color color){
		renderables.add(new Renderable.Text(text, x, y, color));
	}
}