/*
 * Copyright (c) 2004 Marcin Fuszara
 */  
package fushi.PvP1;
import robocode.*;
import java.awt.Color;

/* This robot assumes that it is put on arena with only one
 * opponent; otherwise it's behaviour may be weird;
 * arena should be rather small, say <=1000x1000;
 */
public class PvP1 extends AdvancedRobot
{
   // robot's body logic
   Body body;
   // robot's gun logic
   Gun gun;
   // robot's scanner logic
   Scanner scanner;
   // enemy tracked in one-on-one battle  
   static Enemy enemy = null;
   
   // movement manager switching the robot's movement strategies
   MovementManager movementManager;
   // targeting manager switching the robot's targeting strategies
   TargetingManager targetingManager;
   // logic used when the robot wins
   MiddleFingerLogic middleFingerLogic;
   
   /* this variable is set to true when the robot wins;
    * it determines the logic used for the robot; after win, the robot
    * can make a death dance
    */
   boolean won = false;
   
   /* main robot method
    */
	public void run() 
	{
      // set up the logger
      loggerSetup();
      // set up colors, adjusts, logic systems
		setup();
   	// run the loop
		mainLoop();
	}
	
   /* add proper logger sources
    */
   void loggerSetup()
   {
      Logger.setRobot( this );
      Logger.disableAll();
      
      // general logs
      Logger.enable( "info" );
      //Logger.enable( "death" );
      Logger.enable( "skipturn" );
      
      // body logs
      //Logger.enable( "clipping" );
      //Logger.enable( "goTo" );
      //Logger.enable( "block" );
      
      // sector movement logs
      //Logger.enable( "secmov" );
      
      // linear targeting logs
      //Logger.enable( "lintar" );
      
      // pattern matching targeting logs
      //Logger.enable( "pattar" );
      
      // temporary logs
   }
	
	/* prepare systems;
	 * setup colors, adjusts;
	 */
	void setup()
	{
      // set robot colors
      setColors(Color.orange,Color.orange,Color.orange);
      // make gun and radar move independently of each other and the robot body
      setAdjustGunForRobotTurn( true );
      setAdjustRadarForRobotTurn( true );
      setAdjustRadarForGunTurn( true );

      /*
       * prepare logic
       */
        
      // create tracked enemy only if it the first round
      if ( enemy == null )
         enemy = new Enemy( this );
      else // it one of the next round; reset enemy
         enemy.newRound(); 
      
      // create new logic elements
      body = new Body( this );
      gun = new Gun( this );
      scanner = new Scanner( this, enemy );

      // create movement manager
      movementManager = new MovementManager( this, body, enemy );
      // create targeting manager
      targetingManager = new TargetingManager( this, gun, enemy );
      
      // create logic used when the robot wins
      middleFingerLogic = new MiddleFingerLogic( this, body );
   }
      
   /* the main robot logic loop
    */
   void mainLoop()
   {
      while ( true ) {
         if ( won )  // plan death dance
            winLogic();
         else        // destroy the enemy
            commonLogic();

         // finalize my turn
         execute();
      }
   }
   
   /* common logic is played normally during battle
    * and is used to destroy the opponent
    */
   void commonLogic()
   {
      // prepare orders
      movementManager.run();
      targetingManager.run();
      
      // perform actions
      body.run();
      gun.run( body.getNextPosition(), body.getNextHeading() );
      scanner.run( body.getNextPosition() );
   }
   
   /* win logic is played after the robot won the battle
    */
   void winLogic()
   {
      middleFingerLogic.run();
   }
   
   /*
    * event handlers
    * these redirect event to logic systems that need them
    */
    
   public void onScannedRobot( ScannedRobotEvent e )
   {
      enemy.onScannedRobot( e );
   }
   
   public void onHitRobot( HitRobotEvent e )
   {
      movementManager.onHitRobot( e );
   }
   
   public void onHitWall( HitWallEvent e )
   {
      movementManager.onHitWall( e );
   }
   
   public void onHitByBullet( HitByBulletEvent e )
   {
      movementManager.onHitByBullet( e );
   }
   
   public void onBulletHit( BulletHitEvent e )
   {
      targetingManager.onBulletHit( e );
   }
   
   public void onBulletHitBullet( BulletHitBulletEvent e )
   {
      targetingManager.onBulletHitBullet( e );
   }
   
   public void onBulletMissed( BulletMissedEvent e )
   {
      targetingManager.onBulletMissed( e );
   }
   
   static long numWins = 0;
   static long numDeaths = 0;
   static long livedForSum = 0;
   public void onDeath( DeathEvent e )
   {
      livedForSum += e.getTime();
      numDeaths++;
      Logger.log( "death", "numWins " + Long.toString( numWins ) +
                          " numDeaths " + Long.toString( numDeaths ) );
      Logger.log( "death", "Lived for " + Long.toString( e.getTime() ) );
      Logger.log( "death", "Lived for average " + Long.toString( livedForSum/numDeaths ) );
   }
   
   public void onWin( WinEvent e )
   {
      numWins++;
      // remember that the robot won; the death dance will be made
      won = true;
   }
   
   public void onSkippedTurn( SkippedTurnEvent e )
   {
      Logger.log( "skipturn", "Turn skipped" );
   }
  
}
