package kawigi.sbf;
import robocode.*;
import java.awt.geom.*;
import java.awt.*;
import java.util.Vector;
import java.io.*;
import java.util.zip.*;
/**
 * FloodMini - FloodMicro with a statist-type gun, inspired from things I read about SandboxDT/Lump's
 * former gun and some ideas based on my own work and an old version of Gouldingi's gun.
 * 1.0 - FloodMicro 1.2's movement, stat gun segmented on distance (25 segments) and lateral velocity (5 segments)
 * 1.1 - tweaked movement, reduced codesize, tweaked gun, FloodMicro 1.3's movement
 * 1.2 - added segmentation to seperate out statistics taken when my opponent was approaching a wall.  This is enough to just give it the edge against Cigaret and a few other robots.
 * 1.3 - Tuned the movement, added segmentation to seperate out stats between when my opponent is accelerating, decelerating, or moving at a roughly constant speed, went down to 3 lateral velocity and 10 distance segments
 * 1.4 - found some ways to shrink the movement.  Fixed a problem that caused 1.3 to run extremely slowly on some systems/JVMs.  Starting to segment stats on projected bullet travel time instead of distance, and made the MiniBullet class support multiple speeds.  Adding a little 'strategy', too
**/
public class FloodMini extends AdvancedRobot
{
	static int currentDirection=30;
	static double currentEnergy;
	static double lastv;
	static int distanceindex;
	static int nextTime, hitTime;
	static double[] benefit, penalty;
	static int[][][][][] stats;
	static Vector ovbullets;
	static int direction = 1;
	static String name;
	
	public boolean out(double x, double y, double angle, double c)
	{
		return !(new Rectangle2D.Double(18D, 18D, getBattleFieldWidth()-36D,  getBattleFieldHeight()-36D)).contains(Math.sin(angle)*c+x, Math.cos(angle)*c+y);
	}

	public void run()
	{
		ovbullets = new Vector();
		Color blue;
		setColors(blue = Color.blue, blue, blue);
		setAdjustGunForRobotTurn(true);
		turnRadarRight(Double.POSITIVE_INFINITY);
	}
	
	public void onScannedRobot(ScannedRobotEvent e)
	{
		if (name == null)
		{
			name = e.getName();
			try
			{
				ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(getDataFile(name))));
				benefit = (double[])in.readObject();
				penalty = (double[])in.readObject();
				stats = (int[][][][][])in.readObject();
				in.close();
			}
			catch (Exception ex)
			{
				// wall, accl, latv, distance, guessfactors 
				stats = new int[2][3][3][10][31];
				benefit = new double[26];
				penalty = new double[26];
			}
		}
		double absbearing;
		double latvel = Math.sin(e.getHeadingRadians()-(absbearing = getHeadingRadians() + e.getBearingRadians()))*lastv;
		setTurnRadarLeft(getRadarTurnRemaining());
		double distance;
		distanceindex = (int)(distance = e.getDistance())/50;
		double myx, myy;
		double denergy;
		int rel = 90;
		if (distance < findDistanceBracket()-120)
			rel = 90+currentDirection;
		if (out(myx = getX(), myy = getY(), Math.PI+absbearing, 50) || distance > findDistanceBracket() || getEnergy()/currentEnergy >= 7 || closeToCorner())
			rel = 90-currentDirection;
		if (hitTime < 0 && currentEnergy == 0)
			rel = 90-currentDirection*3;
		setTurnRight(e.getBearing()-rel);
		nextTime--;
		hitTime--;
		if ((denergy = currentEnergy-(currentEnergy = e.getEnergy())) > 0 && denergy <= 3)
		{
			benefit[distanceindex] += denergy;
			if (nextTime <= 0)
			{
				currentDirection *= (Math.random() < .5)?-1:1;
				nextTime = (hitTime = (int)(distance/(20-3*denergy)))>>1;
				setMaxVelocity(2+Math.random()*20);
			}
		}
		
		int i=0;
		
		//accl basically ends up being 0 for not strongly accelerating/decelerating, 1 for accelerating, 2 for decelerating.
		int accl = (int)Math.round(Math.abs(lastv)-Math.abs(lastv = e.getVelocity()));
		if (accl != 0)
			accl = (accl < 0)? 1 : 2;
		
		if (latvel != 0)
			direction = (latvel < 0)?-1:1;
		//my attempted stat-gun:
		
		int latv = (int)Math.abs(latvel/3);
		//the way I was doing this before turned out to be more expensive than adding more parameters to the out function.
		double x, y;
		rel = (out(x = myx+Math.sin(absbearing)*distance, y = myy+Math.cos(absbearing)*distance, e.getHeadingRadians(), (lastv < 0) ? -80 : 80)) ? 1 : 0;
		i=0;
		while (i < ovbullets.size())
		{
			MiniBullet b = (MiniBullet)ovbullets.elementAt(i);
			int ind;
			if ((ind = Math.min(30, b.updateEnemy(x, y, getTime()))) >= 0)
			{
				stats[b.wallrel][b.accl][b.latspeed][b.dindex][ind]++;
				ovbullets.removeElementAt(i);
			}
			else
				i++;
		}
		int bestindex = 15;
		int dindex2;
		//latvel is now the bullet speed, denergy is now my bullet power:
		int[] current = stats[rel][accl][latv][dindex2 = (int)(distance/10/(latvel = 20-(denergy = Math.min(Math.min(currentEnergy, getEnergy())/4, 3))*3))];
		i=0;
		if (currentEnergy > 0)
			do
			{
				if (current[i] > current[bestindex])
					bestindex = i;
				i++;
			}
			while(i<31);
		double realdirection;
		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absbearing-getGunHeadingRadians()+(realdirection = Math.asin(9/latvel)*direction)*(bestindex/15.0-1)));
		if (currentEnergy > 0 && Math.abs(getGunTurnRemaining()) < 5)
		{
			Bullet b = setFireBullet(denergy);
			if (b != null)
				penalty[distanceindex] += denergy;
		}
		//turns out that initializing the bullet this way saves only 3 bytes less codesize as it took to make the 
		//bullet variable-speed and segment on projected bullet travel time instead of distance.  Pretty cool, huh?
		MiniBullet mb;
		ovbullets.addElement(mb = new MiniBullet());
		mb.dindex = dindex2;
		mb.accl = accl;
		mb.latspeed = latv;
		mb.wallrel = rel;
		mb.startgunheading = absbearing;
		mb.direction = realdirection;
		mb.startx = myx;
		mb.starty = myy;
		mb.lastx = x;
		mb.lasty = y;
		mb.firetime = mb.lasttime = getTime();
		mb.bulletspeed = latvel;
		if (out(myx, myy, getHeadingRadians(), currentDirection))
			currentDirection = -currentDirection;
		setAhead(currentDirection);
	}
	
	private boolean closeToCorner()
	{
		int i=0;
		do
		{
			if (Point2D.distance(getX(), getY(), (i&1)*getBattleFieldWidth(), (i>>1)*getBattleFieldHeight()) < 200)
				return true;
			i++;
		}
		while (i < 4);
		return false;
	}
	
	public void onHitByBullet(HitByBulletEvent e)
	{
		double power = e.getPower();
		currentEnergy += power*3;
		penalty[distanceindex] += Math.max(power*7, power*9-2);
	}
	
	public void onBulletHit(BulletHitEvent e)
	{
		double power = e.getBullet().getPower();
		double damage;
		currentEnergy -= (damage = Math.max(4*power, 6*power-2));
		benefit[distanceindex] += damage+power*3;
	}
	
	public int findDistanceBracket()
	{
		int bestindex;
		int i = bestindex = 4;
		do
		{
			if (findBenefit(i) > findBenefit(bestindex))
				bestindex = i;
			i++;
		}
		while (i <= 14);
		return bestindex*50+85;
	}
	
	public double findBenefit(int index)
	{
		return (benefit[index]-penalty[index])/(benefit[index]+penalty[index]);
	}
	
	public void onWin(WinEvent e)
	{
		try
		{
			ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream(new RobocodeFileOutputStream(getDataFile(name))));
			out.writeObject(benefit);
			out.writeObject(penalty);
			out.writeObject(stats);
			out.close();
		}
		catch (IOException ex)
		{
		}
	}
}
