/*
 * Written by Kinsen Choy
 */

package kinsen.melee.Guns;
import kinsen.melee.Details;
import kinsen.melee.Utils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;

/*
 * PatternMatching - A gun class that fires circularly predicted bullets.
 */
public class PatternMatching extends Gun
{
	// Last enemy details
	private Details enemy = null;
	// Average enemy turn
	private double enemyTurn = -11;
	// Last my details
	private Details me = null;

	private String patterns = "";

	private ArrayList x = new ArrayList();
	private ArrayList y = new ArrayList();

	public void calculateGun(double initialFirePower)
	{
		calculateGun(initialFirePower, true);
	}

	public void calculateGun(double initialFirePower, boolean canChangePower)
	{
		// If there is no data then it can not fire
		if (enemy != null)
		{
			// Sets target location and fire power
			firePower = initialFirePower;
			String startPatterns;
			if (patterns.length() > 10)
				startPatterns = patterns.substring(patterns.length() - Math.min(patterns.length() / 5, 100));
			else
				startPatterns = Character.toString(getPatternIndex(enemy.getVelocity(), enemyTurn));
			int initialPosition = -1;
			double newX = enemy.getX();
			double newY = enemy.getY();
			double bulletDistance = 0;
			int numTries = 0;

			int time = 0;

			int searchPosition = 0;
			String searchList = patterns;
			if (patterns.length() > startPatterns.length())
				searchList = patterns.substring(0, patterns.length() - startPatterns.length());

			while (numTries < 5 && (initialPosition > -1 || numTries == 0) && Utils.distance(me.getX(), me.getY(), newX, newY) > bulletDistance)
			{
				// Number of tries to find long pattern
				numTries++;

				int lastStart;
				if (initialPosition != -1)
					lastStart = initialPosition - 1;
				else
					lastStart = searchList.length() - 1;

				while (initialPosition == -1 && startPatterns.length() > 3)
				{
					initialPosition = searchList.lastIndexOf(startPatterns, lastStart);
					if (initialPosition == -1 || startPatterns.length() > 3)
						startPatterns = startPatterns.substring(1);
				}

				if (initialPosition != -1)
				{
					// Reset variables
					bulletDistance = 0;
					double bulletVelocity = 20 - 3 * firePower;
					newX = enemy.getX();
					newY = enemy.getY();
					double newHeading = enemy.getHeading();
					int currentPosition = initialPosition + searchPosition;
					time = 0;
					// Debug lines
					x.clear();
					y.clear();
					// Iterate through patterns
					while (currentPosition != -1 && currentPosition < patterns.length() && Utils.distance(me.getX(), me.getY(), newX, newY) > bulletDistance)
					{
						bulletDistance += bulletVelocity;
						char patternType = patterns.charAt(currentPosition);
						double velocity = getPatternVelocity(patternType);
						double turn = getPatternTurn(patternType);
						double checkX = newX + Math.sin(Math.toRadians(newHeading)) * velocity;
						double checkY = newY + Math.cos(Math.toRadians(newHeading)) * velocity;
						// If it will be out of bounds then skip patterns that go out of bounds
						if (!Utils.outOfBounds(checkX, checkY))
						{
							newX = checkX;
							newY = checkY;
							newHeading += turn;
							time++;
							// Debug lines
							x.add(new Double(newX));
							y.add(new Double(newY));
						}
						currentPosition++;
					}
				}
			}

			if (canChangePower)
				firePower = Math.max(Math.min((20 - (Utils.distance(me.getX(), me.getY(), newX, newY) / time)) / 3, 3), 0.1);
			fireAt = new Point((int) newX, (int) newY);
		}
	}

	public void recordData(Details enemyDetails, Details myDetails, long time)
	{
		// If there is previous data then calculate turn
		if (enemy != null)
			enemyTurn = enemyDetails.getHeading() - enemy.getHeading();
		enemy = enemyDetails;
		me = myDetails;

		// Calculate new pattern
		if (enemyTurn != -11)
		{
			char patternIndex = getPatternIndex(enemy.getVelocity(), enemyTurn);
			patterns += patternIndex;
		}
	}

	/*
	 * getPatternIndex: Returns the velocity and turn index
	 */
	private char getPatternIndex(double velocity, double turn)
	{
		// Make all the values positive
		// 0 - 16
		int adjustedVelocity = (int) Math.round(velocity) + 8;
		// 0 - 20
		int adjustedTurn = (int) Math.round(turn) + 10;
		// (00 - 1600) + (0 - 20)
		char returnChar = (char) (adjustedVelocity * 100 + adjustedTurn);
		return returnChar;
	}

	/*
	 * getPatternTurn: Returns the turn from the pattern type
	 */
	private int getPatternTurn(char patternType)
	{
		// Adjust for positive adjust
		return ((int) patternType) % 100 - 10;
	}

	/*
	 * getPatternVelocity: Returns the velocity from the pattern type
	 */
	private int getPatternVelocity(char patternType) 
	{
		// Adjust for positive adjust
		return (((int) patternType) - getPatternTurn(patternType)) / 100 - 8;
	}

	/*
	 * debug: Draws predicted path
	 */
	public void debug(Graphics2D g)
	{
		g.setColor(Color.red);
		for (int i = 0; i < x.size(); i++)
		{
			g.drawOval((int) ((Double) x.get(i)).doubleValue() - 4, (int) ((Double) y.get(i)).doubleValue() - 4, 8, 8);
		}
	}
}