/*
Flick v1.0 by Sheldor.  10/10/2024  249 bytes
a nanobot with multimode movement and linear targeting
v1.0 -- survivalist strategy, movement from RaikoNano and Yatagan

Credits:
	wiki.nano.RaikoNano, jk.sheldor.nano.Yatagan
Also, a general thanks to all open source bot authors and contributors to the RoboWiki.

Flick is open source and released under the terms of the RoboWiki Public Code License (RWPCL) - Version 1.1.
see license here: https://robowiki.net/wiki/RWPCL
*/

package wiki.nano;
import robocode.*;
import robocode.util.Utils;
import java.awt.geom.Rectangle2D;

public class Flick extends AdvancedRobot {
	static double direction = 1, movementMode, enemyEnergy;
	static int deathCount;
	
   public static final char NO_FLIP = 65535;
   public static final char FLIP = 0;
   public static final char RANDOM_FLIP = 16;

	public void run() {
		setTurnRadarRight(Double.POSITIVE_INFINITY);
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		double v1, v2, offset = (2.0 / 1);
		
		setTurnGunRightRadians(Utils.normalRelativeAngle((v1 = getHeadingRadians() + e.getBearingRadians()) + 
				Math.asin(e.getVelocity() / 19.7 * Math.sin(e.getHeadingRadians() - v1))
				- getGunHeadingRadians()));
		
		//wall smoothing based on RaikoNano's
		do{}while(!new Rectangle2D.Double(18,18,764,564).
					contains(getX() + 160 * Math.sin(v2 = (v1 + ((direction) * (offset -= .02)))), getY() + 160 * Math.cos(v2)));
		
		setFire(210 / (int)e.getDistance());
	
	//multimode movement based on Yatagan's
	if(((double)chancesOfReversing.charAt(deathCount + (100 + (int)(enemyEnergy - (enemyEnergy = e.getEnergy()))))
		* Math.random()) < 1 || offset < 0.7) {
			direction = -direction;
		}
		setTurnRightRadians(Math.tan(v2 -= getHeadingRadians()));
		setAhead(Math.cos(v2) / 0);
		
		setTurnRadarLeft(getRadarTurnRemaining());
	}
	
	public void onDeath(DeathEvent e){
		deathCount += 127;
	}

   public static final String ONE_WAY_ORBIT = "" + 
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +	   	   
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP;
 
   //SHELDOR:  Because this will be part of a larger string, we should start from 1 instead of 0.
   public static final String REVERSE_ON_ENEMY_FIRE = "" + 
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       FLIP    + FLIP    + FLIP    + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP + NO_FLIP +
       NO_FLIP + NO_FLIP;
 
   public static final String RANDOM = "" +
       RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP +
       RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP +
       RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP +
       RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP +
       RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP +
      RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP +
       RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP +
       RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP +
       RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP +
       RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP +
       RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP +
      RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP +
       RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP +
       RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP +
       RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP +
       RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP +
      RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP +
       RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP +
       RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP +
       RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP +
       RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP +
      RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP +
       RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP +
       RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP +
       RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP +
       RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP + RANDOM_FLIP +
       RANDOM_FLIP + RANDOM_FLIP;
 
//The chance that Yatagan will reverse direction when the enemy fires.
//values are referenced by number of deaths experienced
//when chancesOfReversing is 0, reverse on enemy fire only
//when chancesOfReversing is very large, almost never reverse (unless Math.random() is very small)
//when chancesOfReversing is > 3, reverse with probability 3/chancesOfReversing
   private static final String chancesOfReversing = ""
   + NO_FLIP
   + ONE_WAY_ORBIT + REVERSE_ON_ENEMY_FIRE + ONE_WAY_ORBIT //SHELDOR:  Let's try oscillating movement first.
   + REVERSE_ON_ENEMY_FIRE + ONE_WAY_ORBIT + REVERSE_ON_ENEMY_FIRE
   + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM
   + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM
   + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM
   + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM
   + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM
   + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM
   + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM
   + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM
   + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM
   + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM
   + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM
   + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM + RANDOM
   ;
}