package axeBots;
import robocode.*;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.*;
//import java.awt.geom.Point2D.Double;
import java.io.*;
import java.text.DecimalFormat;
import java.util.*;

import axeBots.data.BotData;
import axeBots.data.BotScore;
import axeBots.data.SegmentedGFs;
import axeBots.data.StaticDataCenter;

import axeBots.okami.*;
import axeBots.gunner.AxeGunner;
import axeBots.pilot.AntiMirrorPilot;
import axeBots.pilot.AxePilot;
import axeBots.pilot.FlatPilot;
import axeBots.pilot.WaveSurferPilot;
//import axeBots.pilot.FlatVelPilot;
import axeBots.pilot.RamPilot;
import axeBots.pilot.VarSpeedPilot;
import axeBots.pilot.waves.EnemyWave;
import axeBots.util.*;
//import java.lang.Math;
//import java.awt.geom.*; 
//import java.text.NumberFormat;
//import java.util.Vector;
//import java.io.PrintStream;   
//import java.io.*;

/**
 * AdvAxe - a sample robot by Marcos Machado
 * 
 * Moves around the outer edge with the gun aiming the other tanks.
 */
public class Okami extends AxeBot {

    private double energyDecay;
    private FlatPilot flatPilot;
    private AxePilot myPilot= null;
//    private RamPilot ramPilot;
    private AntiMirrorPilot amPilot;
//    private VarSpeedPilot varSpeedPilot;
    private boolean threadGun= true;
    private AxeShooter as= new AxeShooter();

    //    private int zigzag= 0;
    private long lasttime= 0;
    //private int cont= -1;

    //private boolean smooth= false;
    private boolean wideScan= false;
    private boolean fullScan= false;
    private boolean rightScan= false;
    private boolean leftScan= false;
    //    private boolean turning= false;
    private double scanStartTime= Double.NaN;
    private double lowest= Double.NaN;
    private double hightest= Double.NaN;
    private boolean choosen= false;
    private double lastEnergy= 0;

    private static BotScore scorer= new BotScore("Okami");

    private long fireTime;

    //private boolean startWide= false;
    private boolean firing= false;
    //	private boolean halfVel = false;

    //    private boolean peek; // Don't turn if there's a robot there
    //private double moveAmount= 0; // How much to move
    private double maxFieldLen= 0; // How much to move
    //private boolean re= false;
    //    private boolean first= true;

    private int reCount= 0;
    //private double gunTurnAmt= 15; // How much to turn our gun when searching
    //CompensaReg busca = null;
    //    private int max= 4;
    //    private int conta;
    //private int x;
    //private int y;
    //    private double firePwr= 0.1;
    private boolean changeMove= false;
    private boolean chngSpeed= true;
    private boolean bateu= false;
    private double botDim;
    private boolean doScan= true;
    private int acertados= 0;
    private AxeAvoider wallAlert= null;
    private AxeAvoider centerAlert= null;
    private AxeAvoider wallBackUp= null;
    private AxeTargetMan tMan= null;
    private AxeTarget myTarget= null;

    private ArrayList posHistory= new ArrayList();
	private ArrayList velHistory= new ArrayList();
    private double gunHeat= 0;

    public Okami() {
        super();
        super.setIt(this);
    }

    private void fireAtWill(double gunAngle) {
        setTurnGunRight(turnGunTo(gunAngle));
        as.start();
    }

    private void setDuel() {
        if (this.getOthers() == 1) {
            //this.centerAlert.setOn(false);
            tMan.setDuel(true);
        }
    }

    public Point2D.Double getPos(int atTime) {
        if (posHistory.size() < atTime) {
            System.out.println(
                ".................... MEU HISTORY FORA DE FASE: atTime:"
                    + atTime
                    + " sz:"
                    + posHistory.size()
                    + " now:"
                    + getTime());
        }
        atTime= (posHistory.size() < atTime) ? posHistory.size() : atTime;
        return ((AxeVector)posHistory.get(atTime - 1)).getEndPoint();
    }
    
	public double getLastDesloc() {
			int atTime=  posHistory.size();
			return ((AxeVector)posHistory.get(atTime - 1)).getEndPoint().distance( ((AxeVector)posHistory.get(atTime - 2)).getEndPoint());
		}

//    public double adjustDirection(int atTime, AxeTarget target, double angle) {
//        Point2D.Double hisPos= target.getPos(atTime);
//
//        Point2D.Double meNow= this.getPos(atTime);
//        Point2D.Double meBefore= this.getPos(atTime - 1);
//
//        AxeVector now= new AxeVector(hisPos, meNow);
//        AxeVector before= new AxeVector(hisPos, meBefore);
//
//        double diff= before.getDiffTheta(now);
//        //        System.out.println("adjustDirection diff:" + diff + " angle:" + angle);
//
//        return ((diff * angle) < 0) ? -Math.abs(angle) : Math.abs(angle);
//    }
/**
 * retorna o sentido da minha velocidade no instante.
 * @param atTime
 * @param target
 * @return
 */
    public int getDirection(int atTime) {
    	atTime = (atTime>(velHistory.size()-1))?velHistory.size()-1:atTime;
    	int vel=0;
    	while( atTime>=0 && (vel=((Integer)velHistory.get(atTime--)).intValue() )==0);
    	return (vel<0)?-1:1;
    	
    	
//        Point2D.Double hisPos= target.getPos(atTime);
//
//        Point2D.Double meNow= this.getPos(atTime);
//        Point2D.Double meBefore= this.getPos(atTime - 1);
//
//        AxeVector now= new AxeVector(hisPos, meNow);
//        AxeVector before= new AxeVector(hisPos, meBefore);
//
//        double diff= before.getDiffTheta(now);
//        //        System.out.println("adjustDirection diff:" + diff + " angle:" + angle);
//
//        return (diff < 0) ? -1 : 1;
    }

    private void addHistoryPos(double x, double y, double time) {

        
        double timesDelta= time - posHistory.size();

        AxeVector last;
        if (this.posHistory.size() == 0) {
            last= new AxeVector(x, y);
        } else {
            last= (AxeVector)posHistory.get(posHistory.size() - 1);
        }

        double x0= last.getX();
        double y0= last.getY();
        double Dx= x - x0;
        double Dy= y - y0;
        double dx= Dx / timesDelta;
        double dy= Dy / timesDelta;

        AxeVector interpol= null;

        for (int i= 0; i < timesDelta; i++) {
            x0 += dx;
            y0 += dy;
            interpol= new AxeVector(x0, y0); //, tetha, mod);
            posHistory.add(interpol);
            velHistory.add(new Integer((int)this.getVelocity() ));
        }

    }

    /**
     * run: Move around the walls
     */

    public void run() {

        System.gc();
        this.setRe(true);
        setEventPriority("HitByBulletEvent", 85);
        //setEventPriority("ScannedRobotEvent", 100);
        //setEventPriority("DeathEvent", 5);
        //setEventPriority("WinEvent", 5);
        //setEventPriority("ScannedRobotEvent", 100);
        //this.cleanDir();
        this.setBotDim(Math.max(this.getHeight(), this.getWidth()));
        this.setTotBots(this.getOthers() + 1);

        tMan=
            new AxeTargetMan(
                this.getBattleFieldHeight(),
                this.getBattleFieldWidth());

        super.setField(
            new Rectangle2D.Double(
                0,
                0,
                this.getBattleFieldWidth(),
                this.getBattleFieldHeight()));
        //out);
        //        Color silver= new Color(217, 255, 255);
        //        this.setColors(Color.white, Color.white, silver);
        this.setColors(Color.white, Color.white, Color.RED);

        double rw= this.getWidth();
        double rh= this.getHeight();

        scorer.newRound();
        EnemyWave.clear();

//        varSpeedPilot= new VarSpeedPilot();
        flatPilot= new WaveSurferPilot(); //FlatPilot();
//        ramPilot= new RamPilot();
        amPilot= new AntiMirrorPilot();

        botDim= Math.max(rw, rh);
        tMan.setMaxOpps(this.getOthers());

        double d= (botDim * 2.5);
        double x1= d;
        double y1= d;
        double x2= this.getBattleFieldWidth() - d;
        double y2= this.getBattleFieldHeight() - d;

        wallAlert= new AxeAvoider(this, x1, y1, x2, y2, false);

        d= d + (botDim * 3);
        x1= d;
        y1= d;
        x2= this.getBattleFieldWidth() - d;
        y2= this.getBattleFieldHeight() - d;

        centerAlert= new AxeAvoider(this, x1, y1, x2, y2, true);

        d= botDim * 1.50;
        x1= d;
        y1= d;
        x2= this.getBattleFieldWidth() - d;
        y2= this.getBattleFieldHeight() - d;

        wallBackUp= new AxeAvoider(this, x1, y1, x2, y2, false);

        maxFieldLen= Math.max(getBattleFieldWidth(), getBattleFieldHeight());
        // Initialize peek to false
        setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);

        doFullScan();

        lastEnergy= this.getEnergy();
        execute();
        int i= 0;

        this.setDuel();

        while (true) {
            if (this.getTime() > (lasttime + 1)) {
                out.println(
                    " ********** PULOU ROUND:"
                        + lasttime
                        + " - "
                        + this.getTime());
            }
            this.lasttime= this.getTime();

            if (((int) (lastEnergy * 1000) - (int) (this.getEnergy())) == 10) {
                energyDecay= 0.1;
            } else if (
                ((int) (lastEnergy * 1000) - (int) (this.getEnergy())) == 0) {
                energyDecay= 0.0;
            }

            addHistoryPos(this.getX(), this.getY(), this.getTime());

            //tMan.printAllTargets();
            i++;
            if (myTarget != null) {
                //out.println(" getMirrorAvg:" + myTarget.getMirrorAvg());
                double mirrorAvg= myTarget.getMirrorAvg();
                if ((!Double.isNaN(mirrorAvg)) && (mirrorAvg < 30)) {
                    myTarget.getStratego().setAntiMirror(true);
                    //					out.println(
                    //										" >>>>>>>>>>>>>>>>>>>>>>>>> ANTI MIRROR <<<<<<<<<<<<<<<<<<<<< avg:"+mirrorAvg+" at:"
                    //											+ this.getTime());
                } else {
                    myTarget.getStratego().setAntiMirror(false);
                }
            }
            //out.println("========== INICIO DO ROUND "+i+"("+this.getRoundNum()+") t:"+this.getTime()+" others:"+this.getOthers());

            move();
            ////out.println("========== MOVE "+i+"("+this.getRoundNum()+") t:"+this.getTime());
            chngSpeed= true;
            doRadar();

            doGun();
            execute();
            ////out.println("========== EXECUTE "+i+"("+this.getRoundNum()+") t:"+this.getTime());
            //tMan.putStats();

        }

    }

    private void doGun() {

        if ((this.getOthers() == 1) //&& (myTarget != null)
            && (myPilot != null) //&& (myTarget.isDisabled())
            && (!this.myPilot.fire())) {

            return;
        }

        if (firing || (this.getEnergy() <= 0) /*|| !tMan.allScanned(fireTime)*/
            ) {
            return;
        }

        AxeTarget oldTarget= myTarget;
        if (myTarget == null
            || !choosen
            || !myTarget
                .isAlive() //|| !myTarget.getStratego().goodFire(myTarget)
        ) {

            myTarget= tMan.getTarget(this.getOthers());
            choosen= true;
        }
        if (MC) {
            return;
        }

        int strat= -1;
        //if(!tMan.isLocked()) return;
        //int dista
        //AxeTarget jaera = getAlvo();
        //        out.println("doGun:myTarget:" + myTarget);
        if (myTarget == null) {
            //            out.println("doGun:myTarget null");
            return;
        }

        setTurnGunRight(
            this.turnGunTo(
                RoboMath.normalRelativeAngle(
                    Math.toDegrees(
                        RoboMath.getang(this.pos(), myTarget.pos())))));

        if ((oldTarget != null) && (myTarget != oldTarget)) {
            myTarget.resetHitsOnARow();
        }

        //        out.println("doGun:" + myTarget.getName());

        if (!((getGunHeat() > this.getGunCoolingRate())
            || (myTarget.getScanTime() != this.getTime()))) {
            strat= myTarget.getStratego().newAimStrat(myTarget, threadGun);
        }

        if (strat < 0) {
            return;
        }
        //strat= tMan.newAimStrat();

        /*if((getGunHeat() > 0) || (jaera.getScanTime() != this.getTime()))
        {
        	return;
        }*/

        double pwr=
            tMan.getFirePwr(
                this,
                getAimingArc(myTarget.getAbsBearing(), 20),
                myTarget);
        //doScan = false;
        //tMan
        //		out.println(this +" aiming:" + pwr + " at " + getTime());
        double gunOffset= 0;
        boolean goodToFire= true;
        int en= 8;

        // trava de 8 de energia
        if ((!TC)
            && ((this.getOthers() == 1)
                && (this.getEnergy() < en)
                && (myTarget.getDistance() > (4 * this.botDim))
                && ((this.getEnergy() - (pwr + 0.2))
                    <= myTarget.getLastEnergy()))) {
            //out.println(" NOT GOOD TO FIRE!");
            goodToFire= false;

        }

        if ((getGunHeat() > this.getGunCoolingRate())
            || (Math.toDegrees(gunOffset) > 20)
            || (myTarget.getScanTime() != this.getTime())
            || (pwr == 0)
            || !goodToFire) {
            //                        out.println(" voltando...");
            doScan= true;
            //execute();
            return;
        }

        //out.println(jaera.getName()+" angulo de ataque:"+aat);
        as.make(
            this,
            pwr,
            (long)myTarget.getTimeToHit(),
            myTarget,
            strat,
            myTarget.getDistance(),
            myTarget.getAngle(),
            myTarget.getX(),
            myTarget.getY(),
            myTarget.getStratego().getGun());

        if (!this.threadGun) {

            as.start();
        } else {
            Point2D.Double p= myTarget.getStratego().aim(pwr);
            if (p == null) {
                //                out.println(this +" aiming null!");
                return;
            }
            //out.println(this +" aiming:" + pwr + " at " + getTime());
            this.fireAtWill(
                RoboMath.normalAbsoluteAngle(
                    Math.toDegrees(RoboMath.getang(this.pos(), p))));
            //            out.println(this +" aimed:" + pwr + " at " + getTime());
        }
        firing= true;
        choosen= false;
        if (getOthers() > 1) {
            doWideScan();
        }
    }

    private void doWideScan() {
        wideScan= true;
        //startWide = true;
    }

    private void doFullScan() {
        fullScan= true;
        //startWide = true;
    }

    private void doRadar() {
        if (tMan.notSeenSince(this.getTime()))
            doFullScan();

        double radarOffset= 360; //RoboMath.PI*2;

        /*if (!fullScan)
            doWideScan();*/

        if (wideScan) {
            if (Double.isNaN(scanStartTime)) {

                scanStartTime= this.getTime();
                lowest=
                    tMan.getLowestEnemyBearing(
                        this.getX(),
                        this.getY(),
                        this.getRadarHeading())
                        + RoboMath.normalRelativeAngle(getRadarHeading());
                hightest=
                    tMan.getHightestEnemyBearing(
                        this.getX(),
                        this.getY(),
                        this.getRadarHeading())
                        + RoboMath.normalRelativeAngle(getRadarHeading());
                //out.println("wideScan started:"+this.getTime()+ " lowest:"+lowest+" hightest"+hightest);

            }

            if (tMan.allScanned(scanStartTime)) {
                wideScan= leftScan= rightScan= false;
                scanStartTime= Double.NaN;
                //out.println("wideScan pre completed:"+this.getTime());

            } else if (!leftScan) {
                leftScan= true;
                //double vou = tMan.getLowestEnemyBearing(this.getX(),this.getY(),this.getRadarHeading());
                radarOffset=
                    RoboMath.normalRelativeAngle(
                        RoboMath.normalRelativeAngle(lowest)
                            - RoboMath.normalRelativeAngle(getRadarHeading()));
                //radarOffset = getRadarHeadingRadians() - Math.toRadians( );
                if (radarOffset < 0)
                    radarOffset -= 15; //RoboMath.PI/10;
                else
                    radarOffset += 15; //RoboMath.PI/10; 
                radarOffset= RoboMath.normalRelativeAngle(radarOffset);
                //out.println("wideScan leftScan:"+radarOffset+" started:"+this.getTime()+" radar:"+RoboMath.normalRelativeAngle(getRadarHeading()));
            } else if (this.getRadarTurnRemaining() == 0) {
                if (!rightScan) {
                    rightScan= true;
                    /*radarOffset = getRadarHeadingRadians() - Math.toRadians( tMan.getHightestEnemyBearing(this.getX(),this.getY()));
                    radarOffset += RoboMath.PI/10;
                    radarOffset = RoboMath.NormaliseBearing(radarOffset);*/
                    //double vou = tMan.getHightestEnemyBearing(this.getX(),this.getY(),this.getRadarHeading());
                    radarOffset=
                        RoboMath.normalRelativeAngle(
                            RoboMath.normalRelativeAngle(
                                RoboMath.normalRelativeAngle(hightest)
                                    - RoboMath.normalRelativeAngle(
                                        getRadarHeading())));
                    //radarOffset = getRadarHeadingRadians() - Math.toRadians( );
                    if (radarOffset < 0)
                        radarOffset -= 15; //RoboMath.PI/10;
                    else
                        radarOffset += 15; //RoboMath.PI/10; 
                    radarOffset= RoboMath.normalRelativeAngle(radarOffset);
                    //out.println("wideScan rightScan:"+radarOffset+" started:"+this.getTime()+" radar:"+RoboMath.normalRelativeAngle(getRadarHeading()));
                } else {
                    wideScan= leftScan= rightScan= false;
                    if (!tMan.allScanned(scanStartTime)) {
                        doFullScan();
                        //out.println("wideScan falhou:"+this.getTime());
                    } else {
                        scanStartTime= Double.NaN;
                        //out.println("wideScan completed:"+this.getTime());
                    }
                }

            } else
                return;
            /*	if(startWide)
            	{
            		radarOffset = RoboMath.PI*2;
            		startWide = false;
            	}
            	else
            	{
            		if(this.getRadarTurnRemaining()==0)
            			wideScan = false;
            		else
            			return;
            			
            	}*/
        }

        if (fullScan) {
            if (Double.isNaN(scanStartTime)) {
                scanStartTime= this.getTime();
                //				out.println("fullScan started:"+this.getTime());
            }

            if (!tMan.allScanned(scanStartTime)) {
                radarOffset= 360; //RoboMath.PI*2;
            } else {
                fullScan= false;
                scanStartTime= Double.NaN;
                //				out.println("fullScan completed:"+this.getTime());
            }
        }

        if (!wideScan && !fullScan) {

            //AxeTarget jaera= tMan.getTarget(this.getOthers());

            //            if (conta++ > max) {
            //                ////out.println("RESETANDO, NAO VE HA "+max+" TURNOS.");
            //                reSet();
            //            }

            if (myTarget == null) { //if we haven't seen anybody for a bit....
                radarOffset= 360;
                //RoboMath.PI*2;				//rotate the radar to find a target
            } else {

                //				out.println("normalScan started:"+this.getTime()+ " alvo:"+jaera.getName());
                //next is the amount we need to rotate the radar by to scan where the target is now
                //radarOffset = getRadarHeadingRadians() - (Math.PI/2 - Math.atan2(jaera.getY() - getY(),jaera.getX() - getX()));
                double vou=
                    Math.toDegrees(
                        Math.PI / 2
                            - Math.atan2(
                                myTarget.getY() - getY(),
                                myTarget.getX() - getX()));
                radarOffset=
                    RoboMath.normalRelativeAngle(
                        RoboMath.normalRelativeAngle(vou)
                            - RoboMath.normalRelativeAngle(getRadarHeading()));
                //				out.println("normalScan estou:"+RoboMath.normalRelativeAngle(getRadarHeading())+ " vou:"+RoboMath.normalRelativeAngle(vou)+" diff:"+radarOffset);
                //this adds or subtracts small amounts from the bearing for the radar to produce the wobbling
                //and make sure we don't lose the target
                //radarOffset = RoboMath.NormaliseBearing(radarOffset);
                if (radarOffset < 0)
                    radarOffset -= 5; //RoboMath.PI/10;
                else
                    radarOffset += 5; //RoboMath.PI/10; 
            }
            //turn the radar
        }
        //setTurnRadarLeftRadians(radarOffset);
        setTurnRadarRight(radarOffset);
    }

    private void move() {
        //  ram suspended
        //        if ((this.getOthers() == 1)
        //            && (myTarget != null)
        //            && (myTarget.isDisabled())) {
        //
        //            if (this.myPilot != ramPilot) {
        //                ramPilot.start();
        //            }
        //            this.myPilot= ramPilot;
        //
        //        } else {

        //		System.out.println(" re:"+this.isRe() );

        if (TC) {
            return;
        }

        if (myTarget != null) {
            BotData enemyData= StaticDataCenter.get(myTarget.getName());
            enemyData.getGfHistory().draw(myTarget.getDistance());

        }

        if ((myTarget != null) && (myTarget.getStratego().isAntiMirror())) {
            this.myPilot= amPilot;
        } else {
            this.myPilot= flatPilot;
        }

        //        }
        myPilot.move();

    }

    public void onCustomEvent(CustomEvent e) {
        //out.println("onCustomEvent"+this.getTime()+" priority"+e.getPriority()); 
        Condition condition= e.getCondition();
        if (condition instanceof AxeShooter) {
            AxeShooter as= (AxeShooter)condition;
            //out.println(this.getEnergy()); 
            Bullet bullet= setFireBullet(as.getBulletPwr());
            if (bullet != null) {

                this.fireTime= this.getTime();
                //execute();
                AxeVector meToTarget=
                    new AxeVector(
                        new Point2D.Double(this.getX(), this.getY()),
                        new Point2D.Double(
                            as.getTarget().getX(),
                            as.getTarget().getY()));
                BulletTracker bt=
                    new BulletTracker(
                        this,
                        bullet,
                        as.getTarget().getName(),
                        as.getTimeToHit(),
                        as.getAimStrat(),
                        as.getTargetDist(),
                        as.getFacingAngle(),
                        as.getPoint(),
                        meToTarget,
                        as.getGun());

                //as.getTarget().getStratego().startVBs();
                as.getTarget().getStratego().setFiredAtTarget(
                    (as.getTarget().getStratego().getFiredAtTarget()) + 1);
                //aimMethod);
                tMan.fired(bt);
                //                out.println(
                //                    " **** FIRE!:"
                //                        + this.pos().distance(as.getTarget().pos())
                //                        + " pw:"
                //                        + bullet.getPower()
                //                        + " GunHeat:"
                //                        + this.getGunHeat()
                //                        + " dist:"
                //                        + as.getTargetDist()
                //                        + " at:"
                //                        + this.getTime());
            }
            firing= false;
        } else if (condition instanceof BulletTracker) {

            BulletTracker bt= (BulletTracker)condition;
            AxeTarget jaera= null;
            jaera= tMan.getTarget(this.getOthers());
            if (jaera != null) {
                //out.println("**** evento projetil:"+bt.getTargetName());//);+" ALVO=>"+jaera.getName()); 
                if (bt.getTargetName().compareTo(jaera.getName()) == 0) {
                    if (!bt.hitTarget()) {
                        if (acertados > 0)
                            acertados--;
                    } else {
                        acertados++;
                    }
                }
            }

            bt.getGun().updateBT(bt);

            if (!bt.hitTarget()) {

                //                out.println(
                //                    bt.getStartTime() + " ERROU!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                tMan.missed(bt);
            } else {
                //                out.println(
                //                    bt.getStartTime() + " ACERTOU!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                tMan.hit(bt);
            }
        }

    }

    public void onHitByBullet(HitByBulletEvent e) {
		//owner.setEnergy(owner.getEnergy() + power * 3D);
    	
        changeMove= true;
//        double damage= 4 * e.getPower();
//        if (e.getPower() > 1)
//            damage += 2 * (e.getPower() - 1);
        tMan.hitMe(e.getName(), e.getPower());

        BotData bd= StaticDataCenter.get(e.getName());

        bd.getScorer().bullsEye(this, e, Double.NaN);

        if ((this.myPilot != null) && (this.myPilot instanceof FlatPilot)) {

            ((FlatPilot)myPilot).hitByBullet(e.getPower());
        }

        EnemyWave ew=
            EnemyWave.getWave(
                e.getPower(),
                new Point2D.Double(e.getBullet().getX(), e.getBullet().getY()));
        if (ew != null) {
            int gf= ew.getGF(e);
            DecimalFormat fmt = new DecimalFormat("0.00");
            double ptsPerVel = (SegmentedGFs.GF_QT-1) / (8D * 2D);
            
            System.out.println(
                "@@@@@ atingido em GF:"
                    + ((gf - ((SegmentedGFs.GF_QT-1) / 2D))
                    / ptsPerVel)+"("+gf+")");
            bd.getGfHistory().hit(gf, e.getPower(), ew.getDistance());
            ew.hit();
        }else{
        	System.out.println(
                    "********                                                       Onda nula!");
        }

    }

    public void onBulletHit(BulletHitEvent e) {
        //double energy= tMan.getBot( e.getName()).getLastEnergy();
		tMan.getBot( e.getName() ).setExpectedLifeDiff(-RoboMath.getBulletDamage (e.getBullet().getPower())  );  
        scorer.bullsEye(e, Double.NaN);
    }
    /**
     * onHitRobot:  Move away a bit.
     */
    public void onHitRobot(HitRobotEvent e) {
        if (this.myPilot != null) {

            myPilot.botHitBot();
        }
        //doScan = false;
        if (!e.isMyFault()) {
            //out.println(" bateu nao minha culpa:"+e.getName()+" re"+re); 
//			tMan.getBot( e.getName() ).setExpectedLifeDiff(-RoboMath.getBulletDamage (e.getBullet().getPower())  );
            return;
        } //out.println("bateu!!!"+this.getTime());
        //        reSet();
        //setProximo(e.getName());
        bateu= true;
    }

    public void doRe() {
        doRe(!isRe());
    }

    public void doRe(boolean dir) {
        setRe(dir);
        reCount= 0;
        wallBackUp.setOn(true);
    } /**
                                                                                                                                                                                                                                                                                                                                                                                                                     * onScannedRobot:  Fire!
                                                                                                                                                                                                                                                                                                                                                                                                                     */
    public void onScannedRobot(ScannedRobotEvent e) {
        //out.println("onScannedRobot"+this.getTime()+" priority"+e.getPriority()  ); 
        if ((e.getTime() != this.getTime()) || (this.getEnergy() <= 0)) {
            //            out.println(
            //                "=====>                              ignorando onScannedRobot"
            //                    + this.getTime());
            return;
        }

        //if(!doScan) return;
        tMan.setScanned(e, this);
    }

    private double turnGunTo(double to) {
        double ret;
        to= RoboMath.normalAbsoluteAngle(to);
        //if(!re)
        ret=
            RoboMath.normalRelativeAngle(
                to - RoboMath.normalAbsoluteAngle(this.getGunHeading()));
        //else
        //	ret= (normalRelativeAngle(to - normalAbsoluteAngle(normalAbsoluteAngle(getHeading())-180)));
        //out.println("turnBotTo:"+to+" => "+ret);
        return ret;
    }

    public void onRobotDeath(RobotDeathEvent e) {
        out.println(
            ">>>>>>>>>>>>> KILL <<<<<<<<<<<<< :"
                + e.getName()
                + "  => "
                + this.getOthers());
        this.setDuel();
        double rz= (double)tMan.getOpps() / (double)tMan.getMaxOpps();
        rz /= 2.0;
        rz += 0.5;
        centerAlert.reDim(rz);
        tMan.anotherOneBitesTheDust(e, this.getOthers());
        this.setAntiGrav(true);
    }

    public void onHitWall(HitWallEvent e) {

        if (this.myPilot != null) {

            // myPilot.botHitWall();
        }

        out.println(
            "---------------- BATEU NO MURO:"
                + this.getX()
                + ","
                + this.getY()
                + " at:"
                + this.getTime());
    }

    public void onWin(WinEvent e) {
        out.println("  VENCI!!!!!" + this.getTime());

        if (myTarget != null) {
            myTarget.loose();
        }

        scorer.win();

        this.terminate();
        setTurnGunRight(-this.getGunHeading());
        //        //setTurnRadarLeft(36000);
        //        setMaxVelocity(8);
        //        setAhead(0);
        //        //turnRight(30);
        //        //ahead(300);
        //        setTurnRadarLeft(36000);
        //        setTurnGunRight(36000);
        //        setTurnLeft(36000);
        //        while (true) {
        //            execute();
        //            //fire(3);
        //        } //turnLeft(360);
        //        //execute();
        //        //turnRight(360);
    }

    private void terminate() {

        if (SAVE_DATA && (getRoundNum() == getNumRounds() - 1)) {
            AxeFiles.cleanDir();
        }
        tMan.terminate();
        out.println(scorer);
    }

    public void onDeath(DeathEvent event) {
        out.println("  MORRI!!!!!" + this.getTime());
        if (myTarget != null) {
            myTarget.win();
        }
        scorer.died();
        terminate();
    }

    public boolean goingNorte() {

        double going= this.getMoveHeading();
        if ((going > 270) || (going < 90)) {
            return true;
        } else {
            return false;
        }

    }

    public boolean goingLeste() {

        double going= this.getMoveHeading();
        if (going < 180) {
            return true;
        } else {
            return false;
        }

    }

    public boolean goingOeste() {

        double going= this.getMoveHeading();
        if (going > 180) {
            return true;
        } else {
            return false;
        }

    }

    public boolean goingSul() {

        double going= this.getMoveHeading();
        if ((going > 90) && (going < 270)) {
            return true;
        } else {
            return false;
        }

    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        // TODO Auto-generated method stub
        super.onBulletHitBullet(e);
        out.println(
            "===============================> onBulletHitBullet"
                + this.getTime());

        EnemyWave ew=
            EnemyWave.getWave(
                e.getHitBullet().getPower(),
                new Point2D.Double(
                    e.getHitBullet().getX(),
                    e.getHitBullet().getY()));
        if (ew != null) {
            ew.hitBull();
        }
    }

    /**
     * @return
     */
    public AxeTarget getMyTarget() {
        return myTarget;
    }

    /**
     * @return
     */
    public AxeAvoider getWallAlert() {
        return wallAlert;
    }

    /**
     * @return
     */
    public static BotScore getScorer() {
        return scorer;
    }

    /**
     * @return
     */
    public AxePilot getMyPilot() {
        return myPilot;
    }

    /**
     * @return
     */
    public double getEnergyDecay() {
        return energyDecay;
    }

}
