/*
 * Created on 2004-11-28
 */
package cx.micro;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

/**
 *                  Blur  --  Micro Wave Surfer
 *-----------------------------------------------------------------
 * @author:iiley (iiley@hotmail.com)
 * http://www.robochina.org
 * 0.1: first release. (codesize734)
 * 0.2: make surfer accurater than 0.1, gun changed to average velocity linear gun.(codesize 749)
 *------------------------------------------------------------------
 * Thanks to the following:
 * PEZ
 * Jamougha
 * and a general thanks to all NanoBot and MicroBot developers for being so creative
 */
public class Blur extends AdvancedRobot {
	private static final int   FACTORS = 24;
	private static final int   MID_FACTORS = 12;
	private static int[][]     hits  = new int[9][FACTORS+1];

	private static Point2D.Double myPos;
	private static double enemyEnergy;
	private static ArrayList waves;

	private static int hitted = 100;
	private static Wave closestWave;
	private static double averageLV;
	
	public void run( ) {
		waves = new ArrayList();
		//setColors(Color.lightGray,null,Color.white);
		do{
			turnRadarRightRadians(Double.POSITIVE_INFINITY);	
		}
		while(true);
	} 
    // -------------------- function for event handle ---------------
   	public void onScannedRobot(ScannedRobotEvent e) {
		double v1, v2, v3, energyChange;
		setTurnRadarLeftRadians(getRadarTurnRemaining());
		
		setTurnRightRadians((v1=e.getBearingRadians())-Math.PI/2d + (v3=getVelocity())/30d);

		setTurnGunRightRadians(Utils.normalRelativeAngle((v1 = getHeadingRadians() + v1)
						+ (averageLV = averageLV*0.95d + e.getVelocity()*0.004d)
						* Math.sin(e.getHeadingRadians() - v1)
						- getGunHeadingRadians()));

		Point2D.Double enemyPos;

		Wave wave = new Wave();

		if(Math.abs((energyChange = enemyEnergy - e.getEnergy())-1.55)<1.46){
			addCustomEvent(wave);
			waves.add(wave);
			wave.bv = 20 - 3d*energyChange;
		}
		double myAbsBearing;
		wave.bearing = myAbsBearing = v1 + Math.PI;
		wave.startP = enemyPos = nextPoint((myPos = new Point2D.Double(getX(), getY())), v1, v2=e.getDistance());
		wave.dir = v3 > 0 ? 0.8/MID_FACTORS : -0.8/MID_FACTORS;
		wave.sHits = hits[(int)Math.abs(v3)];

		//double moveDist, pDanger, nDanger;//, sDanger;
		//moveDist = pDanger = nDanger = 0d;
		//energyChange,v1,v3 as moveDist, pDanger, nDanger
		
		int wsize;
		if((wsize=waves.size()) > 0){
			closestWave = (Wave)waves.get(0);
			v1 = v3 = 0d;
			Point2D.Double pPos, nPos;
			Rectangle2D.Double BF;
			if(!(BF = new Rectangle2D.Double(25d, 25d, 750d, 550d)).contains(pPos = nextPoint(enemyPos, myAbsBearing + (energyChange =  (closestWave.remainDist()/closestWave.bv) * 7.8 / v2), v2))){
				v1 = Integer.MAX_VALUE/2;
			}
			if(!BF.contains(nPos = nextPoint(enemyPos, myAbsBearing - energyChange, v2))){
				v3 = Integer.MAX_VALUE/2;
			}
			//energyChange = 0;
			do{
				Wave w = (Wave)waves.get(--wsize);
				v1 += w.getDanger(pPos)/w.remainDist();
				v3 += w.getDanger(nPos)/w.remainDist();
				//energyChange += w.getDanger(myPos)/w.remainDist();
			}while(wsize > 0);
		}

		/*if(energyChange < v1 && energyChange < v3){
			v2 = 0d;
		}else */
		if(v1 >= v3){
			v2 = -v2;
		}

		setAhead(v2);
		setFire(enemyEnergy);
		
		enemyEnergy = e.getEnergy();
	}
   	       
    public void onHitByBullet(HitByBulletEvent e){
		enemyEnergy+=e.getPower()*3d;
		closestWave.rateHit();
	}
    
	public static Point2D.Double nextPoint(Point2D.Double originPoint, double angle, double distance){
		return new Point2D.Double(originPoint.x+Math.sin(angle)*distance,originPoint.y+Math.cos(angle)*distance);
	}	
    
	static class Wave extends Condition{
		Point2D.Double startP;
		double bearing, bv, dir, dist = 25d;
		int[]  sHits;
		public boolean test(){
			dist += bv;
			if(remainDist() < 0d){
				waves.remove(this);
				//removeCustomEvent(this);
			}
			return false;
		}
		public double remainDist(){
			return startP.distance(myPos) - dist;
		}
		public void rateHit(){
			sHits[getIndex(myPos)] += hitted++;
		}
		
		private int getIndex(Point2D.Double pos){
			return Math.max(Math.min((int)Math.round(Utils.normalRelativeAngle(Math.atan2(pos.x - startP.x, pos.y - startP.y) - bearing)/dir + MID_FACTORS), FACTORS), 0);
		}
		
		public int getDanger(Point2D.Double pos){
			int danger = 0;
			int i=0;
			int index = getIndex(pos);
			do{
				danger += sHits[i]/(Math.abs(i - index) + 1);
			}while(i++ < FACTORS);
			return danger;
		}
		
	}
}
