/*
 * Created on Oct 20, 2004
 *
 */
package davidalves.net.movement;

import davidalves.PhoenixOS;
import davidalves.net.strategy.Strategy;
import davidalves.net.util.*;

/**
 * @author David Alves
 * From YALT 1.732
 *
 */
public class NoFearTheWallsWallSmoother extends WallSmoother{
	final double STICK_LENGTH = 170;
	
	public Point getSmoothedDestination(Point position, Point orbitCenter, double direction) {
		if(direction == 0.0) return position;
		
		double desiredDistance = Strategy.getDesiredDistance();
		
		double desiredAngle = Utils.normalAbsoluteAngle(position.absoluteAngleTo(orbitCenter) - direction * Math.PI / 2.0);
		if(position.distanceTo(orbitCenter) < desiredDistance){
			//Drive away from enemy at a sharp angle if we are close to them, shallow if far
			if(PhoenixOS.bot.getGunHeat() > 1.6){ 
				//In the beginning of the round (before anyone can fire)
				//drive almost directly away from the enemy
				desiredAngle -= direction * Utils.scaledValue(.3,.7,position.distanceTo(orbitCenter)/desiredDistance);
			} else {
				//Once bots can fire, stay closer to perpendicular
				desiredAngle -= direction * Utils.scaledValue(.1,.4,position.distanceTo(orbitCenter)/desiredDistance);
			}
		} else {
			//Drive towards enemy
			desiredAngle += direction * Utils.scaledValue(.1, .4, position.distanceTo(orbitCenter)/desiredDistance);
		}
		double angle = desiredAngle;
		int adjustments = 0;
		while((position.project(angle, STICK_LENGTH).distanceToWall() < 1.0))
		{
			adjustments++;
			angle += direction * 0.05;
		}
		return position.project(angle, STICK_LENGTH);
	}
}
