package ruc.nano;
import robocode.*; 
import java.awt.Color;

/**
 * Zealot : This is my first nano bot! Hope it can be powerful.
 * Ver 0.1: Using random offset shoot, I think this better than 
 *          simple linear prediction shooting ^^
 *          Using special move strategy to fool enemy's linear prediction :)
 * Future : Using linear prediction shooting & random shooting.
 *          Btw, I will develop a new microbot NewbieKiller, maybe
 *          no time to improve this bot.
 * btw: ruc means Robocode Union of China @_@
 */
 
public class Zealot extends AdvancedRobot
{
	static final double PI = Math.PI;	// Use codesize 0 !
	static double  eEnergy;				// Enemy's previous energy
	static double  moveDir = 1;			// Move Direction
	static double  nextFireTime;		// Enemy's next fire time
	
	public void run()
	{
		setColors(Color.lightGray,Color.black,Color.white);	// Use codesize 13...:(
		setAdjustGunForRobotTurn(true);
		do{
			turnRadarRightRadians(Double.POSITIVE_INFINITY);
		}while(true);	// Base on my test, use do{}while(true) less 3 codesize than while(true){} ^^
	}
	
	public void onScannedRobot(ScannedRobotEvent e)
	{
		double eDir = e.getDistance();	// eDir now means enemy's distance, learn from iiley's smog
		// Begin move
		double changedEnergy;		// Enemy's energy changed number
		if((changedEnergy = eEnergy - e.getEnergy())>0 && changedEnergy <=3)	// Dodge Bullet, can save 1 codesize to: if(Math.abs((changedEnergy = eEnergy - e.getEnergy()) - 1.51) <= 1.49)
		{
			nextFireTime = 10 + changedEnergy * 2D;	// The Next Time Enemy Fire
			moveDir = -moveDir;	// When enemy fire, change direction at once
			//setAhead((e.getDistance()/3 - 20 + Math.random()*40) * moveDir);
			//setAhead((e.getDistance()/4 + 20) * moveDir);
		}
		changedEnergy = 30;	// changedEnergy now means the distance per frame run
		if(eDir<200 && nextFireTime-- < 6)	// Before 5 frames enemy fire,
		{
			changedEnergy = 1;	// fool enemy's simple linear prediction
		}

		setAhead(changedEnergy * moveDir);	// Ahead!
		//setTurnRightRadians(e.getBearingRadians() + PI/2 - PI/3*moveDir*e.getVelocity()/8);
		setTurnRightRadians(e.getBearingRadians() + PI/2);	// Around enemy
		//setTurnRight(e.getBearing() + 90 - getVelocity());	// the same to NanoDuelist...I think useful
		// End move
		
		eDir = getHeadingRadians() + e.getBearingRadians();	// eDir now means Enemy's absolute bearing radian
		//I learn it from NanoDuelist, thanks David Alves, that can save little codesize:
		setTurnRadarRightRadians(Math.sin(eDir - getRadarHeadingRadians()));	// Fix radar's direction to enemy, codesize 13

		// Begin Shooting (Using random offset, also learning from NanoDuelist, I will improved it soon, make it more powerful!)
		//setTurnGunRightRadians(Math.asin(Math.sin(eDir - getGunHeadingRadians() - 0.25 + Math.random()*0.5)));
		setTurnGunRightRadians(Math.asin(Math.sin(eDir - getGunHeadingRadians() + Math.asin(e.getVelocity()*Math.sin(e.getHeadingRadians() - eDir)/11) * (0.7 + Math.random()*0.3 - e.getDistance()/1000))));
		setFire((eEnergy = e.getEnergy())/4 + 0.1);	// Use codesize 6
		//setFire(Math.min(e.getEnergy()/5,getEnergy()<10?0:3));	// Use codesize 31, ft...
		// End Shooting
		scan();	// Use codesize 4
	}

}