
package cx.util.iiley;
import robocode.*;

/**
 * @author iiley
 * class BotInfo, record robot infos
 */
public class BotInfo
{
	public int num;
	public BotInfo next;
	public BotInfo prior;
	public double x=0;
	public double y=0;
	public double headingRadians=0;
	public double distance=40;
	public double bearingRadians=0; 
	public double velocity=0;
	public double velocityChange=0;
	public double dirRadians=0;
	public double energy=100;
	public double energyChange=0;
	public long   time=0;
	public double moveStance=0;
	public double leftTurn=0;
	public double rightTurn=0;
	public double timelasts=0;
    public double firedPower=0;
    /**
	 * construct a BotInfo with non prior non next 0 num
	 */
	public BotInfo(){
		this.prior=null;
		this.next=null;
		this.num=0;
	}
    /**
	 * construct a BotInfo with a num
	 */
	public BotInfo(int num){
		this.prior=null;
		this.next=null;
		this.num=num;
	}
    /**
	 * construct a BotInfo with prior next but non num
	 */
	public BotInfo(BotInfo prior,BotInfo next){
		this.prior=prior;
		this.next=next;
		this.num=0;
	}
    /**
	 * construct a BotInfo with prior next and num
	 */
	public BotInfo(BotInfo prior,BotInfo next,int num){
		this.prior=prior;
		this.next=next;
		this.num=num;
	}
	/**
	 * update the bot's info
	 */
	public void update(ScannedRobotEvent e,AdvancedRobot robot){
    	 update(e,robot.getHeadingRadians(),robot.getX(),robot.getY());
	}
    /**
	 * update the bot's info
	 */
	public void update(ScannedRobotEvent e,double robotHeadingRadians,double robotX,double robotY){
		if(e.getTime()==time) return;//just updated in the same time
        double lastTime=time;
		double lastX=x;
		double lastY=y;
		double lastHeadingRadians=headingRadians;
		headingRadians=e.getHeadingRadians();
		distance=e.getDistance();
		bearingRadians=e.getBearingRadians();
		velocityChange=e.getVelocity()-velocity;
		velocity=e.getVelocity(); 
		energyChange=e.getEnergy()-energy;
		energy=e.getEnergy();
		time=e.getTime();
 		dirRadians=Util.standardBotAngle(bearingRadians+robotHeadingRadians);
		x=robotX+distance*Math.sin(Util.standardAngle(dirRadians));
		y=robotY+distance*Math.cos(Util.standardAngle(dirRadians));

    	timelasts=time-lastTime;
	    double tempTurn=Util.clockwiseAngle(headingRadians,lastHeadingRadians);
    	rightTurn=tempTurn;
	    leftTurn=0-tempTurn;
    	moveStance=Util.distance(x,y,lastX,lastY);
	}
	public BotInfo clone(BotInfo newBI){
    	newBI.num=num;
    	newBI.next=next;
    	newBI.prior=prior;
    	newBI.x=x;
    	newBI.y=y;
    	newBI.headingRadians=headingRadians;
    	newBI.distance=distance;
    	newBI.bearingRadians=bearingRadians; 
    	newBI.velocity=velocity;
    	newBI.velocityChange=velocityChange;
    	newBI.dirRadians=dirRadians;
    	newBI.energy=energy;
    	newBI.energyChange=energyChange;
    	newBI.time=time;
    	newBI.moveStance=moveStance;
    	newBI.leftTurn=leftTurn;
    	newBI.rightTurn=rightTurn;
    	newBI.timelasts=timelasts;
		return newBI;
	}
	public Object clone(){
		BotInfo newBI=new BotInfo();
    	newBI.num=num;
    	newBI.next=next;
    	newBI.prior=prior;
    	newBI.x=x;
    	newBI.y=y;
    	newBI.headingRadians=headingRadians;
    	newBI.distance=distance;
    	newBI.bearingRadians=bearingRadians; 
    	newBI.velocity=velocity;
    	newBI.velocityChange=velocityChange;
    	newBI.dirRadians=dirRadians;
    	newBI.energy=energy;
    	newBI.energyChange=energyChange;
    	newBI.time=time;
    	newBI.moveStance=moveStance;
    	newBI.leftTurn=leftTurn;
    	newBI.rightTurn=rightTurn;
    	newBI.timelasts=timelasts;
		return newBI;
	}
};