package slugzilla;
import robocode.*;
import robocode.util.Utils;
import java.awt.geom.Rectangle2D;

public class OrbitPattern extends AdvancedRobot {
	//will be flipped 1 to -1 to go backwards
	static double direction = 1;
	static double bulletVelocity;
	static double enemyEnergy = 100.0;	
	
	static String enemyLog = "000000000000000000000000000000888888888888888765432100888765432101234567888765432100"; //The list where enemy lateral velocities are stored
	public void run() {
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		do {
       	 // ...
	        // Turn the radar if we have no more turn, starts it if it stops and at the start of round
	        if ( getRadarTurnRemaining() == 0.0 )
	            setTurnRadarRightRadians( Double.POSITIVE_INFINITY );
	 
	        execute();
	    } while ( true );
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
		double angle;
		double offset = 2;
		//The rectangle represents the area inside an 800 by 600 rectangle that we can move freely.  Since a robot is 36px by 36px, the 18 difference on each side will ensure we do not hit the walls.
		while(!new Rectangle2D.Double(18,18,764,564).
					//Every time we are moving toward a wall, adjust our offset so that we glide along the wall and avoid hitting it.
					contains(getX() + 160 * Math.sin(angle = absoluteBearing + direction * (offset -= .02)), getY() + 160 * Math.cos(angle)));
		
		int matchLength = 30; //the number of data a pattern contains, then the counter in the absB updater loop  		 
    	double absB; //absolute bearing 
    	int i; 		 		    		
   		int index; //index of the match of the pm gun
		
 		setTurnRightRadians((Math.cos(absB = e.getBearingRadians())));
        //Inserting the newest lateral velocity into the beginning of our log
        enemyLog = String.valueOf( (char)Math.round(e.getVelocity() * Math.sin(e.getHeadingRadians() - ( absB+=getHeadingRadians() )))).concat(enemyLog);
        //Reducing pattern depth until find a match. Store the index of the match.
        while((index = enemyLog.indexOf(enemyLog.substring(0, matchLength--), (i = (int)((e.getDistance())/14)))) < 0);
        //Add the angular velocities of the first BFTIME lateral velocities to absolute bearing.  
        do{
            absB += Math.asin(((byte)enemyLog.charAt(index--))/e.getDistance());
        }while(--i > 0);
        //Turning gun to head the predicted absolute bearing
        setTurnGunRightRadians(Utils.normalRelativeAngle(absB-getGunHeadingRadians()));
       	//Fire at will!
        setFire(2);
		
		//We will only reverse direction if we are too close to the wall.
		if(offset < Math.PI/4) {
			direction = -direction;
		}
		setAhead(1000 * Math.cos(angle -= getHeadingRadians()));
		setTurnRightRadians(Math.tan(angle));
	
    	// Subtract current radar heading to get the turn required to face the enemy, be sure it is normalized
    	double radarTurn = Utils.normalRelativeAngle( absoluteBearing - getRadarHeadingRadians() );
 
    	// Distance we want to scan from middle of enemy to either side
    	// The 36.0 is how many units from the center of the enemy robot it scans.
    	double extraTurn = Math.min( Math.atan( 36.0 / e.getDistance() ), Rules.RADAR_TURN_RATE_RADIANS );
 
    	// Adjust the radar turn so it goes that much further in the direction it is going to turn
    	// Basically if we were going to turn it left, turn it even more left, if right, turn more right.
    	// This allows us to overshoot our enemy so that we get a good sweep that will not slip.
 	   if (radarTurn < 0)
	        radarTurn -= extraTurn;
	    else
	        radarTurn += extraTurn;
 	
	    //Turn the radar
	    setTurnRadarRightRadians(radarTurn);
	}
	public void onHitByBullet(HitByBulletEvent e) {	
		//The enemy will gain health if they hit us, this accounts for that change.
		enemyEnergy += Rules.getBulletHitBonus(e.getPower());
    }
	public void onBulletHit(BulletHitEvent e) {
		//The enemy will lose health if we hit them, this accounts for that change.
		enemyEnergy -= Rules.getBulletDamage(e.getBullet().getPower());
	}
}
