package ag.movement;

import ag.Gir;
import ag.battledata.DataRobot;
import ag.battledata.DataVector;

public class MoveTeam {

	private Gir mGir;	
	
	private DataRobot mLeader, mTeamTarget;
	private GravPoint[] mGravForces;
	public GravLine mGravLine;
		
	/**
	 * Constructor
	 * @param gir The controlling Gir-Object
	 */
	public MoveTeam(Gir gir) {
		mGir = gir;
		mLeader = null;
		mTeamTarget = null;
		mGravForces = new GravPoint[]{new GravPoint(new DataVector(), 
				-400, 1, 10000), new GravPoint(new DataVector(), 
				-400, 1, 10000)};
		mGravLine = new GravLine(new DataVector(), -150, 0, 
				10000, new DataVector());
		
	}
	
	/**
	 * Returns a data vector that indicates where we should move if
	 * we want to set up a team crossfire (in a team of two). mLeader must
	 * not be null.
	 */
	public DataVector[] getTeamGravForces(){
				
		DataVector[] gravForces = new DataVector[3];
			
		DataVector targetpos = mTeamTarget.getPosition(0);
		DataVector girpos = mGir.getData().getPosition(0);
		
		DataVector diffLeader = mLeader.getPosition(0).minus(targetpos);
		diffLeader.normalize();
		
		mGravLine.setPosition(targetpos);
		mGravLine.setDirection(diffLeader);
		
		gravForces[0] = mGravLine.getForceOn(girpos);
		
		diffLeader = diffLeader.rotate(Math.PI * 0.5);				
		mGravForces[0].setPosition(targetpos.plus(diffLeader.multiple(300)));
		diffLeader = diffLeader.rotate(Math.PI);
		mGravForces[1].setPosition(targetpos.plus(diffLeader.multiple(300)));
		
		for(int i = 0; i < 2; i++){
			if(isInBattleField(mGravForces[i])){
				gravForces[i+1] = mGravForces[i].getForceOn(mGir.getData().getPosition(0));
			}else{
				gravForces[i+1] = new DataVector();
			}				
		}
				
	
		return gravForces;	
	}
	
	//	 ####################### setter & getter #######################

	/**
	 * Sets the current leader (one of the teammates)
	 * @param robot the new leader
	 */
	public void setLeader(DataRobot robot){
		mLeader = robot;
	}

	/**
	 * Sets the current team target
	 * @param robot the new team target
	 */
	public void setTeamTarget(DataRobot robot){
		mTeamTarget = robot;
	}
	
	/**
	 * Checks if there is a team leader and if he has selected
	 * a target
	 * @return true if there is a team target, otherwise false
	 */
	public boolean hasTeamTarget(){
		return (mGir.getNumTeammates() > 0) && 
				(mLeader != null) && 
				(mTeamTarget != null);
	}
	// ###############################################################
	
		
	/**
	 * Checks if a robot position is in the battlefield
	 * @param v Position to be checked
	 * @return true if v is in the battlefield, otherwise false
	 */	
	private boolean isInBattleField(DataVector v) {
		if(v.x < 18 || v.y < 18 || v.x > mGir.getBattleFieldWidth()-18 || v.y > mGir.getBattleFieldHeight()-18)
			return false;
		return true;
	}	
	
	

}
