package pl.Patton.Guns;

import robocode.*;

import pl.Abstract.Gun;
import pl.Enemy.AdvancedEnemy;

/*******************************************************************************
 * A gun that utilizes Pattern Matching targeting.
 * 
 * Since: 1.54
 * 
 * Last changed: 1.54
 * 
 * Created based on:
 * 
 * apv.NanoLauLectrick found at
 * http://robowiki.net/cgi-bin/robowiki?NanoLauLectrik
 ******************************************************************************/
public class PMGun extends Gun {

	public static int n;
	public static double[] ev;
	public static StringBuffer pattern;

	public static AdvancedEnemy enemy;

	public PMGun(String name, AdvancedRobot robot) {
		super(name, robot);
		ev = new double[1 << 16];
		pattern = new StringBuffer();
	}

	public void run(AdvancedEnemy enemy0) {
		// If I did not already have an enemy
		if (enemy == null) {
			// I do now.
			enemy = enemy0;
		}
		// If I have a new enemy
		else if (enemy != enemy0) {
			// Switch to the new one
			enemy = enemy0;
		}
		double absBearing = robot.getHeadingRadians() + enemy.bearing;
		double firePower = enemy.distance < 200 ? 3.0 : 1.72;

		int pointer = (int) (enemy.velocity * Math.sin(enemy.heading - absBearing));
		n++;
		ev[n] = ev[n - 1] + pointer;
		pattern.append((char) pointer);
		int len = 30;
		do {
			pointer = pattern
					.lastIndexOf(pattern.substring(Math.max(pattern.length() - len, 0)), pattern
							.length() - 75);
			len--;
		} while (len * pointer < -1);
		pointer += len;
		robot.setTurnGunRightRadians(Math
				.sin((ev[pointer + ((int) (enemy.distance / 11))] - ev[pointer]) / enemy.distance
						+ absBearing - robot.getGunHeadingRadians()));
		if (robot.getGunHeat() == 0 && Math.abs(robot.getGunTurnRemaining()) < 5)
			robot.setFire(firePower);
	}
}
