package dummy.mini;

import robocode.*;
import java.awt.geom.Point2D;
import java.awt.Color;
import java.io.*;
import java.util.zip.*;

// Parakeet - bot by (Kwok-Cheung Li)
/*
2.40 -- (24/11/2005) changed sample rate to 1 sample/4 ticks, and increased size of patternbuffer.
-- disabled data saving
-- delayed mirroring to make life of anti-mirror systems a bit tougher :-)
-- some tweaks in bulletpower management

2.29 -- (11/11/2003) I could've sworn that I uploaded this update month's ago... guess I forgot. 
-- One tiny bugfix 
-- A tweak that improves the speed of the patternmatcher. 

2.27 -- (31/01/2003) Okay, I introduced some new bugs in the last updates. Let's hope that Parakeet actually reads the datafiles this time ;-) 
-- A tweak here and there... 

2.26 -- More bugfixes! This time, there was a bug when reading from a file. 
-- Less firepower at longer range


codesize: 1255
*/

public class Parakeet extends AdvancedRobot
{
	static EnemyData Enemy;
	static boolean found = false;
	static double radarturn = 1;
//	static boolean onevsone;
//	static String enemyName = "";
	public final static int delay = 40;
	static double[] posX = new double[delay];
	static double[] posY = new double[delay];
	static int pindex = 0;
	static int roundnr = 0;

	public static double angle_180(double ang)
	{
		return Math.atan2(Math.sin(ang), Math.cos(ang));
	}

	public static double sign(double val)
	{
		if (val == 0.0)
			return 0;
		else
			return Math.abs(val) / val;
	}

	public void adjustMaxSpeed(double ang, double minimumspeed)
	{
		double a = Math.abs(Math.toDegrees(ang));
		setMaxVelocity(Math.max((40 / 3 - 4 * a / 3), minimumspeed));
	}

/*	public void readData()
	{
		try
		{
			FileInputStream f_in = new FileInputStream(getDataFile(cappedName() + ".dat"));
			ObjectInputStream input = new ObjectInputStream(f_in);
			Enemy.PC = input.readInt();
			Enemy.dX = (float[]) input.readObject();
			Enemy.dY = (float[]) input.readObject();
		} catch (IOException e)
		{
		} catch (ClassNotFoundException e)
		{
		}
	}
	
	public static String cappedName()
	{
		int spacepos = enemyName.indexOf(" ");
		if (spacepos != -1)
			return enemyName.substring(0, spacepos);
		return enemyName;
	}
*/
	public void run()
	{
		setColors(new Color(7929790), Color.green, Color.yellow);
		roundnr = getRoundNum();
		found=false;
//		onevsone = (getOthers() == 1);
		if (getRoundNum() == 0)
			Enemy = new EnemyData();
		
		//Enemy.init();
		Enemy.next_sample_time = 0;
		
		do
		{
			turnRadarRightRadians(1);
		} while (!found);

/*		if (onevsone && roundnr == 0)
			readData();
*/
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setAdjustRadarForRobotTurn(true);
		do
		{
			if (found)
			{
				radarturn = angle_180(Enemy.bearing - getRadarHeadingRadians());
				radarturn += sign(radarturn) * Math.PI / 32;
				setTurnRadarRightRadians(radarturn);
			} else
			{
				setTurnRadarRightRadians(sign(radarturn));
			}
			//double posx = getBattleFieldWidth() - (getX() + Enemy.X);
			//double posy = getBattleFieldHeight() - (getY() + Enemy.Y);
			int tindex = (pindex + 1)%delay;
			double posx = getBattleFieldWidth() - (getX() + posX[tindex]);
			double posy = getBattleFieldHeight() - (getY() + posY[tindex]);
			/////

			// Move to that position
			double turn = angle_180(Math.atan2(posx, posy) - getHeadingRadians());
			double turn_a = Math.atan(Math.tan(turn));
			double forward = Point2D.distance(0,0,posx,posy);
			if (Math.abs(turn_a - turn) > 1)
				forward = -forward;
			adjustMaxSpeed(turn_a, 3);
			setTurnRightRadians(turn_a);
			setAhead(forward);

			//double bulletPower = Math.max(Math.min(Enemy.energy / 4, Math.min(3, .004*(1050-Enemy.distance))), .1);
			//double bulletPower = Math.min(Math.min(3, getEnergy()/10), Enemy.energy/4);
			double bulletPower = Math.min( Math.max(20/3 - Enemy.distance/(3*45), .1), 
											Math.min(Enemy.energy/4, 3));
			double gunAim = Enemy.bearing;
			if ((getGunHeat() / getGunCoolingRate()) < 3)
				gunAim = Enemy.predictAngle(getX(), getY(), bulletPower, getTime());

			setTurnGunRightRadians(angle_180(gunAim - getGunHeadingRadians()));
			if (Math.abs(getGunTurnRemaining()) < 10)
				setFire(bulletPower);
			found = false;
			execute();
		} while (true);
	}

	public void onScannedRobot(ScannedRobotEvent e)
	{
		found = true;
		//enemyName = e.getName();
		double enemyBearing = angle_180(e.getBearingRadians() + getHeadingRadians());
		double enemyX = e.getDistance() * Math.sin(enemyBearing) + getX();
		double enemyY = e.getDistance() * Math.cos(enemyBearing) + getY();
		Enemy.updateInfo(getTime(), enemyX, enemyY, enemyBearing, e.getDistance(), e.getEnergy());
		posX[pindex] = enemyX;
		posY[pindex] = enemyY;
		pindex = (pindex + 1)%delay;
	}

/*	public void onWin(WinEvent e)
	{
		if (((roundnr + 1) == getNumRounds()) && onevsone && (getDataQuotaAvailable() > 7000))
		{
			try
			{
				RobocodeFileOutputStream f_out = new RobocodeFileOutputStream(getDataFile(cappedName() + ".dat"));
				ObjectOutputStream output = new ObjectOutputStream(f_out);
				output.writeInt(Enemy.PC);
				output.writeObject(Enemy.dX);
				output.writeObject(Enemy.dY);
				output.close();
			} catch (IOException exception)
			{
			}
		}
	}

	public void onDeath(DeathEvent e)
	{
		onWin(null);
	}*/
}
