package tobe.platform;
import tobe.statistics.*;
import tobe.util.*;
import java.io.*;
import robocode.ScannedRobotEvent;

public class CommandCentre
{
	public CommandCentre(robocode.AdvancedRobot bot) {
		this.bot = bot;
		playingField.setRect(0,0,bot.getBattleFieldWidth(),bot.getBattleFieldHeight());
		targetStats = new CircularArray(bot.getOthers());
	}
	
	private java.awt.geom.Rectangle2D.Double playingField = new java.awt.geom.Rectangle2D.Double();
	public java.awt.geom.Rectangle2D.Double getPlayingField() {
		return playingField;
	}
	
	public robocode.AdvancedRobot getBot() {
		return bot;
	}
	
	private TargetStatistics lastPreferredTarget;
	private double timeCalculated;
	/** target selection strategy */
	public TargetStatistics getPreferredTarget() {
		if(timeCalculated == bot.getTime()) return lastPreferredTarget;
		BearingVector b = new BearingVector();
		TargetStatistics target = null;
		double distance = 10000;
		//don't keep firing if last target died
		if(lastPreferredTarget != null && !lastPreferredTarget.isSeen()) lastPreferredTarget = null;
		//don't keep firing at faraway targets if others are closer
		if(lastPreferredTarget != null && lastPreferredTarget.getDistance(bot.getX(), bot.getY()) > 176) lastPreferredTarget = null;
		java.util.Iterator i = getTargetStatisticsIterator();
		while(i.hasNext() && !(target != null && target.getEnergy() == 0) ) {
			TargetStatistics t = (TargetStatistics) i.next();
			if(t.isSeen() && !t.isMercyShot()) {
				b.setVector(t.getPosition());
				b.changeOrigin(bot.getX(), bot.getY());
				if(target == null || t.getEnergy() == 0 ||
				(t == lastPreferredTarget && (b.getDistance() < distance*2 && (distance > 150 || b.getDistance() < distance)))
				|| (target == lastPreferredTarget && (b.getDistance() < distance/2 || (b.getDistance() < distance && b.getDistance() < 150)))
				|| (t != lastPreferredTarget && target != lastPreferredTarget && b.getDistance() < distance)) {
					target = t;
					distance = b.getDistance();
				}
			}
		}
		lastPreferredTarget = target;
		timeCalculated = bot.getTime();
		return target;
	}
	
	/** scanning strategy */
	public TargetStatistics getPreferredScanTarget() {
		TargetStatistics pref = getPreferredTarget();
		double bestV = 0;
		TargetStatistics scan = null;
		java.util.Iterator i = getTargetStatisticsIterator();//this is fast now
		while(i.hasNext()) {
			TargetStatistics t = (TargetStatistics) i.next();
			if(t.isSeen()) {
				double v = (bot.getTime()-t.getTime())*100/t.getDistance(bot.getX(), bot.getY());
				if(t == pref && bot.getGunHeat()/bot.getGunCoolingRate() < 6) {
					v += 4;
					//if(t.getDistance(bot.getX(), bot.getY()) < 150) v+=3;
				}
				if(v > bestV) {
					bestV = v;
					scan = t;
				}
			}
		}
		return scan;
	}
	
	public java.util.Iterator getTargetStatisticsIterator() {
		return targetStats.iterator();
	}
	
	public tobe.statistics.TargetStatistics getTargetStatistics(String name) {
		if(name == null) return null;
		TargetStatistics stat = (TargetStatistics) targetStatsMap.get(name);
		/* disable for now if( stat == null) {
			try {
				ObjectInputStream is = new ObjectInputStream(new FileInputStream(bot.getDataFile("target_"+name+".dat")));
				stat = (TargetStatistics) is.readObject();
				targetStatsMap.put(name,stat);
				targetStats.add(stat);
				is.close();
			}
			catch (IOException e) {
				bot.out.println(e);
				stat = null;
			}
			catch (ClassNotFoundException e) {
				bot.out.println(e);
				stat = null;
			}
		} */
		if( stat == null ) {
			stat = new TargetStatistics(name);
			targetStatsMap.put(name,stat);
			targetStats.add(stat);
		}
		return stat;
	}
	
	public boolean allOppsSeen() {
		if(targetStats.size() < bot.getOthers()) return false;
		java.util.Iterator i = getTargetStatisticsIterator();
		while(i.hasNext()) {
			TargetStatistics t = (TargetStatistics) i.next();
			if(!t.isSeen()) return false;
		}
		return true;
	}
	
	public TargetStatistics getMyStats() { return myStats; }
		
	public java.util.Iterator getShrapnelIterator() {return shrapnel.iterator();}
	
//modifying
	private BearingVector b = new BearingVector();
	
	public void digestScan(ScannedRobotEvent e, boolean justFired) {
		double x = bot.getX();
		double y = bot.getY();
		double h = bot.getBattleFieldHeight();
		double w = bot.getBattleFieldWidth();
		TargetStatistics t = getTargetStatistics(e.getName());
		t.digestScan(e, bot.getHeadingRadians(), x, y, justFired);
		double firedBullet = t.firedBullet(e.getTime());
		if(firedBullet > 0) {
			double myHeading = bot.getHeadingRadians();
			if(bot.getVelocity() < 0) myHeading = BearingVector.normalizeAngle(myHeading+Math.PI);
			bot.addCustomEvent(new EvasionCondition(bot,
										null,//null is my TargetStatistics. This should never be affected by anything else
										t.getDistance(x, y)/(20 - 3*firedBullet),
										bot.getTime(),
										myHeading, Math.abs(bot.getVelocity()),
										x, y));
			//add some shrapnel
			double shotPower = firedBullet;
					double bulletVelocity = (20-3*shotPower);
					double timeToHit = t.getDistance(x, y)/bulletVelocity;
					CircularArray evasions = getMyStats().getEvasions();
					if(evasions.size() > 0) {
						//for(int j=0; j<evasions.size() && j<5;j++){
						int k = (int) (Math.random()*evasions.size());
						Evasion ev = (Evasion) evasions.get(k);
						b.setPolar(ev.getHeadingRelativeHeading() + myHeading, ev.getVelocity()*timeToHit, x, y);
						shrapnel.add(new Shrapnel(shotPower, 2, t.getPosition(), b.getToX(), b.getToY(), w, h));
						shrapnel.add(new Shrapnel(shotPower, 5, t.getPosition(), b.getToX(), b.getToY(), w, h));
						shrapnel.add(new Shrapnel(shotPower, 8, t.getPosition(), b.getToX(), b.getToY(), w, h));
						//}
					} //else {
						//linear shot
						double v = Math.abs(bot.getVelocity());
						shrapnel.add(new Shrapnel(shotPower, 2, t.getPosition(), x+Math.sin(myHeading)*v*timeToHit, y+Math.cos(myHeading)*v*timeToHit, w, h));
						shrapnel.add(new Shrapnel(shotPower, 5, t.getPosition(), x+Math.sin(myHeading)*v*timeToHit, y+Math.cos(myHeading)*v*timeToHit, w, h));
						shrapnel.add(new Shrapnel(shotPower, 8, t.getPosition(), x+Math.sin(myHeading)*v*timeToHit, y+Math.cos(myHeading)*v*timeToHit, w, h));
					//}
						//straight shot
						shrapnel.add(new Shrapnel(shotPower, 2, t.getPosition(), x, y, w, h));
						shrapnel.add(new Shrapnel(shotPower, 5, t.getPosition(), x, y, w, h));
						shrapnel.add(new Shrapnel(shotPower, 8, t.getPosition(), x, y, w, h));
		
			if(bot.getOthers() > 1) {
				java.util.Iterator i = getTargetStatisticsIterator();
				while(i.hasNext()) {
					TargetStatistics z = (TargetStatistics) i.next();
					if(z != t && z.isSeen()) {
						shrapnel.add(new Shrapnel(shotPower, 2, t.getPosition(), z.getPosition(), bot.getBattleFieldWidth(), bot.getBattleFieldHeight()));
						shrapnel.add(new Shrapnel(shotPower, 5, t.getPosition(), z.getPosition(), bot.getBattleFieldWidth(), bot.getBattleFieldHeight()));
						shrapnel.add(new Shrapnel(shotPower, 8, t.getPosition(), z.getPosition(), bot.getBattleFieldWidth(), bot.getBattleFieldHeight()));
					}
				}
			}
		}
		//bot.out.println("Added scan for "+e.getName()+" "+t.getX()+", "+t.getY());
	}
	
	public void addEvasion(EvasionCondition e) {
		TargetStatistics t = getTargetStatistics(e.enemyName);
		if(t == null) t = myStats;
		t.addEvasion(e, bot.getTime());
	}
	
	public void robotDied(String name) {
		TargetStatistics stat = getTargetStatistics(name);
		stat.died();
		//forget it for now. saveObject("target_"+stat.getName()+".dat", stat);
	}
	
	//call this every frame
	public void tick() {
		double x = bot.getX();
		double y = bot.getY();
		myStats.updateInfo(x, y, bot.getHeading(), bot.getVelocity(), bot.getTime());
			
			//remove old shrapnel
			java.util.Iterator i = shrapnel.iterator();
			while( i.hasNext() ) {
				Shrapnel s = (Shrapnel) i.next();
				if(s.passed(x, y)) {
					i.remove();
				}
			}
	}
	
	//call this on game-restart
	public void reset() {
		java.util.Iterator i = getTargetStatisticsIterator();
		while(i.hasNext()) {
			TargetStatistics t = (TargetStatistics) i.next();
			t.reset();
		}
	}
	
	/** save the survivors */
	public void save() {
		for(int i = 0; i < targetStats.size(); i++) {
			TargetStatistics stat = (TargetStatistics) targetStats.get(i);
			if(stat.isSeen()) {
				saveObject("target_"+stat.getName()+".dat", stat);
			}
		}
	}
	
	public void saveObject(String filename, Object o) {
		bot.out.println("Quota left: "+bot.getDataQuotaAvailable());
		if(bot.getDataQuotaAvailable() < 40000) {
						File d = bot.getDataDirectory();
						File[] files = d.listFiles();
						java.util.Arrays.sort(files, new java.util.Comparator() {
							public int compare(Object l, Object r) {
								return (int) (((File) l).lastModified() - ((File) r).lastModified());
							}
						});
						files[0].delete();
		} else {
				try {
					ObjectOutputStream os = new ObjectOutputStream(
						new robocode.RobocodeFileOutputStream(bot.getDataFile(filename)));
					os.writeObject(o);
					os.close();
				}
				catch( IOException e ) {
					bot.out.println(e);
				}
		}
	}
	
	//java.util.ArrayList slots;
	protected java.util.HashMap targetStatsMap = new java.util.HashMap();
	protected CircularArray targetStats;//arrays are fast, that is why I do this double
	protected robocode.AdvancedRobot bot;
	protected TargetStatistics myStats = new TargetStatistics(null);
	private java.util.LinkedList shrapnel = new java.util.LinkedList();
}
