package vft;
import robocode.*;
import java.util.Random;
import java.awt.Color;
import java.awt.geom.Point2D;

/**
 * Valkyrie - a robot by Victor Fan
 * Movement: Basic Oscillation
 * Targeting: Heads-On
 * For the APCompsci Tournament 2006
 * Completion Status: Done
 **/
public class Valkyrie extends AdvancedRobot
{
	int WallSapper = 0;
	boolean CounterWall = false;
	double pie = Math.PI; //mmmm, pie.
	/**
	 * run: Valkyrie's default behavior
	 */
	public void run() {
		setColors(Color.blue, Color.blue, Color.black); //No longer pink. v.v
		Random generator = new Random();
		while(true) {
			turnRadarRight(Double.POSITIVE_INFINITY);
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		//now THIS is a cool movement algorithm. I remember first using this code a long time ago, back when I
		//wasn't serious, and for the life of me I can't remember where I got it. If this belongs to one of you
		//and I stole it or something, tell me.
		if(Math.random() * 50 > Math.abs(getDistanceRemaining()))
		{
			setAhead((Math.random() - 0.5) * 435);
		}
		
		setTurnRightRadians(e.getBearingRadians() + pie/2);
		
		setTurnGunRightRadians(Double.POSITIVE_INFINITY); //continue scanning for targets
		if (getEnergy() > 1 && CounterWall != false) {
			fire(400/e.getDistance()); //basic energy conservation: fire harder when closer
		}
		//...it turned out that about half of the bots entered into the APCompsci competition were wallcrawlers,
		//probably because Walls owns all the other samplebots, so I added this code, copy-pasted from a wiki
		//challenge bot to use linear aiming. Since then, I've learned how to make a LOT less long-winded linear
		//aiming algorithms, but I'm lazy.
		else {
			double projectedPower = Math.min(3.0,getEnergy());
			double myX = getX();
			double myY = getY();
			double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
			double enemyX = getX() + e.getDistance() * Math.sin(absoluteBearing);
			double enemyY = getY() + e.getDistance() * Math.cos(absoluteBearing);
			double enemyHeading = e.getHeadingRadians();
			double enemyVelocity = e.getVelocity();
		
			double deltaTime = 0;
			double battleFieldHeight = getBattleFieldHeight(), battleFieldWidth = getBattleFieldWidth();
			double predictedX = enemyX, predictedY = enemyY;
			while((++deltaTime) * (20.0 - 3.0 * projectedPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)){		
				predictedX += Math.sin(enemyHeading) * enemyVelocity;	
				predictedY += Math.cos(enemyHeading) * enemyVelocity;
				if(	predictedX < 18.0 
					|| predictedY < 18.0
					|| predictedX > battleFieldWidth - 18.0
					|| predictedY > battleFieldHeight - 18.0){
				
					predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);	
					predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
					break;
				}
			}
			double theta = robocode.util.Utils.normalAbsoluteAngle(Math.atan2(predictedX - getX(), predictedY - getY()));

			setTurnRadarRightRadians(robocode.util.Utils.normalRelativeAngle(absoluteBearing - getRadarHeadingRadians()));
			setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(theta - getGunHeadingRadians()));
			fire(projectedPower);		
		}
	}

	public void onHitWall(HitWallEvent e) {
		back(200); //cuz Valkyrie kept on sticking to walls. x.X
		turnRight(45);
	}
	
	/**
	 * WallSapper: Yes, a big huge chunk of code sitting there ready
	 * to take Walls out. Isn't Walls special?
	 */
	
	public void onBulletHit (BulletHitEvent e) {
		if (CounterWall = false) {
			WallSapper = 0;
		}
		else if (WallSapper > 10){
			WallSapper = 0;
			CounterWall = false;
		}
	}
	
	public void onBulletMiss (BulletMissedEvent e) {
		WallSapper++;
		if (WallSapper > 6) {
			CounterWall = true;
		}
	}
}