package ags.rougedc.gun.util;

import ags.rougedc.robots.*;
import ags.utils.points.*;
import static robocode.util.Utils.normalAbsoluteAngle;

/**
 * @author Alexander Schultz
 */
public class DCEntry {
    public static double[] getPosition(AbsolutePoint source, EnemyRobot target, double w1, double w2) {
        final double[] position = new double[6];
        
        final double angle = normalAbsoluteAngle(Math.atan2(target.getLocation().x-source.x, target.getLocation().y-source.y));
        final double lateralVelocity = (target.getVelocity().magnitude * Math.sin(target.getVelocity().getDirection() - angle));
        final double advancingVelocity = (target.getVelocity().magnitude * -Math.cos(target.getVelocity().getDirection() - angle));
        //final double distance = target.getLocation().distance(status.getLocation());
        
        position[0] = Math.abs(lateralVelocity)/8.0;
        position[1] = advancingVelocity/8.0;
        position[2] = target.getHitCount()*0.0005; // TC20
        //position[2] = target.getHitCount()*0.1; // TC23
        position[3] = 1.0/(1+w1);
        position[4] = 1.0/(1+w2);
        position[5] = 1.0/(1+target.getTimeSinceDecel());
        
        return position;
    }
}
