package dft.bin;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Utils {
	
	public static Rectangle2D battleField;

	public static Point2D project(Point2D location, double angle, double distance) {
		return new Point2D.Double(location.getX() + Math.sin(angle) * distance, location.getY() + Math.cos(angle) * distance);
	}
	
	public static double normalRelativeAngle(double angle) {
		return robocode.util.Utils.normalRelativeAngle(angle);
	}
	
	public static double getGF(double angleOffset, double escapeEnvelope) {
		return Math.max(-1, Math.min(1, angleOffset/escapeEnvelope));
	}
	
	public static double absoluteBearing(Point2D source, Point2D target) {
		 return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
	}

	public static int hittableFactors(double distance, double totalFactors, double bulletSpeed) {		
		double escapeEnvelope = Math.asin(8.0/bulletSpeed);
		double angleOffset = 1/totalFactors;
		double angle = 0;
		Point2D origin = new Point2D.Double(0,0);
		Point2D next = project(origin,angle+angleOffset*escapeEnvelope,distance);
		origin = project(origin,angle,distance);
		distance = origin.distance(next);
		return (int)(24/distance);
	}	
	
	public static double escapeEnvelope(double direction, double bulletSpeed) {
		return direction*Math.asin(8.0/bulletSpeed);
	}
	
	public static int getIndex(double middleFactor, double GF) {
		return (int)Math.round(middleFactor*(GF+1));
	}
	
	public static double getClosestWall(Rectangle2D battleField, double x, double y) {
		double w = battleField.getWidth();
		double h = battleField.getHeight();		
		double centerX = w/2;
		double centerY = h/2;		
		if(x > centerX){
			if(y > centerY) 
				return w-x<h-y?90:0;
			return w-x<y?90:180;
	    }
	    if(y > centerY) return x<h-y?270:0;
	        return x<y?270:180;
	}
	
	public static double wallSmoothedAngle(Point2D location, double absBearing, double targetAngle, double heading, double direction, boolean smoothAway) {
		Point2D destination;
		double angle = targetAngle+0.1;
		while (!battleField.contains(destination = project(location, absBearing + direction*(angle+=smoothAway?0.1:-0.1), 200)));
		return absoluteBearing(location, destination) - heading;		
	}
	
	public static double smoothed(int gf, double[] curr, int TOTAL_FACTORS) {
		double val = 0;
		for (int y = 1; y < TOTAL_FACTORS-1; y++) {
			val += (double)curr[y]/ Math.pow((double)(Math.abs(gf - y) + 1.0),0.5);
		}
		return val;
	}
}
