package uccc;

import robocode.*;
import robocode.util.Utils;

import java.awt.*;
import uccc.util.*;

/*
 * TODO:Write a method to cause the turning rate change. Something sinusoidal
 * should be fine. We want to see if the turning radius that RoboCode reflects
 * is accurate or not. At a constant speed, with a varying rate of rotation,
 * the turning circle should change size.
 */

public class Dorito extends AdvancedRobot {
	// Variabes related to our bot (dataType botXXXXXX)
	int botX = 0;
	int botY = 0;
	double botHeadingInRadians = 0;
	double botRateOfRotationInRadians = 0;
	double botRateOfRotationInDegrees = 0;
	double botVelocity = 0;
	double botTurningRadius = 0;

	// Variables related to our enemy
	double enemyX = 0;
	double enemyY = 0;
	double enemyBearingInRadians = 0;
	double enemyDistance = 0;
	double enemyVelocity = 0;

	// Dorito-specific flavorings
	double speed = 0;
	double turn = 0;
	boolean turningRight = true;
	boolean accel = true;
	int wallSmoothingDistance = 150;
	
	// RingDing-Specific flavorings
	int timeout = 0;

	ScannedRobotEvent lastevent;
	double keepdist = 300;
	double bulletPower = 1;
	int timeSinceScan =0;

	/**
	 * Do all the normal debug output here. Special stuff can go inside robot
	 * methods.
	 */
	public void writeDebugToConsole() {
	}

	/**
	 * Derives information about the robot based on the games physics constants.
	 * Ex: Knowing the formula for calculating rate of rotation, we can compute
	 * turning circles, etc. Because some values are composite functions, they
	 * need to be done in the proper order. This method helps organize that.
	 */
	public void collectRobotData() {
		// Store get method data in primitives for quick access.
		botX = (int) this.getX();
		botY = (int) this.getY();
		botHeadingInRadians = this.getHeadingRadians();
		botVelocity = this.getVelocity();

		// Calculate the turningRadius.
		/*
		 * if (botRateOfRotationInRadians != 0) { botTurningRadius =
		 * (this.getVelocity() / botRateOfRotationInRadians); } else {
		 * botTurningRadius = -1; // TODO: This must be documented! }
		 */
		// botRateOfRotationInRadians =
		// Rules.getTurnRateRadians(this.getVelocity());

		// Jules' botTurningRadius = (360*this.getVelocity()) /
		// (((10-0.75*this.getVelocity()) * 2 * Math.PI));
		botTurningRadius = Math.abs(this.getVelocity())
				/ Rules.getTurnRateRadians(Math.abs(this.getVelocity()));
		out.println("botVelocity: " + this.getVelocity());
		out.println("botRateOfRotationInRadians: " + Rules.getTurnRateRadians(this.getVelocity()));
		out.println("botTurningRadius: " + botTurningRadius);
	}

	/**
	 * Find out what quadrant the enemy is in relation to our heading
	 * 
	 * @return Direction TODO: Simplify if statements, is it necessary to check
	 *         two values?
	 */
	public Direction getRelitiveEnemyBearing() {
		if ((enemyBearingInRadians >= (-2 * (Math.PI / 2)))
				&& (enemyBearingInRadians < (-1 * (Math.PI / 2)))) {
			return Direction.SOUTHWEST;
		} else if ((enemyBearingInRadians >= (-1 * (Math.PI / 2)))
				&& (enemyBearingInRadians < (0 * (Math.PI / 2)))) {
			return Direction.NORTHWEST;
		} else if ((enemyBearingInRadians >= (0 * (Math.PI / 2)))
				&& (enemyBearingInRadians < (1 * (Math.PI / 2)))) {
			return Direction.NORTHEAST;
		} else {
			return Direction.SOUTHEAST;
		}
	}

	/**
	 * Do it to it
	 */
	public void run() {
		this.setAdjustGunForRobotTurn(true);
		this.setAdjustRadarForGunTurn(true);
		this.setAdjustRadarForRobotTurn(true);
		this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
		while (true) {
			collectRobotData();
			out.println("RadarTurnRemainingRadians: " + this.getRadarTurnRemainingRadians());
			/*
			 * Do some trickery to modulate the speed so we can watch the
			 * turning circle grow and shrink.
			 */
			// setAhead(Double.POSITIVE_INFINITY);
			// this.setVelocityRate(speed);
			// this.setTurnRateRadians(speed / Math.PI);
			if (this.getTime() % 3 == 0) {
				if (turningRight == true) {
					if (turn == 12) {
						turningRight = false;
					}
					turn++;

				} else {
					if (turn == -12) {
						turningRight = true;
					}
					turn--;
				}
			}			
			this.setAhead(Double.POSITIVE_INFINITY);
			this.setTurnRightRadians(turn);

			avoidWalls();

			execute();
		}
	}

	public void onHitWall(HitWallEvent e) {

	}

	public void onHitRobot(HitRobotEvent e) {

	}

	public void avoidWalls(){
		double turningRadiusPiviotX = 0.0;
		double turningRadiusPiviotY = 0.0;
		if (
				((turn > 0) && (this.getVelocity() > 0)) ||
				((turn < 0) && (this.getVelocity() < 0))){
			turningRadiusPiviotX = (this.getX() + (Math.cos(this
					.getHeadingRadians()) * botTurningRadius));
			turningRadiusPiviotY = (this.getY() - (Math.sin(this
					.getHeadingRadians()) * botTurningRadius));
		} else {
			turningRadiusPiviotX = (this.getX() - (Math.cos(this
					.getHeadingRadians()) * botTurningRadius));
			turningRadiusPiviotY = (this.getY() + (Math.sin(this
					.getHeadingRadians()) * botTurningRadius));
		}
		
		if(turningRadiusPiviotX-botTurningRadius<=18 ||
				turningRadiusPiviotX+botTurningRadius >= (this.getBattleFieldWidth() - 36) ||
				turningRadiusPiviotY-botTurningRadius<=18 ||
				turningRadiusPiviotY+botTurningRadius>=(this.getBattleFieldHeight() - 36)
				){
			this.setAhead(0);
		}
		
	}
	
	public double targetRoutine(ScannedRobotEvent e) {
		// Get our absolute bearing to the enemy in radians
		double bearing =
	        getHeadingRadians() + e.getBearingRadians();
		// Create a new vector in space in the direction
		// of the bearing, with a length of 1
		Vec2 bearingVec = new Vec2(bearing, 1);
		// Create an orthogonal vector.. by adding 90 degrees
		// to our angle, then clamp it
		// because it could be over 2*PI
		bearing = getRadianClamp(bearing+Math.PI/2);
		// Create our basis vector. This is what the enemy
		// heading will be projected onto
		Vec2 basis = new Vec2(bearing, 1);
		// Create our vector enemy heading vector, with a
		// magnitude equal to its velocity
		Vec2 enemyHead = new Vec2(e.getHeadingRadians(), e.getVelocity());
		// Project the enemy heading down onto our basis.
		// This gives us the estimated arc movement
		// direction and magnitude.
		Vec2 proj = Vec2.proj(enemyHead, basis);
		// Get the speed of our current bullet power
		double bulletSpeed = Rules.getBulletSpeed(bulletPower);
		// Get the time it takes a bullet to reach the edge
		// of a circle with a radius equal to the distance
		// between us and the enemy
		double t = bulletSpeed/e.getDistance();
		// Multiply our projected vector by our time variable
		proj.mult(t);
		// Add the predicted vector to our bearing to the enemy 
		proj.add(bearingVec);
		// This gives us the angle that our robot wants
		// to aim at.
		return proj.getAngle();
	}
	/**
	 * Clamp a radian value between 0 and 2*PI
	 * @param a	A radian value between -2*PI and 4*PI
	 * @return 	A radian value between 0 and 2*PI
	 */
	public double getRadianClamp(double a) {
		if (a>Math.PI*2)
			a-=Math.PI*2;
		if (a<0)
			a+=Math.PI*2;
		return a;
	}
	public double getShortAngle(double a1, double a2)
	{
	    double angle = (a1 - a2);

	    if(angle > Math.PI)
	        angle = 2*Math.PI - angle;
	    if(angle < -1*Math.PI) 
	    	angle = -1 * (2*Math.PI + angle);
	    if( a1<=Math.PI/2 && a2 > 3*Math.PI/2 ) {
	    	angle = Math.abs(angle);
	    }
	    if( a2<=Math.PI/2 && a1 > 3*Math.PI/2 ) {
	    	angle = Math.abs(angle)*-1;
	    }
	    return angle;
	}	
	
	public void onScannedRobot(ScannedRobotEvent e) {
		enemyBearingInRadians = e.getBearingRadians();
		enemyDistance = e.getDistance();
		enemyVelocity = e.getVelocity();
		// enemyX = (botX + (Math.sin(botHeadingInRadians +
		// enemyBearingInRadians) * enemyDistance));
		// enemyY = (botY + (Math.cos(botHeadingInRadians +
		// enemyBearingInRadians) * enemyDistance));
		enemyX = (this.getX() + (Math.sin(this.getHeadingRadians()
				+ enemyBearingInRadians) * enemyDistance));
		enemyY = (this.getY() + (Math.cos(this.getHeadingRadians()
				+ enemyBearingInRadians) * enemyDistance));
		
		timeSinceScan = 0;
		adjustBulletPower(e);
		lastevent = e;
		double radarTurn =
        // Absolute bearing to target
        getHeadingRadians() + e.getBearingRadians()
        // Subtract current radar heading to get turn required
        - getRadarHeadingRadians();
		//double gunTurn = 0.05;
		double gunTurn;
		
		//if (e.getDistance()<50) {
		//	gunTurn = getShortAngle(getHeadingRadians() + e.getBearingRadians(),getGunHeadingRadians());
		//}
		//else {
			gunTurn = getShortAngle(targetRoutine(e),getGunHeadingRadians());
		//}
			
        // Subtract current radar heading to get turn required
		//Vec2 v1 = new Vec2(gunTurn, e.getDistance());
		//v1.add(new Vec2(e.getHeadingRadians(),e.getVelocity()*e.getDistance()/100));
		//double gunTurn2 = v1.getAngle() - getGunHeadingRadians();
		

		//setTurnRight(headTurn);
		setTurnRadarRightRadians(2.0 *Utils.normalRelativeAngle(radarTurn));
		setTurnGunRightRadians(gunTurn);
		if (e.getDistance()<keepdist+100) {
			setFire(bulletPower);
		}
	}

	/**
	 * Adjust our bullet power based on distance
	 * @param e	The last time we scanned a robot
	 */
	public void adjustBulletPower(ScannedRobotEvent e) {
		if (e.getDistance()>100) 
			bulletPower=1;
		if (e.getDistance()<=100) {
			bulletPower = keepdist/e.getDistance()*3;
		}
	}	
	
	public void onPaint(Graphics2D g) {
		double foreX = (Math.sin(botHeadingInRadians) * wallSmoothingDistance / 2);
		double foreY = (Math.cos(botHeadingInRadians) * wallSmoothingDistance / 2);
		double aftX = (Math.sin(botHeadingInRadians) * -wallSmoothingDistance / 2);
		double aftY = (Math.cos(botHeadingInRadians) * -wallSmoothingDistance / 2);
		double starboardX = (botX + (Math
				.sin(botHeadingInRadians + Math.PI / 2)
				* wallSmoothingDistance / 2));
		double starboardY = (botY + (Math
				.cos(botHeadingInRadians + Math.PI / 2)
				* wallSmoothingDistance / 2));
		double portX = (botX + (Math.sin(botHeadingInRadians - Math.PI / 2)
				* wallSmoothingDistance / 2));
		double portY = (botY + (Math.cos(botHeadingInRadians - Math.PI / 2)
				* wallSmoothingDistance / 2));

		double turningRadiusPiviotX = 0.0;
		double turningRadiusPiviotY = 0.0;
		if (
				((turn > 0) && (this.getVelocity() > 0)) ||
				((turn < 0) && (this.getVelocity() < 0))){
			turningRadiusPiviotX = (this.getX() + (Math.cos(this
					.getHeadingRadians()) * botTurningRadius));
			turningRadiusPiviotY = (this.getY() - (Math.sin(this
					.getHeadingRadians()) * botTurningRadius));
		} else {
			turningRadiusPiviotX = (this.getX() - (Math.cos(this
					.getHeadingRadians()) * botTurningRadius));
			turningRadiusPiviotY = (this.getY() + (Math.sin(this
					.getHeadingRadians()) * botTurningRadius));
		}
		
		/*
		 * Draw battlefield boundaries. Get any closer than this and you hit a
		 * wall.
		 */
		g.setColor(Color.GRAY); // TODO : Improve cast double to int
		g.drawRect(18, 18, (int) this.getBattleFieldWidth() - 36, (int) this
				.getBattleFieldHeight() - 36);

		// Draw the feeler's radius
		g.setColor(Color.YELLOW);
		g.drawOval(botX - wallSmoothingDistance / 2, botY
				- wallSmoothingDistance / 2, wallSmoothingDistance,
				wallSmoothingDistance);

		// Draw the turning radius
		if(
				((turn != 0) && (this.getVelocity() != 0))
				){
		g.setColor(Color.PINK); // TODO : Improve cast double to int
		g.drawOval((int) (turningRadiusPiviotX - botTurningRadius),
				(int) (turningRadiusPiviotY - botTurningRadius),
				(int) (2.0 * botTurningRadius), (int) (2.0 * botTurningRadius));
		}
		// Drop some painting debug into the console
		out.println("Piviot Point (x,y) = " + turningRadiusPiviotX + " "
				+ turningRadiusPiviotY);

		// Draw a circle around the bot
		g.setColor(Color.CYAN);
		g.drawOval(botX - wallSmoothingDistance / 2, botY
				- wallSmoothingDistance / 2, wallSmoothingDistance,
				wallSmoothingDistance);

		// Draw Origin node
		g.setColor(Color.GREEN); // TODO : Improve cast double to int
		g.drawOval((int) (turningRadiusPiviotX - 10.0),
				(int) (turningRadiusPiviotY - 10.0), 20, 20);

		// Draw Starboard feeler
		g.setColor(Color.GREEN); // TODO : Improve cast double to int
		g.drawLine(botX, botY, (int) starboardX, (int) starboardY);

		// Draw directional nodes
		g.setColor(Color.WHITE); // TODO : Improve cast double to int
		g.drawOval((int) (botX - foreX - 10), (int) (botY - foreY - 10),20, 20);
		g.setColor(Color.GRAY); // TODO : Improve cast double to int
		g.drawOval((int) (botX - aftX - 10), (int) (botY - aftY - 10), 20, 20);
		g.setColor(Color.GREEN); // TODO : Improve cast double to int
		g.drawOval((int) (starboardX - 10), (int) (starboardY - 10), 20, 20);
		g.setColor(Color.RED); // TODO : Improve cast double to int
		g.drawOval((int) (portX - 10), (int) (portY - 10), 20, 20);

		// Draw enemy reticle and trace the bearing
		g.setColor(Color.RED); // TODO : Improve cast double to int
		g.drawOval((int) (enemyX - 10), (int) (enemyY - 10), 20, 20);
		g.drawLine(botX, botY, (int) enemyX, (int) enemyY);

	}

}
