package jwst.DAD.SpecialRobots;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.*;
import java.util.ArrayList;

import robocode.*;
import robocode.util.Utils;

import jwst.Enemies.*;
import jwst.DAD.Scanning.*;
import jwst.DAD.Targeting.*;
import jwst.DAD.utils.*;
import jwst.DAD.Movement.*;


/*************************************************************************************************
 * So basically, we made two separate classes for our robot: one that handles the melee 
 * and one that handles the one v one. This the class that handles all the 1v1 events. Most 
 * of the actual code, however, is in the wavesurfing/guessfactortargeting classes.
 * 
 * @author Jared Wong
 * @author Shawn Thomas
 * @period Period 2
 * 
 *************************************************************************************************/

public class OneVOneBot extends specializedRobot
{
    // make simple primordial objects of a scanner and a single enemy(seeing as its one v one) 
    private Scanner scanner;
    private AdvancedEnemy enemy;
    // make an ArrayList of enemies due to the fact that they cold change when using the same object
    // due to the fact that this is going to be used during melee
    private static ArrayList<AdvancedEnemy> enemies = new ArrayList<AdvancedEnemy>();

    /**
     * A constructor for a one v one robot
     * @param robot - the AdvancedRobot that will be controlled
     */
    public OneVOneBot( AdvancedRobot robot )
    {
        // initiate the constructor in the abstract class SpecializedRobot
        super( robot );
        
        // set the battle field width and height
        // essential for wave surfing
        DADUtils.setBattleFieldWidth( this.robot.getBattleFieldWidth() );
        DADUtils.setBattleFieldHeight( this.robot.getBattleFieldHeight() );
        
        // construct the scanner
        scanner = new Scanner( this.robot );
    }

    /**
     * the basic run method to be called first in a one v one situation
     * it is analogous to the run method first called in the main robot
     */
    public void run()
    {
        // set all of the parts of the bot free from each other
        robot.setAdjustRadarForGunTurn( true );
        robot.setAdjustRadarForRobotTurn( true );
        robot.setAdjustGunForRobotTurn( true );
        
        // run and execute continuously
        // must do the SAME EXACT things as the melee continuous method in run
        while ( true )
        {
            scanner.run();
            robot.execute();
        }
    }

    /**
     * on a scanned robot in a one v one situation this method is called
     */
    public void onScannedRobot( ScannedRobotEvent e )
    {
        // if the enemy i have is null or if it is a new enemy
        if(enemy == null || enemy.getName() != e.getName())
        {
            // first loop through the enemies ArrayList and see if any of them match the
            // robot scanned
            for(int i = 0; i < enemies.size(); i++)
            {
                if(e.getName().equals( enemies.get( i ).getName()))
                    enemy = enemies.get( i );
            }
            // if the enemy still is null
            // then add one to the enemies ArrayList and set enemy equal to that new one
            if(enemy == null)
            {
                enemies.add(0, new AdvancedEnemy(e, robot) );
                enemy = enemies.get(0);
            }
        }
            
        // update the enemy
        enemy.update( e, robot );
        // print out is name
        System.out.println(enemy.getName());
        // run the tank of the given enemy (most important to have a tank for each
        // enemy robot seeing as each will act differently from one and another)
        enemy.tank.run( enemy );
        // run the gun of the given enemy (most important to have a gun for each
        // enemy robot seeing as each will act differently from one and another)
        enemy.gun.fire( enemy );
        // lock onto this enemy
        scanner.lock( e );
    }


    public void onBulletHit( BulletHitEvent e )
    {
        // if i hit the enemy with a bullet increment my hit count
        enemy.gun.hits++;
    }


    public void onHitByBullet( HitByBulletEvent e )
    {
        // My enemy has recharged
        enemy.energy += e.getBullet().getPower() * 3.0;
        // I was hit
        enemy.tank.logHitByBullet( e );
    }

    public void onWin( WinEvent e )
    {
        enemy.tank.onWin( e );
    }
    
    public void onDeath( DeathEvent e )
    {
        enemy.tank.onDeath( e );
    }

    public void onHitWall(HitWallEvent e)
    {
        robot.setAhead(100 * - enemy.tank.moveDir);
    }

    public void onPaint( Graphics2D g )
    {
        enemy.gun.onPaint( g );
        enemy.tank.onPaint( g );
    }


    public String toString()
    {
        return "I'm a one v one bot!";
    }
}
