package kanishk;

import robocode.*;
import java.awt.Color;
import java.awt.geom.*;
import robocode.util.Utils;
/**
 * Fr0z3n - a demolishing robot by Kanishk Kunal.
 * With all new Startegies never seen before ;)
 * Added an anti-sample.walls strategy in v1.1
 * Only of IIT-A gladiator competition, a 1v1 robot for a battle field of 1000X1000
 * @todo Make battlefield size independent everywhere
 * @version 1.1
 * @edited 30-09-2005
 * @mail: kanishkkunal@yahoo.co.in
 */
public class Fr0z3n extends Robot
{
    Point2D myLocation;
    double direction = 1;
    int count = 0; // opponents stationary?
    int bulletgot = 0;
    int bullet = 1; //bullet getting missed?
    int countbullet = 0; //should i hit?
    double lasthitwall = Double.MAX_VALUE; //getting hit by wall?

    boolean iswalls = true; //check whther my opponent is walls?
    int countwalls = 0;
    boolean confirmedwalls = false; //walls confirmed
    Rectangle2D field;
    MyEnemy enemy = new MyEnemy();
	/**
	 * run: Fr0z3n's rules ;)
	 *
	 */
	public void run() {

		//some funky colors for Fr0z3n
		setColors(Color.lightGray,Color.gray,Color.gray);
		//for movement //added in version 1.1
        field = new Rectangle2D.Double(20, 20, getBattleFieldWidth()-40, getBattleFieldHeight()-40);
		while(true) {
		//here goes the demolishing code
		//Enemy's run
        myLocation = new Point2D.Double(getX(), getY());
        if(enemy.name==null)
            turnRadarLeft(360); //get a full view
        else {
            //do narrow radar
            double radarTurn = Math.toDegrees(Utils.normalRelativeAngle(angle(enemy.location, myLocation)-Math.toRadians(getRadarHeading())));
            radarTurn = (int)(radarTurn/45+(radarTurn > 0 ? 1 : -1))*30;
            enemy.name = null;  //reset the enemy to null to get the name in scan
            turnRadarRight(radarTurn);
            if (enemy.name == null)
            {
                turnRadarRight(radarTurn < 0 ? -360-radarTurn : 360-radarTurn);
            }
            if(confirmedwalls) {
                turnLeft(getHeading()%90);
                turnRight(90);
                ahead(1000);
                doWallsCounter();
                continue;
            }
            if (enemy.energy-getEnergy()<=getEnergy()/5)  {
                 doMovement2();    //if sufficient helth then aim to hit
            }
            else   {
                doMovement1();  //do some movement, circle starf, annoy the oppenent
            }
        }
		}
	}

	/*
	 * Added v1.1. Catch me if you can style
	 */
    void doMovement1() {
        Point2D last = myLocation;

        double distance = Math.max(200, myLocation.distance(enemy.location));
        double dir = angle(enemy.location, myLocation) + Math.PI/2*direction;
        Point2D next = projectPoint(myLocation, dir, distance); //where i will go?
        while (!field.contains(next = projectPoint(myLocation, dir, distance)))
                        dir -= direction*.1; //adjust the direction

        double movedir = (myLocation.distance(next)*1.3)/4;
        double turn = robocode.util.Utils.normalRelativeAngle(angle(next, myLocation)-Math.toRadians(getHeading()));
        if (Math.abs(turn) > Math.PI/2)
        {
            turn = robocode.util.Utils.normalRelativeAngle(Math.PI+turn);
            movedir = -movedir;
        }
        turnRight(Math.toDegrees(turn));
        //other people have done this by setting the max velocity to 0 or 8.  This seems to be 7 bytes smaller:
        ahead(movedir);
        if (getTime()%2 == 0)  {       //every two 'ticks'
            direction *= -1;        //reverse direction
        }

    }
   /*
    * Was there alone before v1.1
    */
    void doMovement2() {
        if (getTime()%4 == 0)  {       //every four 'ticks'
            direction *= -1;        //reverse direction
        }
        turnRight(enemy.bearing + 90); //every turn move to circle strafe the enemy
        int ah = 80;

        ahead(direction*ah);
       // System.out.println("here");
    }


    /*
    * Especially made to counter walls
    * added in v1.1
    */
    void doWallsCounter() {

       //turnRight(90);
       turnRadarLeft(360);
      ahead(100);
      direction*=-1;
    }

	/**
	 * onScannedRobot: What to do when you see another robot? Kill it ofcourse!
	 */
	public void onScannedRobot(ScannedRobotEvent e) {



	   enemy.name = e.getName();
       double absBearing = Math.toRadians(getHeading()+e.getBearing());
       enemy.location.setLocation(projectPoint(myLocation, absBearing, e.getDistance()));
       //System.out.println(enemy.location.getX()+" "+enemy.location.getY());
       enemy.distance = e.getDistance();
       enemy.energy = e.getEnergy();
       enemy.bearing = e.getBearing();

       double latd = e.getHeadingRadians()-absBearing;

       double power = 1;

        if(getTime()>180 && !confirmedwalls) {
        if(iswalls && isLocWalls(enemy.location) ) {
            countwalls++;
            iswalls=true;
            System.out.println("Suspected walls "+countwalls);
            if(countwalls>=5) {
                System.out.println("You shouldn't be following sample.walls");
                confirmedwalls=true;
                countwalls=0;
            }
        }
        else {
            //iswalls=false;
            confirmedwalls=false;
            countwalls=0;
        }
        }

       if(getGunHeat() < .2)
        {
            turnGunRight(Math.toDegrees(Utils.normalRelativeAngle(absBearing-Math.toRadians(getGunHeading())+0.01)));
              if(confirmedwalls && enemy.bearing<=5) {
                    System.out.println("firing to walls");
                    fire(3);
                    return;
               }
             if(e.getDistance()<200 && getEnergy()>20) {
                    fire(3);
                    return;
               }
               else
            power = 650/e.getDistance();
            if(confirmedwalls)
                power = 0.1;
            if((getEnergy()<=10 && enemy.energy>=15) || (getEnergy()<=0.5 && enemy.energy>=9) || (enemy.energy-getEnergy()>=25)) {
                fire(-1); //conserve energy
                System.out.println("I am ill!");
            }
            else {
                System.out.println("Fire power: "+power);
                countbullet++;
                if(countbullet>=bullet || bullet<=3 || enemy.distance<=200) {
                    fire(power);
                    countbullet=0;
                    //bullet=0;
                }
                else
                    System.out.println("Skipped"+bullet+"counted "+countbullet);
            }
        }

	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet? Who the hell!
	 */
	public void onHitByBullet(HitByBulletEvent e) {
        bulletgot++;
        if(bulletgot>=4) {
            confirmedwalls=false;
            bulletgot=0;
        }

	//	turnLeft(90 - e.getBearing());
	}

    /**
     * Opponent too smart eeh!!
     */
    public void onBulletMissed(BulletMissedEvent event) {
        bullet++;
        if(bullet>8) {
            confirmedwalls=false;
            bullet=1;
        }
    }
    /**
     * Opponent too smart eeh!!
     */
    public void onBulletHit(BulletHitEvent event) {
            //removed strategies from here.
            //cant get any good strat. need help!
    }

    public void onHitWall(HitWallEvent e){
        //removed strategies from here.
        //cant get any good strat. need help!
        // doMovement2();
       // double temp =  getTime();
      // if(temp-lasthitwall<10) {
            //got stuck?
          /*  if(getX()<=50 && getY()<=50) {
                turnRight(enemy.bearing()%90);
                ahead(100);
            }
            else if(getX()>=850 && getY()>=850) {
                turnRight(e.getBearing()%45);
                ahead(100);
            }
            else if(getX()<=50 && getY()>=850) {
                turnRight(e.getBearing()%45);
                ahead(100);
            }
            else if(getY()<=50 && getX()>=850)) {
                turnLeft(getHeading()%90+45);
                ahead(direction*100);
            }*/
       // }
        //lasthitwall = temp;
        //direction *= -1;
    }

    /*
     * Is our enemy trying to copy sample.walls
     */
    private boolean isLocWalls(Point2D point) {
        double x= point.getX();
        double y= point.getY();
        System.out.println(x+" "+y+"walls");
        if(x<=25 || x>=975  || y>=975 || y<=25)
           return true;
        else
           return false;
    }

    /*
     * Utility method
     */
    private static Point2D projectPoint(Point2D startPoint, double theta, double dist)
    {
        return new Point2D.Double(startPoint.getX() + dist * Math.sin(theta), startPoint.getY() + dist * Math.cos(theta));
    }

    /*
     * Utility method
     */
    public static double angle(Point2D point2, Point2D point1)
    {
        return Math.atan2(point2.getX()-point1.getX(), point2.getY()-point1.getY());
    }
    /**
     * onWin:  Do a victory dance
     */
    public void onWin(WinEvent e) {
        for (int i = 0; i < 50; i++)
        {
            System.out.println("Fr0z3n Rules ;)");
            turnGunRight(90);
            turnGunLeft(90);
        }
    }

}

/**
 * To keep enemy's information. Could be removed
 */
class MyEnemy {
    String name = null;  //we must know our enemy
    public double distance;
    public double bearing;
    public double head;
    public double energy = Double.MAX_VALUE;

    public double speed;
    public Point2D.Double location = new Point2D.Double(0,0); //enemy's location. to be calculated
}