package kawigi.spare.parts;
import robocode.*;
import kawigi.spare.util.*;

public class EasyTargetChooser extends TargetChooser implements java.io.Serializable
{
	private GunSelector guns;
	public EasyTargetChooser(AdvancedRobot robot, EnemyManager manager)
	{
		super(robot, manager);
	}
	
	public void giveGunSelector(GunSelector guns)
	{
		this.guns = guns;
	}
	
	public void onEvent(Event e)
	{
	}
	
	public EnemyState chooseTarget()
	{	
		EnemyState closest = manager.getClosestEnemy();
		if (closest == null || closest.isDead() || closest.getTimeElapsed(robot.getTime()) > 20)
			return null;
		String easyname = guns.bestGunRating();
		EnemyState easy = manager.getEnemy(easyname);
		if (easy != null)
				return easy;
		else
			return closest;
	}
}
