package kawigi.spare.parts;
import robocode.*;
import kawigi.spare.util.*;

public class KickWhileDownTargetChooser extends TargetChooser implements java.io.Serializable
{
	public KickWhileDownTargetChooser(AdvancedRobot robot, EnemyManager manager)
	{
		super(robot, manager);
	}
	
	public void onEvent(Event e)
	{
	}
	
	public EnemyState chooseTarget()
	{	
		EnemyState closest = manager.getClosestEnemy();
		if (closest == null || closest.isDead() || closest.getTimeElapsed(robot.getTime()) > 20)
			return null;
		for (int i=0; i<manager.countEnemies(); i++)
		{
			EnemyState enemy = manager.getEnemyAt(i);
			if (enemy == null || enemy.isDead() || enemy.getTimeElapsed(robot.getTime()) > 20 || enemy.getTimeElapsed(robot.getTime()) < 0)
				continue;
			if (closest.getTimeElapsed(robot.getTime()) < 0)
				closest = enemy;
			else if (closest.getEnergy() < enemy.getEnergy())
				closest = enemy;
		}
		return closest;
	}
}
