/*
 * Decompiled with CFR 0.152.
 */
package tcf;

import java.util.List;
import java.util.Map;
import robocode.AdvancedRobot;
import tcf.Arena;
import tcf.Bot;
import tcf.CrowdTargettingWave;
import tcf.MovementBase;
import tcf.OppBot;
import tcf.SimBot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OriginalMovement
extends MovementBase {
    AdvancedRobot m_robot;
    Bot m_self;
    List<CrowdTargettingWave> m_waves;
    double m_toX;
    double m_toY;
    int m_updateDestCount = 0;

    OriginalMovement(Arena arena, AdvancedRobot advancedRobot, Bot bot, List<CrowdTargettingWave> list) {
        super(arena);
        this.m_robot = advancedRobot;
        this.m_self = bot;
        this.m_waves = list;
    }

    @Override
    void tick(Map<String, OppBot> map, int n, OppBot oppBot) {
        int n2;
        if (--this.m_updateDestCount > 0) {
            return;
        }
        this.m_updateDestCount = 20;
        this.updateGrid(map, n);
        int n3 = this.calcGridX(this.m_self.x());
        int n4 = this.calcGridY(this.m_self.y());
        int n5 = n3 + n4 * this.m_gridW;
        double d = -9.99999999E8;
        int n6 = n5;
        Object object = new int[25];
        Object object2 = new int[25];
        double[] dArray = new double[25];
        double[] dArray2 = new double[25];
        long l = System.nanoTime();
        for (int i = -8; i <= 8; i += 2) {
            for (int j = -8; j <= 8; j += 2) {
                n2 = Math.abs(i) + Math.abs(j);
                if (n2 != 0 && n2 != 4 && n2 != 8 && n2 != 12) continue;
                int n7 = n3 + i;
                int n8 = n4 + j;
                if (n7 < 0 || n7 >= this.m_gridW || n8 < 0 || n8 >= this.m_gridH) continue;
                int n9 = this.m_gridW - 1 - n7;
                int n10 = this.m_gridH - 1 - n8;
                if (n7 + n8 < 4 || n7 + n10 < 4 || n9 + n8 < 4 || n9 + n10 < 4) continue;
                this.calcGridPath(this.m_self, this.gridToRealX(n7), this.gridToRealY(n8), (int[])object, dArray, dArray2);
                double d2 = 0.0;
                double d3 = 0.001 * (double)this.m_grid[object[24]];
                for (CrowdTargettingWave crowdTargettingWave : this.m_waves) {
                    int n11 = -1;
                    for (int k = 0; k < ((int[])object).length; ++k) {
                        double d4;
                        double d5 = dArray[k] - crowdTargettingWave.gunInitX();
                        double d6 = Math.sqrt(d5 * d5 + (d4 = dArray2[k] - crowdTargettingWave.gunInitY()) * d4) - (crowdTargettingWave.shotDist() + (double)k * crowdTargettingWave.shotSpeed());
                        if (!(d6 <= 0.0)) continue;
                        n11 = k;
                        break;
                    }
                    if (n11 <= 0 || n11 >= 25) continue;
                    d3 -= 10000.0 * crowdTargettingWave.calcHit(dArray[n11], dArray2[n11]);
                }
                if (!(d < (d2 += d3))) continue;
                if (this.m_gridPath == null) {
                    this.m_gridPath = new int[((int[])object).length];
                    this.m_gridPathValue = new int[((int[])object).length];
                }
                Object object3 = this.m_gridPath;
                this.m_gridPath = object;
                object = object3;
                object3 = this.m_gridPathValue;
                this.m_gridPathValue = object2;
                object2 = object3;
                d = d2;
                n6 = n7 + n8 * this.m_gridW;
            }
        }
        long l2 = System.nanoTime();
        System.out.printf("Path selection: %g seconds\n", (double)(l2 - l) * 1.0E-9);
        n2 = n6;
        this.m_toX = this.gridToRealX(n2 % this.m_gridW);
        this.m_toY = this.gridToRealY(n2 / this.m_gridW);
    }

    @Override
    void event(MovementBase.Event event) {
        switch (event) {
            default: 
        }
        this.m_updateDestCount = 0;
    }

    @Override
    void drive() {
        double[] dArray = this.doGoto(this.m_self, this.m_toX, this.m_toY);
        this.m_robot.setTurnRightRadians(dArray[0]);
        this.m_robot.setAhead(dArray[1] == 0.0 ? 0.0 : (dArray[1] < 0.0 ? -100.0 : 100.0));
        this.m_robot.setMaxVelocity(Math.abs(dArray[1]));
    }

    @Override
    double getToX() {
        return this.m_toX;
    }

    @Override
    double getToY() {
        return this.m_toY;
    }

    public void calcGridPath(Bot bot, double d, double d2, int[] nArray, double[] dArray, double[] dArray2) {
        SimBot simBot = new SimBot(bot);
        int n = this.calcGridX(simBot.x());
        int n2 = this.calcGridY(simBot.y());
        nArray[0] = n + n2 * this.m_gridW;
        dArray[0] = simBot.x();
        dArray2[0] = simBot.y();
        for (int i = 1; i < nArray.length; ++i) {
            double[] dArray3 = this.doGoto(simBot, d, d2);
            double d3 = simBot.heading() + dArray3[0];
            simBot.next(d3, dArray3[1]);
            n = this.calcGridX(simBot.x());
            n2 = this.calcGridY(simBot.y());
            nArray[i] = n + n2 * this.m_gridW;
            dArray[i] = simBot.x();
            dArray2[i] = simBot.y();
        }
    }
}

