/*
 * Decompiled with CFR 0.152.
 */
package rampancy.util;

import java.awt.Graphics2D;
import java.util.List;
import rampancy.RampantRobot;
import rampancy.util.RBattlefield;
import rampancy.util.REnemyRobot;
import rampancy.util.RPoint;
import rampancy.util.RRobotState;
import rampancy.util.movement.MovSim;
import rampancy.util.movement.MovSimStat;
import rampancy.util.wave.REnemyWave;
import robocode.AdvancedRobot;
import robocode.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RUtil {
    public static final double WALL_STICK = 150.0;

    public static double computeAbsoluteBearing(RPoint source, RPoint target) {
        return Utils.normalAbsoluteAngle((double)Math.atan2(target.x - source.x, target.y - source.y));
    }

    public static int computeBin(double factor, int numBins) {
        double value = factor * (double)((numBins - 1) / 2) + (double)((numBins - 1) / 2);
        return (int)RUtil.limit(0.0, value, numBins - 1);
    }

    public static double computeBulletPower(double velocity) {
        return Math.max(0.1, (20.0 - velocity) / 3.0);
    }

    public static double computeBulletVelocity(double bulletPower) {
        return 20.0 - 3.0 * bulletPower;
    }

    public static double computeDensity(List<Double> distances, double h) {
        double factor = 1.0 / ((double)distances.size() * h);
        double k_factor = 1.0 / Math.sqrt(Math.PI * 2);
        double sigma = 0.0;
        int i = 0;
        while (i < distances.size()) {
            sigma += Math.exp(-0.5 * Math.pow(distances.get(i) / h, 2.0));
            ++i;
        }
        return sigma * factor * k_factor;
    }

    public static double computeMaxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static double computePreciceMaxEscapeAngle(double bulletVelocity, RampantRobot reference, RPoint origin, int direction) {
        RRobotState state = reference.getCurrentState();
        double maxAngle = 0.0;
        double distance = origin.distance(state.location);
        double maxTicks = distance / bulletVelocity;
        double goAngle = RUtil.computeAbsoluteBearing(origin, state.location);
        goAngle = RUtil.wallSmoothing(state.location, goAngle + 1.5707963267948966 * (double)direction, direction, 1000.0);
        MovSimStat stat = RUtil.predictPosition(state.location, state.heading, goAngle, state.velocity, 8.0, direction);
        int i = 1;
        while ((double)i < maxTicks + 1.0) {
            RPoint newLoc = new RPoint(stat.x, stat.y);
            distance = origin.distance(newLoc);
            goAngle = RUtil.computeAbsoluteBearing(origin, newLoc);
            goAngle = RUtil.wallSmoothing(state.location, goAngle + 1.5707963267948966 * (double)direction, direction, 1000.0);
            stat = RUtil.predictPosition(new RPoint(stat.x, stat.y), stat.h, goAngle, stat.v, 8.0, direction);
            ++i;
        }
        RPoint endPoint = new RPoint(stat.x, stat.y);
        double absBearingToEnd = RUtil.computeAbsoluteBearing(origin, endPoint);
        double escapeAngle = absBearingToEnd - state.absoluteBearing;
        return Math.abs(Utils.normalRelativeAngle((double)escapeAngle));
    }

    public static double computePreciceMaxEscapeAngle(double bulletVelocity, RampantRobot reference, REnemyRobot enemy, int direction) {
        RPoint origin = reference.getCopyOfLocation();
        RRobotState enemyState = enemy.getCurrentState();
        double maxAngle = 0.0;
        double distance = origin.distance(enemyState.location);
        double maxTicks = distance / bulletVelocity;
        double goAngle = RUtil.computeAbsoluteBearing(origin, enemyState.location);
        goAngle = RUtil.wallSmoothing(enemyState.location, goAngle + 1.5707963267948966 * (double)direction, direction, 1000.0);
        MovSimStat stat = RUtil.predictPosition(enemyState.location, enemyState.heading, goAngle, enemyState.velocity, 8.0, direction);
        int i = 1;
        while ((double)i < maxTicks + 1.0) {
            RPoint newLoc = new RPoint(stat.x, stat.y);
            distance = origin.distance(newLoc);
            goAngle = RUtil.computeAbsoluteBearing(origin, newLoc);
            goAngle = RUtil.wallSmoothing(enemyState.location, goAngle + 1.5707963267948966 * (double)direction, direction, 1000.0);
            stat = RUtil.predictPosition(new RPoint(stat.x, stat.y), stat.h, goAngle, stat.v, 8.0, direction);
            ++i;
        }
        RPoint endPoint = new RPoint(stat.x, stat.y);
        double absBearingToEnd = RUtil.computeAbsoluteBearing(origin, endPoint);
        double escapeAngle = absBearingToEnd - enemyState.absoluteBearing;
        return Math.abs(Utils.normalRelativeAngle((double)escapeAngle));
    }

    private static MovSimStat predictPosition(RPoint fromLocation, double currentHeading, double desiredHeading, double currentVelocity, double maxVelocity, double direction) {
        double angleToTurn = desiredHeading - currentHeading;
        int moveDirection = 1;
        if (Math.cos(angleToTurn) < 0.0) {
            angleToTurn += Math.PI;
            moveDirection = -1;
        }
        angleToTurn = Utils.normalRelativeAngle((double)angleToTurn);
        RBattlefield bf = RampantRobot.getGlobalBattlefield();
        MovSimStat[] nextTick = MovSim.futurePos(1, fromLocation.x, fromLocation.y, currentVelocity, maxVelocity, currentHeading, 1000 * moveDirection, angleToTurn, 10.0, bf.width, bf.height);
        return nextTick[0];
    }

    public static double computeOrbitAngle(RPoint location, REnemyWave wave, double attackAngle, int direction) {
        double goAngle = RUtil.computeAbsoluteBearing(wave.getOrigin(), location);
        goAngle = RUtil.wallSmoothing(location, goAngle + (double)direction * (1.5707963267948966 + attackAngle), direction, wave.getOrigin().distance(location));
        return goAngle;
    }

    public static double computeOrbitAngle(RPoint location, REnemyRobot enemy, double attackAngle, int direction) {
        RRobotState state = enemy.getCurrentState();
        double goAngle = RUtil.computeAbsoluteBearing(state.location, location);
        return RUtil.wallSmoothing(state.location, goAngle + (1.5707963267948966 + attackAngle) * (double)direction, direction, state.distance);
    }

    public static void drawOval(RPoint point, int radius, Graphics2D g) {
        g.drawOval((int)point.x - radius, (int)point.y - radius, radius * 2, radius * 2);
    }

    public static void fillOval(RPoint point, int radius, Graphics2D g) {
        g.fillOval((int)point.x - radius, (int)point.y - radius, radius * 2, radius * 2);
    }

    public static double getDistanceFromWall(RPoint point) {
        RBattlefield bf = RampantRobot.getGlobalBattlefield();
        if (bf == null) {
            return -1.0;
        }
        return bf.distanceFromWall(point);
    }

    public static int getFactorIndex(REnemyWave wave, RPoint target, int numBins) {
        double offsetAngle = wave.computeOffsetAngle(target);
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / RUtil.computeMaxEscapeAngle(wave.getVelocity()) * (double)wave.getDirection();
        return RUtil.computeBin(factor, numBins);
    }

    public static double getGuessFactorForIndex(int index, int arraySize) {
        int offset = index - (arraySize - 1) / 2;
        return (double)offset / (double)((arraySize - 1) / 2);
    }

    public static int indexOfLargest(double[] arr) {
        double largest = 0.0;
        int largestIndex = (arr.length - 1) / 2;
        int i = 0;
        while (i < arr.length) {
            if (arr[i] > largest) {
                largest = arr[i];
                largestIndex = i;
            }
            ++i;
        }
        return largestIndex;
    }

    public static int indexOfSmallest(double[] arr) {
        double lowest = 50000.0;
        int lowestIndex = -1;
        int i = 0;
        while (i < arr.length) {
            if (arr[i] < lowest) {
                lowest = arr[i];
                lowestIndex = i;
            }
            ++i;
        }
        return lowestIndex;
    }

    public static boolean inRange(double min, double max, double value) {
        return value >= min && value <= max;
    }

    public static boolean isAdvancing(double absoluteBearing, double enemyHeading, double deltaHeading, double velocity) {
        if (RUtil.inRange(-0.07853981633974483, 0.07853981633974483, Math.abs(enemyHeading - absoluteBearing) - Math.PI)) {
            return Math.abs(deltaHeading) < 0.01 && velocity > 1.0;
        }
        return false;
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double lowest(double[] values) {
        double lowest = values[0];
        int i = 1;
        while (i < values.length) {
            if (lowest > values[i]) {
                lowest = values[i];
            }
            ++i;
        }
        return lowest;
    }

    public static int sign(double d) {
        return d < 0.0 ? -1 : (d > 0.0 ? 1 : 0);
    }

    public static int nonZeroSign(double d) {
        if (d < 0.0) {
            return -1;
        }
        return 1;
    }

    public static RPoint project(RPoint source, double angle, double length) {
        double x = source.x + Math.sin(angle) * length;
        double y = source.y + Math.cos(angle) * length;
        return new RPoint(x, y);
    }

    public static double rollingAvg(double value, double newEntry, double n, double weighting) {
        return (value * n + newEntry * weighting) / (n + weighting);
    }

    public static double roundToPrecision(double value, int precision) {
        int temp = (int)Math.round(value * Math.max(1.0, Math.pow(10.0, precision)));
        return (double)temp / Math.pow(10.0, precision);
    }

    public static double scaleToRange(double min, double max, double minExpected, double maxExpected, double value) {
        return RUtil.scaleToRange(min, max, minExpected, maxExpected, value, 0.0);
    }

    public static double scaleToRange(double min, double max, double minExpected, double maxExpected, double value, double offset) {
        double scaleRange = max - min;
        double valueRange = maxExpected - minExpected;
        double percentDiff = scaleRange / valueRange;
        return RUtil.limit(min, (value + offset) * percentDiff, max);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle, double dist) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(dist);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(dist);
        }
    }

    public static double square(double value) {
        return Math.pow(value, 2.0);
    }

    public static double[] sum(double[] arr1, double[] arr2) {
        double[] sum = new double[arr1.length];
        if (arr1.length != arr2.length) {
            System.err.print("Sum error: arrays not the same length!");
            return null;
        }
        int i = 0;
        while (i < arr1.length) {
            sum[i] = arr1[i] + arr2[1];
            ++i;
        }
        return sum;
    }

    public static double wallSmoothing(RPoint location, double goAngle, int direction, double distanceToCenterOfOrbit) {
        double newAngle;
        double wallStick;
        RPoint projectedLocation;
        RBattlefield bf = RampantRobot.getGlobalBattlefield();
        if (bf.contains(projectedLocation = RUtil.project(location, goAngle, wallStick = Math.min(distanceToCenterOfOrbit, 150.0)))) {
            return goAngle;
        }
        double topDist = bf.innerDistanceFromTop(location);
        double rightDist = bf.innerDistanceFromRight(location);
        double leftDist = bf.innerDistanceFromLeft(location);
        double botDist = bf.innerDistanceFromBot(location);
        boolean top = topDist <= wallStick;
        boolean bot = botDist <= wallStick;
        boolean right = rightDist <= wallStick;
        boolean left = leftDist <= wallStick;
        boolean clockwise = direction > 0;
        boolean smoothTop = top && (!right && !left || right && !clockwise || left && clockwise);
        boolean smoothBot = bot && (!right && !left || left && !clockwise || right && clockwise);
        boolean smoothRight = right && (!top && !bot || bot && !clockwise || top && clockwise);
        boolean smoothLeft = left && (!top && !bot || top && !clockwise || bot && clockwise);
        double tolerance = 2.0;
        if (smoothTop) {
            newAngle = (topDist < tolerance ? 1.5707963267948966 : Math.acos(topDist / wallStick)) * (double)direction;
        } else if (smoothBot) {
            newAngle = (botDist < tolerance ? 1.5707963267948966 : Math.acos(botDist / wallStick)) * (double)direction + Math.PI;
        } else if (smoothRight) {
            newAngle = (rightDist < tolerance ? 1.5707963267948966 : Math.acos(rightDist / wallStick)) * (double)direction + 1.5707963267948966;
        } else if (smoothLeft) {
            newAngle = (leftDist < tolerance ? 1.5707963267948966 : Math.acos(leftDist / wallStick)) * (double)direction + 4.71238898038469;
        } else {
            System.err.println("Smoothing Error!");
            return 0.0;
        }
        return newAngle;
    }

    public static double percentDifference(double v1, double v2) {
        double sum = (v1 + v2) / 2.0;
        if (sum == 0.0) {
            return 1.0;
        }
        return Math.abs((v1 - v2) / sum);
    }

    public static boolean pointOnRobotPoint(RPoint point, RPoint robotLocation) {
        int radius = 18;
        return point.x >= robotLocation.x - (double)radius && point.x <= robotLocation.x + (double)radius && point.y >= robotLocation.y - (double)radius && point.y <= robotLocation.y + (double)radius;
    }

    public static boolean pointOnRobot(RPoint point, REnemyRobot enemy) {
        RPoint enemyLocation = enemy.getCurrentState().location;
        int radius = 18;
        return point.x >= enemyLocation.x - (double)radius && point.x <= enemyLocation.x + (double)radius && point.y >= enemyLocation.y - (double)radius && point.y <= enemyLocation.y + (double)radius;
    }
}

