/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics;

import pedersen.core.Constraints;
import pedersen.debug.Debug;
import pedersen.debug.Debuggable;
import pedersen.physics.StaticHeading;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;
import pedersen.physics.StaticVectorImpl;

public class SlopeFormula
implements Debuggable {
    private final double slope;
    private final double offset;

    public SlopeFormula(StaticPosition position, StaticHeading heading) {
        StaticPositionImpl position2 = new StaticPositionImpl(position, new StaticVectorImpl(heading.getHeading(), 1.0));
        if (!Constraints.isApproximatelyZero(1.0 - position.getDistance(position2))) {
            Debug.debug("Distance of projected position for determining slope: " + Debug.trim(position.getDistance(position2)));
        }
        double deltaX = position2.getX() - position.getX();
        double deltaY = position2.getY() - position.getY();
        this.slope = deltaY / deltaX;
        this.offset = position.getY() - this.slope * position.getX();
    }

    public double getFunctionOfX(double x) {
        return this.slope * x + this.offset;
    }

    public StaticPosition getPositionForX(double x) {
        return new StaticPositionImpl(x, this.getFunctionOfX(x));
    }

    public double getFunctionOfY(double y) {
        return (y - this.offset) / this.slope;
    }

    public StaticPosition getPositionForY(double y) {
        return new StaticPositionImpl(this.getFunctionOfY(y), y);
    }

    public void debug() {
        Debug.debug("y = " + Debug.trim(this.slope) + "x + " + Debug.trim(this.offset));
    }
}

