/*
 * Decompiled with CFR 0.152.
 */
package rz;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import rz.stuff.Wave;

public class Apollon
extends AdvancedRobot {
    private static final Rectangle2D.Double FIELD = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
    private static final double STICK_LENGTH = 160.0;
    private static Point2D referencePoint;
    private static double bestBearing;
    private static double moveAngle;
    private static double moveDir;
    private static int circleDir;
    private static final int GF_ZERO = 15;
    private static final int GF_ONE = 30;
    private static int[][][] hitFactors;
    private static Wave closestEWave;
    private static ArrayList eWaves;
    private static final int BACK = 30;
    private static final double DIVFAC = 80.0;
    private static final double VELFAC = 3.0;
    private static final double DISFAC = 125.0;
    private static int[][][][][] aimFactors;
    private static Wave closestMWave;
    private static ArrayList myWaves;
    private static Point2D myPosition;
    private static double myVelocity;
    private static double myHeading;
    private static long time;
    private static Point2D targetPosition;
    private static double targetEnergy;
    private static double targetVelocity;
    private static double energyControl;

    public void run() {
        this.setColors(Color.yellow, Color.red, Color.white);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        eWaves = new ArrayList();
        myWaves = new ArrayList();
        while (true) {
            this.turnRadarRightRadians(1.0);
        }
    }

    private static final double predict(Wave nearWave, int dir) {
        Point2D predicted = myPosition;
        double velocity = myVelocity;
        double heading = myHeading;
        long t = time;
        while (Apollon.setMovementGlobals(predicted, heading, dir) && nearWave.timeToImpact(predicted = Apollon.calcPoint(predicted, heading += Apollon.limit(moveAngle, 0.174532925199 - 0.01308996939 * Math.abs(velocity)), velocity = Apollon.limit(velocity + (velocity * moveDir < 0.0 ? (double)2 * moveDir : moveDir), 8.0)), ++t) < 0.0) {
        }
        return Apollon.calcAngle(predicted, nearWave.gunLocation);
    }

    private static final boolean setMovementGlobals(Point2D pos, double heading, int dir) {
        double offset = 1.5707963267948966 + Apollon.limit((600.0 - pos.distance(referencePoint)) / 400.0, 0.8);
        double angle = Apollon.calcAngle(referencePoint, pos);
        while (!FIELD.contains(Apollon.calcPoint(pos, angle + (double)dir * (offset -= 0.02), 160.0))) {
        }
        moveAngle = angle + (double)dir * offset - heading;
        moveDir = Apollon.sign(Math.cos(moveAngle));
        moveAngle += 1.5707963267948966 * (moveDir - 1.0);
        moveAngle = Utils.normalRelativeAngle((double)moveAngle);
        boolean bl = false;
        if (offset > 0.7) {
            bl = true;
        }
        return bl;
    }

    private static final void setBestBearing(Wave w) {
        double minAngle = Apollon.predict(w, 1);
        double maxAngle = Apollon.predict(w, -1);
        double diff = (double)Apollon.sign(Utils.normalRelativeAngle((double)(maxAngle - minAngle))) * 0.01;
        double bestValue = Double.POSITIVE_INFINITY;
        do {
            double dummy = 0.0;
            int b = -20;
            do {
                dummy += w.getValue(minAngle + (double)b / myPosition.distance(w.gunLocation), 0);
            } while ((b += 5) <= 20);
            if (!(dummy < bestValue) && (dummy != bestValue || !(Apollon.angleDistance(w.absBearing, minAngle) > Apollon.angleDistance(w.absBearing, bestBearing)))) continue;
            bestValue = dummy;
            bestBearing = minAngle;
        } while (Apollon.angleDistance(minAngle += diff, maxAngle) > 0.02);
    }

    private static final double angleDistance(double a, double b) {
        return Math.abs(Utils.normalRelativeAngle((double)(a - b)));
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double absBearing;
        double d;
        time = this.getTime();
        double dist = e.getDistance();
        double d2 = targetEnergy;
        targetEnergy = e.getEnergy();
        double bulletPower = d2 - targetEnergy;
        if (0.0 < d && bulletPower <= (double)3) {
            absBearing = Apollon.calcAngle(myPosition, targetPosition);
            eWaves.add(new Wave(targetPosition, absBearing, bulletPower, Apollon.getBearingDirection(myVelocity, myHeading - absBearing, bulletPower), time - (long)2, hitFactors[(int)(Math.abs(myVelocity) / (double)3)][(int)(dist / 200.0)]));
        }
        myVelocity = this.getVelocity();
        Point2D myPos = myPosition = Apollon.newPoint(this.getX(), this.getY());
        myHeading = this.getHeadingRadians();
        absBearing = myHeading + e.getBearingRadians();
        targetPosition = Apollon.calcPoint(myPosition, absBearing, dist);
        double vel = e.getVelocity();
        double d3 = e.getHeadingRadians() - absBearing;
        int n = 0;
        if (dist < 250.0) {
            n = 1;
        }
        energyControl = Math.min(targetEnergy, this.getEnergy());
        bulletPower = Math.min((double)(n + 2), energyControl / (double)4);
        double bearingDirection = Apollon.getBearingDirection(vel, d3, bulletPower);
        double d4 = targetVelocity;
        targetVelocity = Math.abs(vel);
        int[] currentFactors = aimFactors[Apollon.sign(d4 - targetVelocity) + 1][(int)(targetVelocity / (double)3)][1 - FIELD.contains(Apollon.calcPoint(targetPosition, e.getHeadingRadians(), 200 * Apollon.sign(vel)))][(int)(dist / 125.0)];
        if (bulletPower >= (double)2) {
            myWaves.add(new Wave(myPos, absBearing, bulletPower, bearingDirection, time, currentFactors));
        }
        if (this.getGunTurnRemaining() == 0.0 && this.getEnergy() > 1.0) {
            this.setFire(bulletPower);
        }
        int bestGF = 15;
        int i = 30;
        while (i >= 0 && targetEnergy > 0.0) {
            if (currentFactors[i] > currentFactors[bestGF]) {
                bestGF = i;
            }
            --i;
        }
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getGunHeadingRadians() + bearingDirection * (double)(bestGF - 15))));
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getRadarHeadingRadians())) * (double)2);
        Wave eW = Apollon.getClosestWave(eWaves, myPos, false);
        Wave mW = Apollon.getClosestWave(myWaves, targetPosition, false);
        try {
            if (mW != closestMWave) {
                closestMWave = mW;
                closestMWave.getValue(Apollon.calcAngle(targetPosition, mW.gunLocation), 1);
            }
            if (eW != closestEWave) {
                referencePoint = targetPosition;
                closestEWave = eW;
                Apollon.setBestBearing(closestEWave);
            }
            if (dist > 80.0) {
                circleDir = Apollon.sign(Utils.normalRelativeAngle((double)(Apollon.calcAngle(myPos, eW.gunLocation) - bestBearing)));
            }
            Apollon.setMovementGlobals(myPos, myHeading, circleDir);
            this.setAhead(100.0 * moveDir);
            this.setTurnRightRadians(moveAngle);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private static final Wave getClosestWave(ArrayList waves, Point2D target, boolean checkPassedWaves) {
        Wave closestWave = null;
        double closestDist = 10000.0;
        Iterator iterator = waves.iterator();
        while (iterator.hasNext()) {
            Wave wave = (Wave)iterator.next();
            double dist = wave.timeToImpact(target, time);
            if (dist >= (double)4) {
                iterator.remove();
            }
            if (!checkPassedWaves && !(dist < 0.0) || !(Math.abs(dist) < Math.abs(closestDist))) continue;
            closestDist = dist;
            closestWave = wave;
        }
        return closestWave;
    }

    private static final double getBearingDirection(double velocity, double angle, double bulletPower) {
        return (double)Apollon.sign(velocity * Math.sin(angle) + 0.01) * Math.asin(8.0 / (20.0 - (double)3 * bulletPower)) / 15.0;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        targetEnergy += e.getPower() * (double)3;
        try {
            if (energyControl > (double)5) {
                Apollon.getClosestWave(eWaves, myPosition, true).getValue(e.getHeadingRadians(), 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        double power = e.getBullet().getPower();
        targetEnergy -= power + Math.max((double)2 * (power - 1.0), 0.0);
    }

    private static final int sign(double value) {
        return value < 0.0 ? -1 : 1;
    }

    private static final Point2D newPoint(double x, double y) {
        return new Point2D.Double(x, y);
    }

    private static final double limit(double value, double limit) {
        return Math.max(-limit, Math.min(value, limit));
    }

    private static final Point2D calcPoint(Point2D p, double ang, double dist) {
        return Apollon.newPoint(p.getX() + dist * Math.sin(ang), p.getY() + dist * Math.cos(ang));
    }

    private static final double calcAngle(Point2D p2, Point2D p1) {
        return Math.atan2(p2.getX() - p1.getX(), p2.getY() - p1.getY());
    }

    static {
        hitFactors = new int[3][5][32];
        aimFactors = new int[3][4][2][9][32];
    }
}

