/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.stat;

import dmonner.xlbp.stat.AbstractStat;
import dmonner.xlbp.stat.Stat;
import dmonner.xlbp.util.CSVWriter;
import java.io.IOException;
import java.util.Map;

public class FractionStat
extends AbstractStat {
    private final String name;
    private int actual;
    private int possible;
    private float fraction;

    public FractionStat(FractionStat that) {
        this.name = that.name;
        this.actual = that.actual;
        this.possible = that.possible;
        this.fraction = that.fraction;
    }

    public FractionStat(String name) {
        this.name = name;
    }

    public void add(FractionStat that) {
        this.actual += that.actual;
        this.possible += that.possible;
    }

    public void add(int actual, int possible) {
        this.actual += actual;
        this.possible += possible;
    }

    @Override
    public void add(Stat that) {
        if (!(that instanceof FractionStat)) {
            throw new IllegalArgumentException("Can only add in other FractionStats.");
        }
        this.add((FractionStat)that);
    }

    @Override
    public void addTo(String prefix, Map<String, Object> map) {
        map.put(prefix + this.name + "Fraction", Float.valueOf(this.fraction));
        map.put(prefix + this.name + "Actual", this.actual);
        map.put(prefix + this.name + "Possible", this.possible);
    }

    @Override
    public void analyze() {
        this.fraction = (float)this.actual / (float)this.possible;
    }

    @Override
    public void clear() {
        this.actual = 0;
        this.possible = 0;
        this.fraction = 0.0f;
    }

    public int getActual() {
        return this.actual;
    }

    public float getFraction() {
        return this.fraction;
    }

    public int getPossible() {
        return this.possible;
    }

    @Override
    public void saveData(CSVWriter out) throws IOException {
        out.appendField(this.fraction);
        out.appendField(this.actual);
        out.appendField(this.possible);
    }

    @Override
    public void saveHeader(String prefix, CSVWriter out) throws IOException {
        out.appendHeader(prefix + this.name + "Fraction");
        out.appendHeader(prefix + this.name + "Actual");
        out.appendHeader(prefix + this.name + "Possible");
    }

    @Override
    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        String prename = prefix + this.name;
        sb.append(prename);
        sb.append("Fraction = ");
        sb.append(this.fraction);
        sb.append("\n");
        sb.append(prename);
        sb.append("Actual = ");
        sb.append(this.actual);
        sb.append("\n");
        sb.append(prename);
        sb.append("Possible = ");
        sb.append(this.possible);
        sb.append("\n");
        return sb.toString();
    }
}

