/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;

public class ReflectionTools {
    public static Class<?> box(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        return clazz;
    }

    public static Class<?> findClass(String classname, String[] packages) {
        try {
            return Class.forName(classname);
        }
        catch (ClassNotFoundException ex) {
            for (String pkg : packages) {
                try {
                    return Class.forName(pkg + "." + classname);
                }
                catch (ClassNotFoundException ex2) {
                }
            }
            throw new IllegalArgumentException("Class name not found: " + classname);
        }
    }

    public static Constructor<?> findConstructor(Class<?> clazz, Class<?>[] signature) {
        for (Constructor<?> c : clazz.getConstructors()) {
            Class<?>[] csign = c.getParameterTypes();
            if (csign.length != signature.length) continue;
            boolean found = true;
            for (int i = 0; i < csign.length; ++i) {
                if (csign[i].isAssignableFrom(signature[i])) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return c;
        }
        throw new IllegalArgumentException("Cannot find constructor for " + clazz.getCanonicalName() + " matching args " + Arrays.deepToString(signature));
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?>[] signature) {
        for (Method m : clazz.getMethods()) {
            Class<?>[] msign = m.getParameterTypes();
            if (!m.getName().equals(name) || msign.length != signature.length) continue;
            boolean found = true;
            for (int i = 0; i < msign.length; ++i) {
                if (msign[i].isAssignableFrom(signature[i])) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return m;
        }
        throw new IllegalArgumentException("Cannot find method " + name + " for " + clazz.getCanonicalName() + " matching args " + Arrays.deepToString(signature));
    }

    public static Class<?> unbox(Class<?> clazz) {
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        return clazz;
    }
}

