/*
 * Decompiled with CFR 0.152.
 */
package justin;

import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class RandomMoveD {
    static final double MAX_VELOCITY = 8.0;
    static final double WALL_MARGIN = 25.0;
    AdvancedRobot bot;
    Point2D robotLocation;
    Point2D enemyLocation;
    double enemyDistance;
    double enemyAbsoluteBearing;
    double movementLateralAngle = 0.2;

    public RandomMoveD(AdvancedRobot bot) {
        this.bot = bot;
    }

    public void initRound() {
        this.enemyLocation = null;
    }

    public void cleanUpRound() {
        this.enemyLocation = null;
    }

    public void update(ScannedRobotEvent e) {
        this.robotLocation = new Point2D.Double(this.bot.getX(), this.bot.getY());
        this.enemyAbsoluteBearing = this.bot.getHeadingRadians() + e.getBearingRadians();
        this.enemyDistance = e.getDistance();
        this.enemyLocation = RandomMoveD.vectorToLocation(this.enemyAbsoluteBearing, this.enemyDistance, this.robotLocation);
    }

    public void execute() {
        this.considerChangingDirection();
        Point2D robotDestination = null;
        double tries = 0.0;
        do {
            robotDestination = RandomMoveD.vectorToLocation(RandomMoveD.absoluteBearing(this.enemyLocation, this.robotLocation) + this.movementLateralAngle, this.enemyDistance * (1.1 - tries / 100.0), this.enemyLocation);
        } while ((tries += 1.0) < 100.0 && !this.fieldRectangle(25.0).contains(robotDestination));
        this.goTo(robotDestination);
    }

    void considerChangingDirection() {
        double flattenerFactor = 0.05;
        if (Math.random() < flattenerFactor) {
            this.movementLateralAngle *= -1.0;
        }
    }

    RoundRectangle2D fieldRectangle(double margin) {
        return new RoundRectangle2D.Double(margin, margin, this.bot.getBattleFieldWidth() - margin * 2.0, this.bot.getBattleFieldHeight() - margin * 2.0, 75.0, 75.0);
    }

    void goTo(Point2D destination) {
        double angle = Utils.normalRelativeAngle((double)(RandomMoveD.absoluteBearing(this.robotLocation, destination) - this.bot.getHeadingRadians()));
        double turnAngle = Math.atan(Math.tan(angle));
        this.bot.setTurnRightRadians(turnAngle);
        this.bot.setAhead(this.robotLocation.distance(destination) * (double)(angle == turnAngle ? 1 : -1));
        this.bot.setMaxVelocity(Math.abs(this.bot.getTurnRemaining()) > 33.0 ? 0.0 : 8.0);
    }

    static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation) {
        return RandomMoveD.vectorToLocation(angle, length, sourceLocation, new Point2D.Double());
    }

    static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation, Point2D targetLocation) {
        targetLocation.setLocation(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
        return targetLocation;
    }

    static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }
}

