/*
 * Decompiled with CFR 0.152.
 */
package pedersen.debug;

import pedersen.debug.DebuggableBase;
import pedersen.debug.Stopwatch;

public class Stopwatches
extends DebuggableBase {
    public static final Stopwatch combatantOperate = new Stopwatch();
    public static final Stopwatch combatantOperateGun = new Stopwatch();
    public static final Stopwatch combatantOperateChassis = new Stopwatch();
    public static final Stopwatch combatantOperateTurret = new Stopwatch();
    public static final Stopwatch combatantOperateScanner = new Stopwatch();
    public static final Stopwatch[] targetingMethodGetFiringSolution = Stopwatches.initStopwatchArray(20);
    public static final Stopwatch[] movementMethodGetRelativePositionTarget = Stopwatches.initStopwatchArray(40);
    private static final long nano = 1000000000L;
    public static final Stopwatches singleton = new Stopwatches();

    private static Stopwatch[] initStopwatchArray(int count) {
        Stopwatch[] temp = new Stopwatch[count];
        int i = 0;
        while (i < count) {
            temp[i] = new Stopwatch();
            ++i;
        }
        return temp;
    }

    @Override
    public String description() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getSimpleName());
        buffer.append("\n").append("Stopwatch combatantOperate:        " + Stopwatches.formatElapsedTime(combatantOperate.getElapsedTime()));
        buffer.append("\n").append("Stopwatch combatantOperateGun:     " + Stopwatches.formatElapsedTime(combatantOperateGun.getElapsedTime()));
        buffer.append("\n").append("Stopwatch combatantOperateChassis: " + Stopwatches.formatElapsedTime(combatantOperateChassis.getElapsedTime()));
        buffer.append("\n").append("Stopwatch combatantOperateTurret:  " + Stopwatches.formatElapsedTime(combatantOperateTurret.getElapsedTime()));
        buffer.append("\n").append("Stopwatch combatantOperateScanner: " + Stopwatches.formatElapsedTime(combatantOperateScanner.getElapsedTime()));
        return buffer.toString();
    }

    protected static String formatElapsedTime(long nanoSeconds) {
        String fraction = "00000000" + nanoSeconds % 1000000000L;
        return String.valueOf(nanoSeconds / 1000000000L) + "." + fraction.substring(fraction.length() - 9) + " seconds";
    }
}

