/*
 * Decompiled with CFR 0.152.
 */
package pedersen.divination.segmentation;

import pedersen.divination.CombatWave;
import pedersen.divination.TargetAnalysis;
import pedersen.divination.segmentation.Segment;
import pedersen.util.BaseConversions;
import pedersen.util.Constraints;
import pedersen.util.UnsupportedEnumException;

public enum ScalableSegment implements Segment
{
    LATERAL_VELOCITY,
    CLOSING_VELOCITY,
    VELOCITY,
    BULLET_POWER,
    BULLET_FLIGHT_TIME;


    @Override
    public int getIndex(CombatWave wave, TargetAnalysis targetAnalysis, int slices) {
        switch (this) {
            case LATERAL_VELOCITY: {
                return this.getIndexForScalar(targetAnalysis.originalLateralVelocity, slices);
            }
            case CLOSING_VELOCITY: {
                return this.getIndexForScalar(targetAnalysis.originalClosingVelocity, slices);
            }
            case VELOCITY: {
                return this.getIndexForScalar(targetAnalysis.originalVelocity, slices);
            }
            case BULLET_POWER: {
                return Constraints.limitValue(0, (int)(BaseConversions.getFirepowerFromBulletVelocity(wave.getVelocity().velocity()) / 0.6), slices - 1);
            }
            case BULLET_FLIGHT_TIME: {
                return Constraints.limitValue(0, targetAnalysis.originalBulletFlightTime / 3, slices - 1);
            }
        }
        throw new UnsupportedEnumException(this);
    }

    @Override
    public void debug(CombatWave wave, TargetAnalysis targetAnalysis) {
        switch (this) {
            case LATERAL_VELOCITY: {
                System.out.println(targetAnalysis.originalLateralVelocity);
                return;
            }
            case CLOSING_VELOCITY: {
                System.out.println(targetAnalysis.originalClosingVelocity);
                return;
            }
            case VELOCITY: {
                System.out.println(targetAnalysis.originalVelocity);
                return;
            }
            case BULLET_POWER: {
                System.out.println(BaseConversions.getFirepowerFromBulletVelocity(wave.getVelocity().velocity()));
                return;
            }
            case BULLET_FLIGHT_TIME: {
                System.out.println(targetAnalysis.originalBulletFlightTime);
                return;
            }
        }
        throw new UnsupportedEnumException(this);
    }

    private int getIndexForScalar(double value, int slices) {
        int index = slices >>= 1;
        if (value == 0.0) {
            index += 0;
        } else if (value > 0.0) {
            index += (int)Math.ceil(value * (double)slices);
        } else if (value < 0.0) {
            index += (int)Math.floor(value * (double)slices);
        }
        return index;
    }
}

