/*
 * Decompiled with CFR 0.152.
 */
package pedersen.movement.absolute;

import pedersen.movement.MovementMethod;
import pedersen.movement.absolute.MovementMethodAbsoluteBase;
import pedersen.physics.Direction;
import pedersen.physics.HasDirection;
import pedersen.physics.HasPosition;
import pedersen.physics.Position;
import pedersen.physics.Snapshot;
import pedersen.physics.Vehicle;
import pedersen.physics.constant.VehicleImpl;
import pedersen.util.Arena;

public class MovementMethodShoveImpl
extends MovementMethodAbsoluteBase
implements MovementMethod {
    private static final MovementMethod singleton = new MovementMethodShoveImpl();

    private MovementMethodShoveImpl() {
    }

    @Override
    public Vehicle getDestination() {
        VehicleImpl destination = null;
        Position center = Arena.getCenter();
        Snapshot snapshot = super.getTargetSnapshot();
        if (snapshot != null) {
            Direction centerBearingToTarget = center.getBearing(snapshot);
            double centerDistanceToTarget = center.getDistance(snapshot).distance() - 60.0;
            Position centerProjectionToTarget = center.addVector((HasDirection)centerBearingToTarget, centerDistanceToTarget);
            destination = new VehicleImpl((HasPosition)centerProjectionToTarget.getPosition(), (HasDirection)snapshot.getDirection(), snapshot.getVelocity());
        } else {
            destination = new VehicleImpl((HasPosition)center, 0.0, 0.0);
        }
        return destination;
    }

    public static MovementMethod getInstance() {
        return singleton;
    }
}

