/*
 * Decompiled with CFR 0.152.
 */
package ags.rougedc.movement;

import ags.muse.base.Rules;
import ags.muse.base.actors.MovementActor;
import ags.muse.recon.EnemyList;
import ags.muse.recon.SelfStatus;
import ags.rougedc.movement.DistanceDriver;
import ags.rougedc.movement.OrbitDriver;
import ags.rougedc.movement.RobotDriver;
import ags.rougedc.movement.StoppedDriver;
import ags.rougedc.movement.SurfingPredictor;
import ags.rougedc.robots.StatusRobot;
import ags.rougedc.waves.EnemyWave;
import ags.rougedc.waves.EnemyWaveManager;
import ags.util.points.AbsolutePoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Surfing {
    private final Rules rules;
    private final StatusRobot status;
    private final SelfStatus status2;
    private final EnemyWaveManager ewm;
    private final List<RobotDriver> drivers;
    private final RobotDriver defaultdriver;
    public Map<RobotDriver, Double> options;

    public Surfing(Rules rules, StatusRobot status, SelfStatus status2, EnemyList enemies, EnemyWaveManager ewm) {
        this.rules = rules;
        this.status = status;
        this.status2 = status2;
        this.ewm = ewm;
        this.options = new HashMap<RobotDriver, Double>();
        this.drivers = new ArrayList<RobotDriver>();
        this.drivers.add(new StoppedDriver());
        this.drivers.add(new OrbitDriver(rules, 400.0, 1.5707963267948966));
        this.drivers.add(new OrbitDriver(rules, 400.0, -1.5707963267948966));
        this.defaultdriver = new DistanceDriver(rules, enemies, 400.0);
    }

    public void run(MovementActor movementActor) {
        ArrayList<EnemyWave> allwaves = new ArrayList<EnemyWave>(this.ewm.getAll());
        allwaves.addAll(this.ewm.getAllHeat());
        ArrayList<EnemyWave> waves = new ArrayList<EnemyWave>();
        int count = 0;
        for (EnemyWave w : allwaves) {
            if (++count > 4) break;
            waves.add(w);
        }
        ArrayList<RobotDriver> selecteddrivers = new ArrayList<RobotDriver>(this.drivers);
        RobotDriver bestdriver = this.defaultdriver;
        double lowestDanger = Double.POSITIVE_INFINITY;
        this.options.clear();
        if (waves.size() > 0) {
            AbsolutePoint fieldcorner = AbsolutePoint.fromXY(this.rules.BATTLEFIELD_WIDTH, this.rules.BATTLEFIELD_HEIGHT);
            for (RobotDriver driver : selecteddrivers) {
                SurfingPredictor predictor = new SurfingPredictor(this.status, driver, this.drivers, waves, null, null, fieldcorner, 0L);
                double danger = predictor.getDanger(lowestDanger);
                driver.run(this.status, waves);
                this.options.put(driver, danger);
                if (!(danger < lowestDanger)) continue;
                bestdriver = driver;
                lowestDanger = danger;
            }
        } else {
            this.options.put(this.defaultdriver, 0.0);
        }
        bestdriver.run(this.status, waves);
        double v = bestdriver.getAcceleration() + this.status.getVelocity().magnitude;
        double av = bestdriver.getAngularVelocity();
        movementActor.setMove(v);
        movementActor.setTurnBody(av);
        this.status2.setIntention(this.rules, v, av);
        this.status.setMove(v);
        this.status.setTurnBody(av);
    }
}

