/*
 * Decompiled with CFR 0.152.
 */
package bjl.fire;

import bjl.BattleField;
import bjl.Blip;
import bjl.Enemy;
import bjl.EnemyList;
import bjl.FireDemand;
import bjl.PatternBlip;
import bjl.Point;
import bjl.SuperBlip;
import bjl.Utils;
import bjl.fire.FireSituation;
import bjl.fire.FireStrategy;
import java.util.Vector;

public class SituationMatch
extends FireStrategy {
    private Vector[] situ = new Vector[36];

    public String toString() {
        return "SituationMatch";
    }

    public void reInit() {
        super.reInit();
    }

    public void doFire(double power) {
        super.doFire(power);
        SuperBlip me = BattleField.getMe();
        Blip him = this.enemy.getLastBlip();
        double angle = Utils.normalHeading(him.head - him.pos.angleTo(me.pos));
        int i = (int)(angle / 10.0);
        angle = Utils.normalRelativeAngle(angle);
        FireSituation s = new FireSituation(him.pos.dist(me.pos), him.vel, angle, power, me.time, me.roundnum);
        this.situ[i].add(s);
        if (i == 0) {
            this.situ[35].add(s);
        } else {
            this.situ[i - 1].add(s);
        }
        this.situ[(i + 1) % 36].add(s);
    }

    public Point getPosition(long time) {
        double pow = 0.0;
        SuperBlip me = BattleField.getMe();
        Blip him = this.enemy.getLastBlip();
        Blip b = new Blip(him);
        Point pos = BattleField.getPos();
        Point them = new Point(b.pos);
        long now = b.time;
        return them;
    }

    protected FireDemand getFireDemand() {
        if (EnemyList.getNumOpponents() != 1) {
            return new FireDemand(0.0, -1.0, 0.0, 0.0, this);
        }
        double pow = 0.0;
        SuperBlip me = BattleField.getMe();
        Blip him = this.enemy.getLastBlip();
        Blip b = new Blip(him);
        Point pos = BattleField.getPos();
        Point them = new Point(b.pos);
        long now = b.time;
        double angle = Utils.normalHeading(him.head - him.pos.angleTo(me.pos));
        int i = (int)(angle / 10.0);
        double dist = me.pos.dist(him.pos);
        angle = Utils.normalRelativeAngle(angle);
        double vel = him.vel;
        double sqrt = 1.0 / Math.sqrt(me.roundnum + 1);
        FireSituation best = null;
        double value = 0.4;
        int j = this.situ[i].size() - 1;
        while (j >= 0) {
            double tValue;
            FireSituation s = (FireSituation)this.situ[i].elementAt(j);
            if ((s.roundNum != me.roundnum || s.time <= me.time - 40L) && (tValue = Math.abs(s.dist - dist) / 30.0 + Math.abs(s.vel - vel) / 0.7 + Math.abs(s.angle - angle) / 10.0) < value) {
                best = s;
                value = tValue;
            }
            --j;
        }
        if (best == null) {
            return new FireDemand(0.0, -1.0, 0.0, 0.0, this);
        }
        double power = best.power;
        long then = best.time - (me.time - now);
        int thenRound = best.roundNum;
        long deltaTime = 0L;
        if (then < 0L) {
            return new FireDemand(0.0, -1.0, 0.0, 0.0, this);
        }
        double prob = this.getProb();
        double speed = 20.0 - (double)3 * power;
        Point bulletPos = new Point(0.0, 0.0);
        i = 0;
        while ((long)i + then < this.enemy.getRoundLength(thenRound)) {
            bulletPos = Point.makePoint(pos, pos.angleTo(them), speed * (double)(now + (long)i - BattleField.getTime()));
            if (Math.abs(bulletPos.dist(them)) < 10.0) break;
            ++deltaTime;
            PatternBlip p = this.enemy.getPBlip((long)i + then, thenRound);
            if (p == null) {
                them.x += Math.sin(Math.toRadians(b.head)) * b.vel;
                them.y += Math.cos(Math.toRadians(b.head)) * b.vel;
            } else {
                int j2 = 0;
                while ((long)j2 < deltaTime) {
                    b.head += p.turnRate;
                    b.pos.x += Math.sin(Math.toRadians(b.head)) * p.vel;
                    b.pos.y += Math.cos(Math.toRadians(b.head)) * p.vel;
                    ++j2;
                }
                b.vel = p.vel;
                them = new Point(b.pos);
                deltaTime = 0L;
            }
            ++i;
        }
        if (Math.abs(bulletPos.dist(them)) > 10.0) {
            return new FireDemand(0.0, -1.0, 0.0, 0.0, this);
        }
        if (them.isOutsideArena()) {
            return new FireDemand(0.0, -1.0, 0.0, 0.0, this);
        }
        double bear = pos.angleTo(them);
        dist = pos.dist(them);
        if (this.bulletsFired < 5) {
            prob = 1.0;
        }
        return new FireDemand(power, prob, bear, dist, this);
    }

    public SituationMatch(Enemy t) {
        super(t);
        int i = 0;
        while (i < 36) {
            this.situ[i] = new Vector();
            ++i;
        }
        this.avb = false;
    }
}

