/*
 * Decompiled with CFR 0.152.
 */
package bts.gun;

import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.ScannedRobotEvent;

public abstract class Gun {
    private AdvancedRobot robot;
    private long bulletsFired = 0L;
    private long bulletsHit = 0L;
    private double powerFired = 0.0;
    private double powerHit = 0.0;

    public Gun(AdvancedRobot robot) {
        this.robot = robot;
    }

    public void bulletFired(Bullet b) {
        ++this.bulletsFired;
        this.powerFired += b.getPower();
    }

    public void update(BulletHitEvent e) {
        ++this.bulletsHit;
        this.powerHit += e.getBullet().getPower();
    }

    public void cleanUpRound() {
        this.getRobot().out.println("Bullets fired/hit: " + this.getBulletsFired() + "/" + this.getBulletsHit() + " (" + (double)Math.round((double)this.getBulletsHit() * 1000.0 / (double)this.getBulletsFired()) / 10.0 + "%)");
        this.getRobot().out.println("Power fired/hit: " + (int)this.getPowerFired() + "/" + (int)this.getPowerHit() + " (" + (double)Math.round(this.getPowerHit() * 1000.0 / this.getPowerFired()) / 10.0 + "%)");
    }

    public abstract void execute();

    public abstract void update(ScannedRobotEvent var1);

    public abstract void initRound();

    public AdvancedRobot getRobot() {
        return this.robot;
    }

    public long getBulletsFired() {
        return this.bulletsFired;
    }

    public long getBulletsHit() {
        return this.bulletsHit;
    }

    public double getPowerFired() {
        return this.powerFired;
    }

    public double getPowerHit() {
        return this.powerHit;
    }
}

