/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4;

import gre.svman4.useful.ReadAttributesFromFile;
import gre.svman4.useful.WriteAttributesToFile;
import java.io.File;
import java.util.HashMap;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;

public class LeonidasInfo {
    public static double ENEMY_ENERGY_TO_RAM = 0.2;
    public static double ENERGY_LIMIT_TO_PREVENT_SHOOTING = 9.375;
    private static final String FILENAME_FOR_READ = "info.dat";
    private static final String FILENAME_FOR_WRITE = "result.dat";
    public static double GUN_TURN_REMAINING_THRESHOLD = 2.0;
    public static double LAST_POINT_FORCE_DAMPING_FACTOR = 4.0;
    public static int MAX_DISTANCE_FOR_SAVE_NEW_LAST_POSITION = 126;
    public static double MAX_TIME_FOR_SAVE_NEW_LAST_POSITION = 30.0;
    public static double MIN_ANGLE_TO_LOW_SPEED_DEGREES = 30.0;
    public static double MIN_ANGLE_TO_LOW_SPEED = Math.toRadians(MIN_ANGLE_TO_LOW_SPEED_DEGREES);
    public static int MINIMUM_ENEMIES_FOR_AREA_TARGETING_GUN = 9;
    public static double RESULT_DAMAGE_FROM_ANOTHER_ROBOT = 0.0;
    public static double RESULT_DAMAGE_FROM_HIT_TO_ROBOT = 0.0;
    public static double RESULT_DAMAGE_FROM_HIT_WALL = 0.0;
    public static double RESULT_DAMAGE_TO_TARGET = 0.0;
    public static int RESULT_HIT_FROM_ANOTHER_ROBOT = 0;
    public static int RESULT_HIT_ON_WALL = 0;
    public static int RESULT_HIT_TO_TARGET = 0;
    public static double SPEED_ON_ROBOT_TURN = 3.0;
    public static double WALL_MARGIN = 20.0;

    public static void endOfBattle(AdvancedRobot robot, BattleEndedEvent event) {
        HashMap<String, Number> info = new HashMap<String, Number>();
        int score = event.getResults().getScore();
        int rank = event.getResults().getRank();
        int lastSurvivorBonus = event.getResults().getLastSurvivorBonus();
        info.put("RESULT_DAMAGE_FROM_ANOTHER_ROBOT", RESULT_DAMAGE_FROM_ANOTHER_ROBOT);
        info.put("RESULT_HIT_TO_TARGET", RESULT_HIT_TO_TARGET);
        info.put("RESULT_HIT_FROM_ANOTHER_ROBOT", RESULT_HIT_FROM_ANOTHER_ROBOT);
        info.put("RESULT_HIT_ON_WALL", RESULT_HIT_ON_WALL);
        info.put("RESULT_DAMAGE_TO_TARGET", RESULT_DAMAGE_TO_TARGET);
        info.put("RESULT_DAMAGE_FROM_HIT_WALL", RESULT_DAMAGE_FROM_HIT_WALL);
        info.put("RESULT_DAMAGE_FROM_HIT_TO_ROBOT", RESULT_DAMAGE_FROM_HIT_TO_ROBOT);
        info.put("TOTAL_SCORE", score);
        info.put("FINAL_RANK", rank);
        info.put("LAST_SURVIROR_BONUS", lastSurvivorBonus);
        File file = robot.getDataFile(FILENAME_FOR_WRITE);
        WriteAttributesToFile.write(info, file);
        for (String key : info.keySet()) {
            Number n = info.get(key);
            System.out.println(String.valueOf(key) + "-->" + n);
        }
    }

    private static double readDoubleValue(String string, Number initialValue, HashMap<String, String> info) {
        String text = info.get(string);
        try {
            return Double.parseDouble(text.replace(',', '.'));
        }
        catch (NullPointerException | NumberFormatException exp) {
            return (Double)initialValue;
        }
    }

    protected static void readFromFile(AdvancedRobot robot) {
        double value;
        HashMap<String, String> info = new HashMap<String, String>();
        boolean ReadingFileSuccess = ReadAttributesFromFile.read(robot, info, FILENAME_FOR_READ);
        if (!ReadingFileSuccess) {
            System.out.println("Error on reading from file");
            return;
        }
        if (info.size() == 0) {
            return;
        }
        GUN_TURN_REMAINING_THRESHOLD = value = LeonidasInfo.readDoubleValue("GUN_TURN_REMAINING_THRESHOLD", GUN_TURN_REMAINING_THRESHOLD, info);
        value = LeonidasInfo.readDoubleValue("MINIMUM_ENEMIES_FOR_AREA_TARGETING_GUN", MINIMUM_ENEMIES_FOR_AREA_TARGETING_GUN, info);
        MINIMUM_ENEMIES_FOR_AREA_TARGETING_GUN = (int)value;
        WALL_MARGIN = value = LeonidasInfo.readDoubleValue("WALL_MARGIN", WALL_MARGIN, info);
        MIN_ANGLE_TO_LOW_SPEED_DEGREES = value = LeonidasInfo.readDoubleValue("MIN_ANGLE_TO_LOW_SPEED_DEGREES", MIN_ANGLE_TO_LOW_SPEED_DEGREES, info);
        SPEED_ON_ROBOT_TURN = value = LeonidasInfo.readDoubleValue("SPEED_ON_ROBOT_TURN", SPEED_ON_ROBOT_TURN, info);
        ENEMY_ENERGY_TO_RAM = value = LeonidasInfo.readDoubleValue("ENEMY_ENERGY_TO_RAM", ENEMY_ENERGY_TO_RAM, info);
        ENERGY_LIMIT_TO_PREVENT_SHOOTING = value = LeonidasInfo.readDoubleValue("ENERGY_LIMIT_TO_PREVENT_SHOOTING", ENERGY_LIMIT_TO_PREVENT_SHOOTING, info);
        value = LeonidasInfo.readDoubleValue("MAX_TIME_FOR_SAVE_NEW_LAST_POSITION", MAX_TIME_FOR_SAVE_NEW_LAST_POSITION, info);
        MAX_TIME_FOR_SAVE_NEW_LAST_POSITION = (long)value;
        value = LeonidasInfo.readDoubleValue("MAX_DISTANCE_FOR_SAVE_NEW_LAST_POSITION", MAX_DISTANCE_FOR_SAVE_NEW_LAST_POSITION, info);
        MAX_DISTANCE_FOR_SAVE_NEW_LAST_POSITION = (int)value;
        LAST_POINT_FORCE_DAMPING_FACTOR = value = LeonidasInfo.readDoubleValue("LAST_POINT_FORCE_DAMPING_FACTOR", LAST_POINT_FORCE_DAMPING_FACTOR, info);
    }
}

