/*
 * Decompiled with CFR 0.152.
 */
package synnalagma.neural;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.util.StringTokenizer;
import java.util.Vector;
import synnalagma.neural.Fitness;
import synnalagma.neural.NNError;
import synnalagma.neural.NNet;
import synnalagma.neural.Rand;

public class NrPop {
    static boolean fbias = false;
    static float eps = 0.3f;
    static float alfa = 0.3f;
    static float ra = -0.6f;
    static float rb = 0.6f;
    public static Rand rnd = new Rand();
    Vector Pnet;
    Fitness fitness;

    public static void setDefRandRange(float f, float f2) {
        ra = f;
        rb = f2;
    }

    public static void setDefLearnFactor(float f) {
        eps = f;
    }

    public static void setDefMomentFactor(float f) {
        alfa = f;
    }

    public static void setDefFlagBiasLearn(boolean bl) {
        fbias = bl;
    }

    public static float readDefLearnFactor() {
        return eps;
    }

    public static float readDefMomentFactor() {
        return alfa;
    }

    public static boolean readDefFlagBiasLearn() {
        return fbias;
    }

    public static void setSeed(int n) {
        rnd.setSeed(n);
    }

    public static void setSeed() {
        rnd.setSeed(System.currentTimeMillis());
    }

    public static int riab(int n, int n2) {
        return rnd.iab(n, n2);
    }

    public static float rfab(float f, float f2) {
        return rnd.fab(f, f2);
    }

    public static float rgauss(float f) {
        return rnd.gauss(f);
    }

    public NrPop(int n) {
        this.Pnet = new Vector(n);
    }

    public NrPop(int n, int n2, int n3, int n4, boolean bl, float f, float f2) {
        this.Pnet = new Vector(n);
        int n5 = 1;
        while (n5 <= n) {
            this.Pnet.add(new NNet(n2, n3, n4, bl, f, f2));
            ++n5;
        }
    }

    public NrPop(int n, int n2, int n3, int n4, boolean bl) {
        this(n, n2, n3, n4, bl, ra, rb);
    }

    public NrPop(String[] stringArray) {
        int n = 1;
        int n2 = 1;
        this.Pnet = new Vector();
        int n3 = 0;
        while (n3 < stringArray.length) {
            String string;
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n3]);
            if (stringTokenizer.countTokens() >= 1 && (string = stringTokenizer.nextToken()).startsWith("net=")) {
                String string2 = string.substring(string.indexOf(61));
                String string3 = NrPop.values(string2, 1);
                String string4 = NrPop.values(string2, 2);
                try {
                    n = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    NNError.err("Net Number missed at rec " + n3);
                }
                try {
                    n2 = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = n;
                }
                if (n2 > this.PopSize()) {
                    this.setSize(n2);
                }
                int n4 = n;
                while (n4 <= n2) {
                    NNet nNet = new NNet(stringArray, n3 + 1);
                    this.setNNet(n4, nNet);
                    ++n4;
                }
            }
            ++n3;
        }
    }

    public NrPop(String string) {
        int n = 1;
        int n2 = 1;
        boolean bl = false;
        String string2 = "";
        Vector<String> vector = new Vector<String>(100);
        try {
            StringTokenizer stringTokenizer;
            FileReader fileReader = new FileReader(string);
            LineNumberReader lineNumberReader = new LineNumberReader(fileReader);
            try {
                while ((string2 = (stringTokenizer = new StringTokenizer(lineNumberReader.readLine())).nextToken()).startsWith("net=")) {
                }
            }
            catch (IOException iOException) {
                bl = true;
            }
            while (!bl) {
                String string3 = string2.substring(string2.indexOf(61));
                String string4 = NrPop.values(string3, 1);
                String string5 = NrPop.values(string3, 2);
                try {
                    n = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    NNError.err("Net Number missed at rec " + lineNumberReader.getLineNumber());
                }
                try {
                    n2 = Integer.parseInt(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = n;
                }
                if (n2 > this.PopSize()) {
                    this.setSize(n2);
                }
                try {
                    String string6;
                    while (!(string2 = (stringTokenizer = new StringTokenizer(string6 = lineNumberReader.readLine())).nextToken()).startsWith("net=")) {
                        vector.addElement(string6);
                    }
                }
                catch (IOException iOException) {
                    bl = true;
                }
                if (bl) break;
                String[] stringArray = (String[])vector.toArray();
                int n3 = n;
                while (n3 <= n2) {
                    NNet nNet = new NNet(stringArray, 0);
                    this.setNNet(n3, nNet);
                    ++n3;
                }
            }
            try {
                lineNumberReader.close();
                fileReader.close();
            }
            catch (IOException iOException) {
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            NNError.err("File not found " + string);
        }
    }

    public NNet getNNet(int n) {
        return (NNet)this.Pnet.get(n - 1);
    }

    public void addNNet(NNet nNet) {
        this.Pnet.add(nNet);
    }

    public void setNNet(int n, NNet nNet) {
        this.Pnet.setElementAt(nNet, n - 1);
    }

    public int PopSize() {
        return this.Pnet.size();
    }

    public void setSize(int n) {
        this.Pnet.setSize(n);
    }

    public void removeNNet(int n) {
        this.Pnet.removeElementAt(n - 1);
    }

    public void fitInit() {
        this.fitness = new Fitness(this.Pnet.size());
        int n = 1;
        while (n <= this.Pnet.size()) {
            this.fitness.setFit(n, 0.0f);
            ++n;
        }
    }

    public void fitSet(int n, float f) {
        this.fitness.setFit(n, f);
    }

    public int fitGetNumAtPos(int n) {
        return this.fitness.getNum(n);
    }

    public NNet fitGetNetAtPos(int n) {
        return this.getNNet(this.fitness.getNum(n));
    }

    public float fitGetValAtPos(int n) {
        return this.fitness.getVal(n);
    }

    public void fitRankingMin() {
        this.fitness.rankMin();
    }

    public void fitRankingMax() {
        this.fitness.rankMax();
    }

    public int[] fitGetGradingList() {
        return this.fitness.getArrayNum();
    }

    public float fitGetFitness(int n) {
        int n2 = 0;
        while (n2 < this.Pnet.size()) {
            if (this.fitness.net[n2] == n) {
                return this.fitness.fit[n2];
            }
            ++n2;
        }
        return 0.0f;
    }

    public void nrPopSave(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println("NPOP-DATA " + this.PopSize());
            int n = 1;
            while (n <= this.PopSize()) {
                this.getNNet(n).saveNNet(printStream, n);
                ++n;
            }
            printStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            NNError.err("Impossible to create file " + string);
        }
    }

    public void nrPopSave(String string, int[] nArray, int n) {
        int n2 = nArray.length < n ? nArray.length : n;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println("NPOP-DATA " + this.PopSize());
            int n3 = 0;
            while (n3 < n2) {
                if (nArray[n3] <= this.PopSize()) {
                    this.getNNet(nArray[n3]).saveNNet(printStream, nArray[n3]);
                }
                ++n3;
            }
            printStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            NNError.err("Impossible to create file " + string);
        }
    }

    public NrPop(String string, boolean bl) {
        int n = 0;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            StreamTokenizer streamTokenizer = new StreamTokenizer(inputStreamReader);
            streamTokenizer.whitespaceChars(44, 44);
            streamTokenizer.whitespaceChars(58, 58);
            try {
                streamTokenizer.nextToken();
            }
            catch (IOException iOException) {
                return;
            }
            if (streamTokenizer.sval.equals("NPOP-DATA")) {
                try {
                    streamTokenizer.nextToken();
                    n = (int)streamTokenizer.nval;
                }
                catch (IOException iOException) {
                    NNError.err("Error on net file");
                    return;
                }
            }
            this.Pnet = new Vector(n);
            int n2 = 1;
            while (n2 <= n) {
                try {
                    streamTokenizer.nextToken();
                }
                catch (IOException iOException) {
                    break;
                }
                if (streamTokenizer.sval.equals("NET")) {
                    try {
                        streamTokenizer.nextToken();
                        int n3 = (int)streamTokenizer.nval;
                    }
                    catch (IOException iOException) {
                        NNError.err("Error on net file");
                        break;
                    }
                }
                NNet nNet = new NNet();
                nNet.loadNNet(streamTokenizer);
                this.addNNet(nNet);
                ++n2;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            NNError.err("File not found " + string);
        }
    }

    static String values(String string, int n) {
        int n2 = 1;
        int n3 = 0;
        if (string.length() == 0) {
            return "";
        }
        int n4 = 1;
        while (n4 < string.length()) {
            if (string.charAt(n4) == ',' | string.charAt(n4) == '(' | string.charAt(n4) == ')') {
                if (++n3 == n) {
                    return string.substring(n2, n4);
                }
                n2 = n4 + 1;
            }
            ++n4;
        }
        if (++n3 == n) {
            return string.substring(n2, n4);
        }
        n2 = n4 + 1;
        return "";
    }

    public static String[] fileToStrArray(String string) {
        Vector<String> vector = new Vector<String>(100);
        String[] stringArray = null;
        try {
            FileReader fileReader = new FileReader(string);
            LineNumberReader lineNumberReader = new LineNumberReader(fileReader);
            try {
                String string2;
                while ((string2 = lineNumberReader.readLine()) != null) {
                    vector.addElement(string2);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            stringArray = new String[vector.size()];
            String[] stringArray2 = vector.toArray(stringArray);
            try {
                lineNumberReader.close();
                fileReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return stringArray;
        }
        catch (FileNotFoundException fileNotFoundException) {
            NNError.err("File not found " + string);
            return null;
        }
    }
}

