/*
 * Decompiled with CFR 0.152.
 */
package sos;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SOS
extends AdvancedRobot {
    static Vector guns;
    static Vector virtualBullets;
    public static int BINS;
    public static double[] _surfStats;
    public static double _oppEnergy;
    public static Rectangle2D.Double _fieldRect;
    public static double WALL_STICK;
    double BULLET_POWER;
    RobotState me;
    RobotState target;
    Rectangle2D.Double battlefield;
    public Point2D.Double _myLocation;
    public Point2D.Double _enemyLocation;
    public ArrayList _enemyWaves;
    public ArrayList _surfDirections;
    public ArrayList _surfAbsBearings;
    public Vector waves;
    double bulletPower;
    double absBearing;
    double min;
    double max;
    double fire;
    double radarTurnAngle;
    double endis;
    double enbearing;

    public void run() {
        this.setBodyColor(Color.white);
        this.setGunColor(Color.white);
        this.setRadarColor(Color.white);
        this.setScanColor(Color.white);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(false);
        this.setAdjustRadarForRobotTurn(true);
        this._enemyWaves = new ArrayList();
        this._surfDirections = new ArrayList();
        this._surfAbsBearings = new ArrayList();
        this.battlefield = new Rectangle2D.Double(0.0, 0.0, this.getBattleFieldWidth(), this.getBattleFieldHeight());
        if (guns == null) {
            guns = new Vector();
            LinearGun defaultGun = new LinearGun();
            defaultGun.hits = 1L;
            guns.add(defaultGun);
            guns.add(new HeadOnGun());
            guns.add(new ReverseGun());
            guns.add(new RandomGun());
            guns.add(new MeanGun());
            guns.add(new ReverseMeanGun());
            guns.add(new OffBearingGun());
            guns.add(new ReverseOffBearingGun());
        }
        virtualBullets.clear();
        while (true) {
            this.me = new RobotState();
            this.me.name = this.getName();
            this.me.velocity = this.getVelocity();
            this.me.heading = this.getHeadingRadians();
            this.me.x = this.getX();
            this.me.y = this.getY();
            if (this.target == null) {
                this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            } else {
                this.radarTurnAngle = SOS.normalizeRelativeAngle(this.me.absoluteAngleTo(this.target) - this.getRadarHeadingRadians());
                this.radarTurnAngle = this.radarTurnAngle > 0.0 ? (this.radarTurnAngle += 0.4) : (this.radarTurnAngle -= 0.4);
                if (this.getOthers() == 1) {
                    this.setTurnRadarRightRadians(this.radarTurnAngle);
                } else {
                    this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
                }
            }
            Iterator i = virtualBullets.iterator();
            while (i.hasNext()) {
                VirtualBullet virtualBullet = (VirtualBullet)i.next();
                virtualBullet.setLocation(virtualBullet.project(virtualBullet.heading, virtualBullet.velocity));
                if (virtualBullet.distance(this.target) < 25.0) {
                    ++virtualBullet.gunUsed.hits;
                    i.remove();
                    continue;
                }
                if (this.battlefield.contains(virtualBullet)) continue;
                i.remove();
            }
            if (this.target != null) {
                this.gun();
            }
            this.execute();
        }
    }

    public void gun() {
        long bestScore = -1;
        Gun bestGun = null;
        Iterator i = guns.iterator();
        while (i.hasNext()) {
            Gun gun = (Gun)i.next();
            if (gun.hits <= bestScore) continue;
            bestScore = gun.hits;
            bestGun = gun;
        }
        if (this.getGunHeat() < (double)2) {
            this.setTurnRadarRightRadians(this.radarTurnAngle);
            this.setTurnGunRightRadians(SOS.normalizeRelativeAngle(bestGun.getFiringAngle(this.me, this.target, this.BULLET_POWER) - this.getGunHeadingRadians()));
        } else {
            this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
        if (this.getEnergy() > 1.0) {
            if (this.endis < 100.0) {
                this.BULLET_POWER = 3;
            } else if (this.endis < 200.0) {
                this.BULLET_POWER = 2;
            } else if (this.endis < 300.0) {
                this.BULLET_POWER = 1.0;
            }
        } else {
            this.BULLET_POWER = 0.1;
        }
        Bullet b = this.setFireBullet(this.BULLET_POWER);
        if (b != null) {
            i = guns.iterator();
            while (i.hasNext()) {
                Gun gun = (Gun)i.next();
                VirtualBullet newVirtualBullet = new VirtualBullet();
                newVirtualBullet.setLocation(this.me);
                newVirtualBullet.heading = gun.getFiringAngle(this.me, this.target, this.BULLET_POWER);
                newVirtualBullet.velocity = 20.0 - (double)3 * this.BULLET_POWER;
                newVirtualBullet.gunUsed = gun;
                virtualBullets.add(newVirtualBullet);
            }
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.enbearing = e.getBearing();
        this.endis = e.getDistance();
        this.target = new RobotState();
        this.target.setLocation(this.me.project(e.getBearingRadians() + this.getHeadingRadians(), e.getDistance()));
        this.target.heading = e.getHeadingRadians();
        this.target.velocity = e.getVelocity();
        this.target.name = e.getName();
        this.setMaxVelocity(8.0);
        this._myLocation = new Point2D.Double(this.getX(), this.getY());
        double lateralVelocity = this.getVelocity() * Math.sin(e.getBearingRadians());
        this.absBearing = e.getBearingRadians() + this.getHeadingRadians();
        this._surfDirections.add(0, new Integer(lateralVelocity >= 0.0 ? 1 : -1));
        this._surfAbsBearings.add(0, new Double(this.absBearing + Math.PI));
        this.bulletPower = _oppEnergy - e.getEnergy();
        if (this.bulletPower < this.max && this.bulletPower > this.min && this._surfDirections.size() > 2) {
            this.fire = 1.0;
            EnemyWave ew = new EnemyWave();
            ew.fireTime = this.getTime() - 1L;
            ew.bulletVelocity = SOS.bulletVelocity(this.bulletPower);
            ew.distanceTraveled = SOS.bulletVelocity(this.bulletPower);
            ew.direction = (Integer)this._surfDirections.get(2);
            ew.directAngle = (Double)this._surfAbsBearings.get(2);
            ew.fireLocation = (Point2D.Double)this._enemyLocation.clone();
            this._enemyWaves.add(ew);
        }
        _oppEnergy = e.getEnergy();
        this._enemyLocation = SOS.project(this._myLocation, this.absBearing, e.getDistance());
        this.updateWaves();
        this.doSurfing();
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        if (this.bulletPower < 3.01 && this.bulletPower > 0.09 && this._surfDirections.size() > 2) {
            EnemyWave ew = new EnemyWave();
            ew.fireTime = this.getTime() - 1L;
            ew.bulletVelocity = SOS.bulletVelocity(this.bulletPower);
            ew.distanceTraveled = SOS.bulletVelocity(this.bulletPower);
            ew.direction = (Integer)this._surfDirections.get(2);
            ew.directAngle = (Double)this._surfAbsBearings.get(2);
            ew.fireLocation = (Point2D.Double)this._enemyLocation.clone();
            this._enemyWaves.add(ew);
        }
        this._enemyLocation = SOS.project(this._myLocation, this.absBearing, this.endis);
        this.updateWaves();
        this.doSurfing();
    }

    public void onBulletHit(BulletHitEvent e) {
        double firepower = e.getBullet().getPower();
        _oppEnergy -= firepower * (double)4 + Math.max(0.0, firepower - 1.0) * (double)2;
    }

    public void onDeath(DeathEvent e) {
        this.endRound();
    }

    public void onWin(WinEvent e) {
        this.endRound();
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
    }

    public void onHitRobot(HitRobotEvent e) {
        this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        this.doSurfing();
        this.setMaxVelocity(8.0);
        this.setAhead(100.0);
    }

    public void endRound() {
        Iterator i = guns.iterator();
        this.out.println();
        this.out.println("Virtual bullet hit table");
        this.out.println("------------------------");
        while (i.hasNext()) {
            Gun gun = (Gun)i.next();
            this.out.println(gun.getName() + ": " + gun.hits);
        }
        this.out.println();
        this.target = null;
    }

    public void onPaint(Graphics2D g) {
        Iterator i = virtualBullets.iterator();
        while (i.hasNext()) {
            VirtualBullet virtualBullet = (VirtualBullet)i.next();
            g.setColor(virtualBullet.gunUsed.getColor());
            g.fillOval((int)virtualBullet.x - 3, (int)virtualBullet.y - 3, 6, 6);
        }
        int numberOfGuns = guns.size();
        int j = 0;
        while (j < numberOfGuns) {
            Gun gun = (Gun)guns.elementAt(j);
            g.setColor(Color.WHITE);
            g.drawString(gun.getName() + ": " + gun.hits, 20, 5 + j * 15);
            g.setColor(gun.getColor());
            g.fillOval(5, 5 + j * 15, 10, 10);
            ++j;
        }
    }

    public static double normalizeRelativeAngle(double angle) {
        while (angle <= -Math.PI) {
            angle += Math.PI * 2;
        }
        while (angle > Math.PI) {
            angle -= Math.PI * 2;
        }
        return angle;
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!_fieldRect.contains(SOS.project(botLocation, angle, WALL_STICK))) {
            angle += (double)orientation * 0.05;
        }
        return angle;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double bulletVelocity(double power) {
        return 20.0 - (double)3 * power;
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }

    public void updateWaves() {
        int x = 0;
        while (x < this._enemyWaves.size()) {
            EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
            ew.distanceTraveled = (double)(this.getTime() - ew.fireTime) * ew.bulletVelocity;
            if (ew.distanceTraveled > this._myLocation.distance(ew.fireLocation) + 50.0) {
                this._enemyWaves.remove(x);
                --x;
            }
            ++x;
        }
    }

    public EnemyWave getClosestSurfableWave() {
        double closestDistance = 50000.0;
        EnemyWave surfWave = null;
        int x = 0;
        while (x < this._enemyWaves.size()) {
            EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
            double distance = this._myLocation.distance(ew.fireLocation) - ew.distanceTraveled;
            if (distance > ew.bulletVelocity && distance < closestDistance) {
                surfWave = ew;
                closestDistance = distance;
            }
            ++x;
        }
        return surfWave;
    }

    public static int getFactorIndex(EnemyWave ew, Point2D.Double targetLocation) {
        double offsetAngle = SOS.absoluteBearing(ew.fireLocation, targetLocation) - ew.directAngle;
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / SOS.maxEscapeAngle(ew.bulletVelocity) * (double)ew.direction;
        return (int)SOS.limit(0.0, factor * (double)((BINS - 1) / 2) + (double)((BINS - 1) / 2), BINS - 1);
    }

    public void logHit(EnemyWave ew, Point2D.Double targetLocation) {
        int index = SOS.getFactorIndex(ew, targetLocation);
        int x = 0;
        while (x < BINS) {
            int n = x;
            _surfStats[n] = _surfStats[n] + 1.0 / (Math.pow(index - x, 2) + 1.0);
            ++x;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        if (!this._enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            EnemyWave hitWave = null;
            int x = 0;
            while (x < this._enemyWaves.size()) {
                EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
                if (Math.abs(ew.distanceTraveled - this._myLocation.distance(ew.fireLocation)) < 50.0 && Math.round(SOS.bulletVelocity(e.getBullet().getPower()) * 10.0) == Math.round(ew.bulletVelocity * 10.0)) {
                    hitWave = ew;
                    break;
                }
                ++x;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                this._enemyWaves.remove(this._enemyWaves.lastIndexOf(hitWave));
            }
        }
        this.updateWaves();
        this.doSurfing();
    }

    public Point2D.Double predictPosition(EnemyWave surfWave, int direction) {
        Point2D.Double predictedPosition = (Point2D.Double)this._myLocation.clone();
        double predictedVelocity = this.getVelocity();
        double predictedHeading = this.getHeadingRadians();
        int counter = 0;
        boolean intercepted = false;
        do {
            double moveAngle = this.wallSmoothing(predictedPosition, SOS.absoluteBearing(surfWave.fireLocation, predictedPosition) + (double)direction * 1.5707963267948966, direction) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveAngle = Utils.normalRelativeAngle((double)moveAngle);
            double maxTurning = 0.004363323129985824 * (40.0 - (double)3 * Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + SOS.limit(-maxTurning, moveAngle, maxTurning)));
            predictedVelocity += predictedVelocity * moveDir < 0.0 ? (double)2 * moveDir : moveDir;
            if ((predictedVelocity = SOS.limit(-8.0, predictedVelocity, 8.0)) < 0.1 && predictedVelocity > -0.1) {
                predictedVelocity = 1.0;
            }
            predictedPosition = SOS.project(predictedPosition, predictedHeading, predictedVelocity);
            ++counter;
            if (!(predictedPosition.distance(surfWave.fireLocation) < surfWave.distanceTraveled + (double)counter * surfWave.bulletVelocity + surfWave.bulletVelocity)) continue;
            intercepted = true;
        } while (!intercepted && counter < 500);
        return predictedPosition;
    }

    public double checkDanger(EnemyWave surfWave, int direction) {
        int index = SOS.getFactorIndex(surfWave, this.predictPosition(surfWave, direction));
        return _surfStats[index];
    }

    public void doSurfing() {
        EnemyWave surfWave = this.getClosestSurfableWave();
        if (surfWave == null) {
            return;
        }
        double dangerLeft = this.checkDanger(surfWave, -1);
        double dangerRight = this.checkDanger(surfWave, 1);
        double goAngle = SOS.absoluteBearing(surfWave.fireLocation, this._myLocation);
        if (dangerLeft < dangerRight) {
            this.setMaxVelocity(8.0);
            goAngle = this.wallSmoothing(this._myLocation, goAngle - 1.5707963267948966, -1);
        } else {
            this.setMaxVelocity(8.0);
            goAngle = this.wallSmoothing(this._myLocation, goAngle + 1.5707963267948966, 1);
        }
        SOS.setBackAsFront(this, goAngle);
    }

    private final /* synthetic */ void this() {
        this.BULLET_POWER = 3;
        this.waves = new Vector();
        this.min = 0.09;
        this.max = 3.01;
        this.fire = 0.0;
    }

    public SOS() {
        this.this();
    }

    static {
        virtualBullets = new Vector();
        BINS = 47;
        _surfStats = new double[BINS];
        _oppEnergy = 100.0;
        _fieldRect = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
        WALL_STICK = 160.0;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class LinearGun
    extends Gun {
        public String getName() {
            return "Simple linear gun";
        }

        public Color getColor() {
            return Color.YELLOW;
        }

        public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower) {
            double directAngle = shooter.absoluteAngleTo(target);
            return directAngle - target.velocity * Math.sin(directAngle - target.heading) / (20.0 - (double)3 * bulletPower);
        }

        LinearGun() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    abstract class Gun {
        public long hits;

        public abstract Color getColor();

        public abstract String getName();

        public abstract double getFiringAngle(RobotState var1, RobotState var2, double var3);

        Gun() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class HeadOnGun
    extends Gun {
        public String getName() {
            return "Head on";
        }

        public Color getColor() {
            return Color.GREEN;
        }

        public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower) {
            return shooter.absoluteAngleTo(target);
        }

        HeadOnGun() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ReverseGun
    extends Gun {
        public String getName() {
            return "reverse linear";
        }

        public Color getColor() {
            return Color.YELLOW;
        }

        public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower) {
            double directAngle = shooter.absoluteAngleTo(target);
            return directAngle + target.velocity * Math.sin(directAngle - target.heading) / (20.0 - (double)3 * bulletPower);
        }

        ReverseGun() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class RandomGun
    extends Gun {
        public String getName() {
            return "random";
        }

        public Color getColor() {
            return Color.ORANGE;
        }

        public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower) {
            double directAngle = shooter.absoluteAngleTo(target);
            return directAngle + Math.random() * (double)3;
        }

        RandomGun() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class MeanGun
    extends Gun {
        public String getName() {
            return "mean";
        }

        public Color getColor() {
            return Color.PINK;
        }

        public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower) {
            double directAngle = shooter.absoluteAngleTo(target);
            return directAngle + target.velocity * Math.sin(directAngle - target.heading) / (20.0 - (double)3 * bulletPower) / (double)2;
        }

        MeanGun() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ReverseMeanGun
    extends Gun {
        public String getName() {
            return "reverse-mean";
        }

        public Color getColor() {
            return Color.PINK;
        }

        public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower) {
            double directAngle = shooter.absoluteAngleTo(target);
            return directAngle - target.velocity * Math.sin(directAngle - target.heading) / (20.0 - (double)3 * bulletPower) / (double)2;
        }

        ReverseMeanGun() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class OffBearingGun
    extends Gun {
        public String getName() {
            return "off-bearing";
        }

        public Color getColor() {
            return Color.CYAN;
        }

        public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower) {
            double directAngle = shooter.absoluteAngleTo(target);
            return directAngle + 25.0;
        }

        OffBearingGun() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ReverseOffBearingGun
    extends Gun {
        public String getName() {
            return "reverse off-bearing";
        }

        public Color getColor() {
            return Color.CYAN;
        }

        public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower) {
            double directAngle = shooter.absoluteAngleTo(target);
            return directAngle - 25.0;
        }

        ReverseOffBearingGun() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class RobotState
    extends MotionState {
        public String name;

        RobotState() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class VirtualBullet
    extends MotionState {
        public Gun gunUsed;

        VirtualBullet() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class EnemyWave {
        Point2D.Double fireLocation;
        long fireTime;
        double bulletVelocity;
        double directAngle;
        double distanceTraveled;
        int direction;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class MotionState
    extends FieldPoint {
        public double velocity;
        public double heading;

        MotionState() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class FieldPoint
    extends Point2D.Double {
        public double absoluteAngleTo(FieldPoint p) {
            double angle = Math.atan2(p.x - this.x, p.y - this.y);
            while (angle < 0.0) {
                angle += Math.PI * 2;
            }
            while (angle >= Math.PI * 2) {
                angle -= Math.PI * 2;
            }
            return angle;
        }

        public FieldPoint project(double angle, double distance) {
            return new FieldPoint(this.x + Math.sin(angle) * distance, this.y + Math.cos(angle) * distance);
        }

        public FieldPoint() {
        }

        public FieldPoint(double x, double y) {
            super(x, y);
        }
    }
}

