/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.EnemyPrediction;

import java.util.ArrayList;
import rdt.AgentSmith.EnemyPrediction.BulletPrediction;
import rdt.AgentSmith.EnemyPrediction.EnemyPrediction;
import rdt.AgentSmith.EnemyPrediction.EnemyPredictionDebug;
import rdt.AgentSmith.EnemyPrediction.IEnemyPredictionEventHandler;
import rdt.AgentSmith.EnemyPrediction.IEnemyPredictionManager;
import rdt.AgentSmith.EnemyPrediction.PredictedPosition;
import rdt.AgentSmith.IRobot;
import rdt.AgentSmith.IRoundStartedEventHandler;
import rdt.AgentSmith.RobotHistory.RobotSnapshot;
import rdt.AgentSmith.Targeting.ITargeting;
import rdt.AgentSmith.Targeting.Target;
import rdt.AgentSmith.Utils.MathUtils;
import rdt.AgentSmith.Utils.RuleUtils;
import rdt.AgentSmith.Waves.IWaveEventHandler;
import rdt.AgentSmith.Waves.IWaveManager;
import rdt.AgentSmith.Waves.WaveData;
import robocode.BulletHitBulletEvent;
import robocode.HitByBulletEvent;
import robocode.Rules;

public class EnemyPredictionManager
implements IEnemyPredictionManager,
IRoundStartedEventHandler,
IWaveEventHandler {
    private BulletPrediction[] _bulletPredictions;
    private int _bulletPredictionCount;
    private EnemyPrediction[] _enemyPredictions;
    private int _enemyPredictionCount;
    private IWaveManager _enemyWaveManager;
    private IRobot _robot;
    private ITargeting _targeting;
    private int _maxPredictionTicks;
    private double[] _bulletAngles;
    private boolean _resetPrediction = true;
    private final double _battlefieldWidth;
    private final double _battlefieldHeight;
    private ArrayList<IEnemyPredictionEventHandler> _registeredEventHandlers = new ArrayList();

    public EnemyPredictionManager(IRobot robot, ITargeting targeting, IWaveManager enemyWaveManager) {
        int maxPredictedBullets = 50;
        this._maxPredictionTicks = 100;
        int maxPredictedBulletAngles = 10;
        this._bulletAngles = new double[maxPredictedBulletAngles];
        this._enemyWaveManager = enemyWaveManager;
        this._robot = robot;
        this._targeting = targeting;
        this._battlefieldWidth = this._robot.getBattleFieldWidth();
        this._battlefieldHeight = this._robot.getBattleFieldHeight();
        double slowestBullet = RuleUtils.GetBulletVelocity(3.0);
        double largestDistance = Math.sqrt(robot.getBattleFieldWidth() * robot.getBattleFieldWidth() + robot.getBattleFieldHeight() * robot.getBattleFieldWidth());
        int maxBulletFlightTime = (int)Math.ceil(largestDistance / slowestBullet);
        this._bulletPredictions = new BulletPrediction[maxPredictedBullets];
        this._enemyPredictions = new EnemyPrediction[robot.getOthers()];
        for (int bulletIndex = 0; bulletIndex < this._bulletPredictions.length; ++bulletIndex) {
            this._bulletPredictions[bulletIndex] = new BulletPrediction(Math.min(this._maxPredictionTicks, maxBulletFlightTime));
        }
        for (int index = 0; index < this._enemyPredictions.length; ++index) {
            this._enemyPredictions[index] = new EnemyPrediction(this._maxPredictionTicks);
        }
        new EnemyPredictionDebug(robot, this);
        this._robot.RegisterForEventHandling(this);
        this._enemyWaveManager.RegisterWaveEventHandler(this);
    }

    public void Update() {
        if (this._resetPrediction) {
            this.GeneratePrediction();
            this._resetPrediction = false;
        }
    }

    private void GeneratePrediction() {
        this._bulletPredictionCount = 0;
        this._enemyPredictionCount = 0;
        this.GenerateFromExistingEnemyWaves();
        this.GenerateFromTargets();
        for (int index = 0; index < this._registeredEventHandlers.size(); ++index) {
            this._registeredEventHandlers.get(index).OnEnemyPredictionChangedEvent();
        }
    }

    @Override
    public BulletPrediction[] GetBulletPredictions() {
        return this._bulletPredictions;
    }

    @Override
    public int GetBulletPredictionCount() {
        return this._bulletPredictionCount;
    }

    @Override
    public EnemyPrediction[] GetEnemyPredictions() {
        return this._enemyPredictions;
    }

    @Override
    public int GetEnemyPredictionCount() {
        return this._enemyPredictionCount;
    }

    @Override
    public void RegisterForEventHandling(IEnemyPredictionEventHandler eventHandler) {
        this._registeredEventHandlers.add(eventHandler);
    }

    @Override
    public void OnRoundStartedEvent() {
        this._resetPrediction = true;
    }

    @Override
    public void OnWaveGeneratedEvent() {
        this._resetPrediction = true;
    }

    @Override
    public void OnBulletHitBulletWithWaveEvent(BulletHitBulletEvent eventData, WaveData waveData) {
    }

    @Override
    public void OnHitByBulletWithWaveEvent(HitByBulletEvent eventData, WaveData waveData) {
    }

    @Override
    public void OnWavePassed(WaveData waveData, Target target) {
    }

    private void GenerateFromExistingEnemyWaves() {
        ArrayList<WaveData> activeWaves = this._enemyWaveManager.GetActiveWaves();
        int waveCount = activeWaves.size();
        for (int index = 0; index < waveCount; ++index) {
            WaveData wave = activeWaves.get(index);
            this.GenerateWavePrediction(wave);
        }
    }

    private void GenerateWavePrediction(WaveData waveData) {
        double firepower = waveData.Firepower;
        RobotSnapshot targetWhenCalculatedGunFiring = waveData.TargetThatFired.RobotHistory.GetSnapshotForTick(waveData.ActivationTick - 1L);
        int predictedAngleCount = waveData.TargetThatFired.GunsFiredFromTarget.PredictAngles(targetWhenCalculatedGunFiring.LocationX, targetWhenCalculatedGunFiring.LocationY, waveData.ActivationTick, Rules.getBulletSpeed((double)firepower), this._bulletAngles);
        long ticksLeftToWaveDeactivation = waveData.TickWaveIsOutsideBattlefield - this._robot.getTime();
        long predictionDeactivationTime = Math.min(ticksLeftToWaveDeactivation, (long)this._maxPredictionTicks);
        block0: for (int angleIndex = 0; angleIndex < predictedAngleCount; ++angleIndex) {
            double predictedAngle = this._bulletAngles[angleIndex];
            double dX = MathUtils.FastSin(predictedAngle);
            double dY = MathUtils.FastCos(predictedAngle);
            BulletPrediction prediction = this._bulletPredictions[this._bulletPredictionCount];
            ++this._bulletPredictionCount;
            prediction.TickPredictionWasGenerated = this._robot.getTime();
            prediction.PredictionDeactivationTime = predictionDeactivationTime;
            prediction.Firepower = firepower;
            prediction.DamageDealt = Rules.getBulletDamage((double)prediction.Firepower);
            int predictionTime = 0;
            while ((long)predictionTime < prediction.PredictionDeactivationTime) {
                PredictedPosition predictedPosition = prediction.PredicctedPositions[predictionTime];
                double waveDistance = waveData.GetDistanceForTick(this._robot.getTime() + (long)predictionTime);
                double x = waveData.OriginX + waveDistance * dX;
                double y = waveData.OriginY + waveDistance * dY;
                predictedPosition.X = x;
                predictedPosition.Y = y;
                if (x <= 0.0 || x >= this._battlefieldWidth || y <= 0.0 || y >= this._battlefieldHeight) {
                    prediction.PredictionDeactivationTime = predictionTime;
                    continue block0;
                }
                ++predictionTime;
            }
        }
    }

    private void GenerateFromTargets() {
        ArrayList<Target> targets = this._targeting.GetTargets();
        this._enemyPredictionCount = 0;
        for (int targetIndex = 0; targetIndex < targets.size(); ++targetIndex) {
            Target target = targets.get(targetIndex);
            if (!target.Valid || !target.Alive) continue;
            this.GenerateFromTarget(target, this._enemyPredictions[this._enemyPredictionCount]);
            ++this._enemyPredictionCount;
        }
    }

    private void GenerateFromTarget(Target target, EnemyPrediction prediction) {
        RobotSnapshot snapshot = target.RobotHistory.Snapshots.get(0);
        prediction.TickPredictionWasGenerated = this._robot.getTime();
        for (int predictionIndex = 0; predictionIndex < prediction.PredictedEnemyMovement.length; ++predictionIndex) {
            PredictedPosition pos = prediction.PredictedEnemyMovement[predictionIndex];
            pos.X = snapshot.LocationX;
            pos.Y = snapshot.LocationY;
        }
    }
}

