/*
 * Decompiled with CFR 0.152.
 */
package pez.mako;

import java.awt.geom.Point2D;
import pez.mako.Bot;
import pez.mako.FactorGun;
import pez.mako.Mako;
import pez.mako.VirtualGun;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.Condition;

class CheckVirtualGunsCondition
extends Condition {
    private long time;
    private VirtualGun[] guns;
    private Bot target;
    private Bot gunner;
    private AdvancedRobot robot;
    private double bulletVelocity;
    private double bulletPower;
    private Point2D oldRLocation = new Point2D.Double();
    private Point2D oldELocation = new Point2D.Double();
    private Point2D impactLocation = new Point2D.Double();
    private Point2D guessedLocation = new Point2D.Double();
    private double oldBearing;
    private double oldBearingDelta;

    public boolean test() {
        if (this.robot.getOthers() == 0) {
            return false;
        }
        double d = this.bulletVelocity * (double)(this.robot.getTime() - this.time);
        if (d > this.oldRLocation.distance(this.target.getLocation()) - 10.0) {
            this.gunner.incrementShotCount();
            if (Math.abs(this.oldBearingDelta) > 0.05) {
                double d2 = Mako.absoluteBearing(this.oldRLocation, this.target.getLocation());
                Mako.toLocation(d2, d, this.oldRLocation, this.impactLocation);
                double d3 = Mako.normalRelativeAngle(d2 - this.oldBearing);
                double d4 = d3 / this.oldBearingDelta;
                int n = 0;
                while (n < this.guns.length) {
                    VirtualGun virtualGun = this.guns[n];
                    if (virtualGun instanceof FactorGun) {
                        ((FactorGun)virtualGun).updateFactor(d4, d3, this.bulletPower);
                    }
                    Mako.toLocation(((FactorGun)virtualGun).guessedBearing(this.oldBearing, this.oldBearingDelta), d, this.oldRLocation, this.guessedLocation);
                    if (this.impactLocation.distance(this.guessedLocation) < 20.0) {
                        virtualGun.updateRating(100.0, this.bulletPower);
                    } else {
                        virtualGun.updateRating(0.0, this.bulletPower);
                    }
                    ++n;
                }
            }
            this.robot.removeCustomEvent((Condition)this);
        }
        return false;
    }

    public CheckVirtualGunsCondition(Bullet bullet, double d, double d2, Bot bot, Bot bot2, AdvancedRobot advancedRobot) {
        this.time = advancedRobot.getTime();
        this.bulletVelocity = bullet.getVelocity();
        this.bulletPower = bullet.getPower();
        this.gunner = bot;
        this.target = bot2;
        this.robot = advancedRobot;
        this.oldBearingDelta = d;
        this.guns = bot2.getVirtualGuns(this.oldBearingDelta, d2);
        this.oldRLocation.setLocation(bot.getLocation());
        this.oldELocation.setLocation(bot2.getLocation());
        this.oldBearing = Mako.absoluteBearing(this.oldRLocation, this.oldELocation);
    }
}

