/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.movement;

import florent.XSeries.X2;
import florent.XSeries.gun.TargetSelector;
import florent.XSeries.movement.MovementStrategy;
import florent.XSeries.radar.Enemy;
import florent.XSeries.radar.Tracker;
import florent.XSeries.team.Xmen;
import florent.XSeries.utils.RobocodeTools;
import java.awt.geom.Point2D;

public class Ram
extends MovementStrategy {
    private Xmen me;
    private int score;
    private TargetSelector selector;

    public Ram(Xmen me) {
        this.me = me;
        this.selector = TargetSelector.getInstance(me, Tracker.getInstance());
    }

    public void onMainLoop() {
        ((X2)this.me).gun.holdFire = true;
        Enemy enemy = this.selector.getTarget();
        if (enemy == null) {
            return;
        }
        double theta = RobocodeTools.absoluteBearing(new Point2D.Double(this.me.getX(), this.me.getY()), enemy.location) - this.me.getHeadingRadians();
        this.me.setAhead(Math.cos(theta) * 100.0);
        this.me.setTurnRightRadians(Math.tan(theta));
    }

    public void execCondition() {
        Enemy enemy = this.selector.getTarget();
        this.score = enemy != null && enemy.energy == 0.0 && enemy.isSkyClear() ? 50 : 0;
    }

    public int getScore() {
        return this.score;
    }
}

