/*
 * Decompiled with CFR 0.152.
 */
package florent.small;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class LittleAngel
extends AdvancedRobot {
    static LittleAngel instance;
    static double time;
    static final int GF0 = 23;
    static final int GF1 = 46;
    static final double POWER = 1.9;
    static double[][][][][][] stats;
    static Wave surfing;
    static int dir;
    static LinkedList waves;
    static double dangerReverse;
    static Point2D.Double position;
    static double heading;
    static double lateralVelocity;
    static int hits;
    static int shots;
    static double eEnergy;
    static Point2D.Double ePosition;
    static double eDistance;
    static double eFirePower;
    static double eVelocity;
    static long eTimer;

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        if (surfing.passed(80.0)) {
            surfing.registerhit(2);
        }
        eEnergy += (double)3 * hitByBulletEvent.getPower();
    }

    public void onBulletHit(BulletHitEvent bulletHitEvent) {
        ++hits;
        double d = bulletHitEvent.getBullet().getPower();
        eEnergy -= (double)4 * d + (d > 1.0 ? (double)2 * (d - 1.0) : 0.0);
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        double d;
        Wave wave = new EnemyWave();
        double d2 = eEnergy;
        eEnergy = scannedRobotEvent.getEnergy();
        double d3 = d2 - eEnergy;
        if (d3 > 0.0 && d3 <= (double)3) {
            eFirePower = d3;
            this.addCustomEvent(wave);
            waves.add(wave);
        }
        surfing = wave;
        wave.origin = (Point2D.Double)ePosition.clone();
        wave.startBearing = LittleAngel.absoluteBearing(ePosition, position);
        wave.direction = (double)dir * wave.maxEscapeAngle(eFirePower);
        wave.target = position;
        wave.wStat = stats[5][(int)(eDistance / 200.0)][LittleAngel.wallSegment(wave)][(int)(Math.abs(lateralVelocity + 1.0) / (double)2)][0];
        if (!waves.isEmpty()) {
            surfing = (Wave)((Object)waves.getFirst());
        }
        Point2D.Double double_ = LittleAngel.getNextPoint(dir);
        if (dangerReverse < 0.0) {
            double_ = LittleAngel.getNextPoint(-dir);
        }
        heading = this.getHeadingRadians();
        lateralVelocity = this.getVelocity() * Math.sin(heading - wave.startBearing);
        if (lateralVelocity != 0.0) {
            dir = lateralVelocity > 0.0 ? 1 : -1;
        }
        d3 = LittleAngel.absoluteBearing(position, double_) - heading;
        this.setAhead(Math.cos(d3) * 100.0);
        this.setTurnRightRadians(Math.tan(d3));
        dangerReverse = 0.0;
        time = this.getTime();
        position.setLocation(this.getX(), this.getY());
        eDistance = scannedRobotEvent.getDistance();
        double d4 = scannedRobotEvent.getBearingRadians() + heading;
        ePosition.setLocation(LittleAngel.project(position, d4, eDistance));
        double d5 = 1.9;
        if ((double)hits > 0.3 * (double)shots) {
            d5 = 3;
        }
        d5 = Math.min(eEnergy / (double)4, d5);
        wave = new Wave();
        wave.origin = (Point2D.Double)position.clone();
        wave.startBearing = d4;
        d3 = scannedRobotEvent.getVelocity();
        wave.direction = (double)(d * Math.sin(scannedRobotEvent.getHeadingRadians() - d4) > 0.0 ? 1 : -1) * wave.maxEscapeAngle(d5);
        wave.target = ePosition;
        int n = (int)(eVelocity - (eVelocity = Math.abs(d3)));
        if (n > 0) {
            eTimer = 0L;
        }
        wave.wStat = stats[(int)Math.min((double)4, (double)(eTimer += 90L) / eDistance)][(int)((eDistance + 100.0) / 275.0)][LittleAngel.wallSegment(wave)][(int)(eVelocity + 1.0) / 2][n + 8];
        n = 23;
        int n2 = 46;
        while (n2 >= 0) {
            if (wave.wStat[n2] > wave.wStat[n]) {
                n = n2;
            }
            --n2;
        }
        this.addCustomEvent(wave);
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(d4 - this.getGunHeadingRadians() + wave.direction * ((double)n - 23.0) / 23.0)));
        if (this.getEnergy() > d5 && this.setFireBullet(d5) != null) {
            ++shots;
        }
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(d4 - this.getRadarHeadingRadians())) * (double)2);
    }

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        while (true) {
            this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    static final double absoluteBearing(Point2D.Double double_, Point2D.Double double_2) {
        return Math.atan2(double_2.x - double_.x, double_2.y - double_.y);
    }

    static final double bindToRange(double d, double d2, double d3) {
        return Math.max(d2, Math.min(d, d3));
    }

    static final Point2D.Double getNextPoint(int n, Point2D.Double double_, Point2D.Double double_2) {
        Point2D.Double double_3;
        double d = 2.3707963267948964;
        while (!LittleAngel.checkBF(double_3 = LittleAngel.project(double_, LittleAngel.absoluteBearing(double_, double_2) - (double)n * (d -= 0.1), 170.0))) {
        }
        return double_3;
    }

    static final Point2D.Double getNextPoint(int n) {
        return LittleAngel.getNextPoint(n, position, LittleAngel.surfing.origin);
    }

    static final Point2D.Double project(Point2D.Double double_, double d, double d2) {
        return new Point2D.Double(double_.x + d2 * Math.sin(d), double_.y + d2 * Math.cos(d));
    }

    static final boolean checkBF(Point2D.Double double_) {
        return new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0).contains(double_);
    }

    static double sqr(double d) {
        return d * d + 1.0;
    }

    static int wallSegment(Wave wave) {
        return 1 - LittleAngel.checkBF(LittleAngel.project(wave.target, wave.startBearing + wave.direction * 0.4, eDistance));
    }

    public LittleAngel() {
        waves = new LinkedList();
        instance = this;
    }

    static {
        stats = new double[6][10][2][5][17][47];
        dir = 1;
        position = new Point2D.Double();
        ePosition = new Point2D.Double();
    }

    static class Wave
    extends Condition {
        double fireTime = time;
        double bVel;
        double startBearing;
        double direction;
        double[] wStat;
        Point2D.Double target;
        Point2D.Double origin;

        public boolean test() {
            if (this.passed(18.0)) {
                this.registerhit(256);
                instance.removeCustomEvent(this);
            }
            return false;
        }

        boolean passed(double d, Point2D.Double double_) {
            boolean bl = false;
            if (this.distanceToImpact(double_, time) < d) {
                bl = true;
            }
            return bl;
        }

        boolean passed(double d) {
            return this.passed(d, this.target);
        }

        double distanceToImpact(Point2D.Double double_, double d) {
            return this.origin.distance(double_) - (d - this.fireTime) * this.bVel;
        }

        double distanceToImpact() {
            return this.distanceToImpact(this.target, time);
        }

        void registerhit(int n) {
            int n2 = 46;
            while (n2 >= 0) {
                this.wStat[n2] = ((double)n * this.wStat[n2] + 1.0 / LittleAngel.sqr(this.gf() - n2)) / (double)(n + 1);
                --n2;
            }
        }

        int gf() {
            return this.gf(this.target);
        }

        int gf(Point2D.Double double_) {
            return (int)LittleAngel.bindToRange((this.visitingGf(double_) + 1.0) * 23.0, 0.0, 46.0);
        }

        double visitingGf(Point2D.Double double_) {
            return Utils.normalRelativeAngle((double)(LittleAngel.absoluteBearing(this.origin, double_) - this.startBearing)) / this.direction;
        }

        double maxEscapeAngle(double d) {
            this.bVel = 20.0 - (double)3 * d;
            return Math.asin(8.0 / this.bVel);
        }
    }

    static class EnemyWave
    extends Wave {
        public boolean test() {
            if (this.passed(-40.0)) {
                instance.removeCustomEvent(this);
                waves.remove((Object)this);
            }
            dangerReverse += this.updateDanger(-dir) - this.updateDanger(dir);
            return false;
        }

        double updateDanger(int n) {
            double d;
            double d2;
            Point2D.Double double_ = (Point2D.Double)position.clone();
            double d3 = heading;
            double d4 = instance.getVelocity();
            int n2 = (int)time;
            do {
                if (Math.cos((d2 = LittleAngel.absoluteBearing(double_, LittleAngel.getNextPoint(n, double_, this.origin))) - d3) < 0.0) {
                    d3 += Math.PI;
                    d4 = -d4;
                }
                d = Math.toRadians(10.0 - 0.75 * Math.abs(d4));
            } while (this.distanceToImpact(double_ = LittleAngel.project(double_, d3 += LittleAngel.bindToRange(Math.tan(Utils.normalRelativeAngle((double)(d2 - d3))), -d, d), d4 = d4 < 0.0 ? Math.min(d4 + (double)2, 0.0) : LittleAngel.bindToRange(d4 - (double)2, 8.0, d4 - 1.0)), n2++) > 18.0);
            d2 = this.gf(double_);
            d = 0.001 / LittleAngel.sqr(d2 - 23.0);
            n2 = 46;
            while (n2 >= 0) {
                d += this.wStat[n2] / LittleAngel.sqr(d2 - (double)n2);
                --n2;
            }
            return d / LittleAngel.sqr(this.distanceToImpact() * double_.distance(ePosition));
        }

        EnemyWave() {
        }
    }
}

