/*
 * Decompiled with CFR 0.152.
 */
package adt;

import adt.RobotTracker;
import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.GunTurnCompleteCondition;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.MoveCompleteCondition;
import robocode.RadarTurnCompleteCondition;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.TurnCompleteCondition;
import robocode.WinEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Ar1
extends AdvancedRobot {
    static int bumpCount = 0;
    boolean aiming;
    String lastTarget;
    long lastSighting;
    double lastRange;
    RobotTracker tracker;

    public void run() {
        this.addCustomEvent((Condition)new MoveCompleteCondition((AdvancedRobot)this));
        this.addCustomEvent((Condition)new RadarTurnCompleteCondition((AdvancedRobot)this));
        this.addCustomEvent((Condition)new GunTurnCompleteCondition((AdvancedRobot)this));
        this.addCustomEvent((Condition)new TurnCompleteCondition((AdvancedRobot)this));
        this.setColors(new Color(100, 128, 96), Color.green, new Color(200, 210, 215));
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setTurnRadarLeft(60.0);
        while (true) {
            this.execute();
        }
    }

    public void onEndOfRound() {
        this.out.println(bumpCount + " wall bumps.");
    }

    public void onDeath(DeathEvent event) {
        this.onEndOfRound();
    }

    public void onWin(WinEvent event) {
        this.onEndOfRound();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.tracker.updateBot(e);
        double enemyHeading = (this.getHeading() + e.getBearing() + 360.0) % 360.0;
        double gunTurn = enemyHeading - this.getGunHeading();
        if (Math.abs(gunTurn) > 180.0) {
            gunTurn = (double)(gunTurn < 0.0 ? 1 : -1) * (360.0 - Math.abs(gunTurn));
        }
        if (!this.aiming) {
            if (this.lastTarget != null && !e.getName().equals(this.lastTarget)) {
                if (this.lastSighting < this.getTime() - 10L) {
                    this.aiming = true;
                } else if (this.lastRange * 0.1 > e.getDistance() && Math.random() > 0.6) {
                    this.aiming = true;
                }
            } else {
                this.aiming = true;
            }
            if (this.aiming) {
                this.lastTarget = e.getName();
                this.lastRange = e.getDistance();
                this.aimAt(this.tracker.getAimPoint(this.lastTarget));
            }
        }
        if (e.getName().equals(this.lastTarget)) {
            this.lastSighting = this.getTime();
        }
    }

    public void aimAt(Point2D.Double aimPoint) {
        if (aimPoint != null) {
            double dy;
            double dx = aimPoint.getX() - this.getX();
            double t = Math.atan2(dx, dy = aimPoint.getY() - this.getY());
            double gunTurn = t - this.getGunHeadingRadians();
            if (Math.abs(gunTurn) > Math.PI) {
                gunTurn = (double)(gunTurn < 0.0 ? 1 : -1) * (Math.PI * 2 - Math.abs(gunTurn));
            }
            if (gunTurn > 0.0) {
                this.setTurnGunRightRadians(gunTurn % (Math.PI * 2));
            } else {
                this.setTurnGunLeftRadians(-gunTurn % (Math.PI * 2));
            }
        }
    }

    public void driveAt(Point2D.Double aimPoint, double offset) {
        if (aimPoint != null) {
            double dy;
            double dx = aimPoint.getX() - this.getX();
            double t = Math.atan2(dx, dy = aimPoint.getY() - this.getY());
            double turn = t - this.getHeadingRadians();
            if (Math.abs(turn) > Math.PI) {
                turn = (double)(turn < 0.0 ? 1 : -1) * (Math.PI * 2 - Math.abs(turn));
            }
            if (turn > 0.0) {
                this.setTurnRightRadians(turn % (Math.PI * 2) + offset);
            } else {
                this.setTurnLeftRadians(-turn % (Math.PI * 2) - offset);
            }
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.setTurnLeft(30.0 - e.getBearing());
    }

    public void onHitWall(HitWallEvent event) {
        if (Math.abs(event.getBearing()) < 90.0) {
            this.setBack(25.0);
        } else {
            this.setAhead(25.0);
        }
        this.setTurnLeft(0.51 * (180.0 - event.getBearing()));
        ++bumpCount;
    }

    public void onRobotDeath(RobotDeathEvent event) {
        if (event.getName().equals(this.lastTarget)) {
            this.lastTarget = null;
            this.aiming = false;
        }
    }

    public void onHitRobot(HitRobotEvent event) {
        if (event.getBearing() > -90.0 && event.getBearing() <= 90.0) {
            this.setBack(10.0);
            if (event.getBearing() > 0.0) {
                this.setTurnLeft(90.0 - event.getBearing());
            } else {
                this.setTurnRight(90.0 + event.getBearing());
            }
        } else {
            this.setAhead(10.0);
            this.setTurnRight(90.0 + event.getBearing());
        }
        this.lastTarget = event.getName();
    }

    public void onCustomEvent(CustomEvent event) {
        if (event.getCondition() instanceof MoveCompleteCondition) {
            this.onMoveComplete();
        } else if (event.getCondition() instanceof RadarTurnCompleteCondition) {
            this.onRadarTurnComplete();
        } else if (event.getCondition() instanceof GunTurnCompleteCondition) {
            this.onGunTurnComplete();
        } else if (event.getCondition() instanceof TurnCompleteCondition) {
            this.onTurnComplete();
        }
    }

    public void onMoveComplete() {
        this.setAhead(100.0);
    }

    public void onRadarTurnComplete() {
        this.setTurnRadarRight(360.0);
    }

    public void onGunTurnComplete() {
        if (this.aiming) {
            this.aiming = false;
            if (this.getEnergy() > 10.0) {
                this.setFire(this.getKillPower(this.lastTarget, 3));
            } else if (this.getEnergy() > 20.0) {
                this.setFire(this.getKillPower(this.lastTarget, 1.01));
            } else {
                this.setFire(this.getKillPower(this.lastTarget, this.getEnergy() / 10.0));
            }
        }
    }

    public double getKillPower(String target, double limit) {
        double enemyEnergy = this.tracker.getEnergy(target);
        double killEnergy = 0.0;
        this.out.println(target + " has " + enemyEnergy);
        killEnergy = enemyEnergy > (double)4 ? (enemyEnergy + (double)2) / 6.0 : enemyEnergy / (double)4;
        if (killEnergy > limit) {
            killEnergy = limit;
        } else {
            this.out.println("we only need " + killEnergy + " to kill " + target);
        }
        return killEnergy;
    }

    public void onTurnComplete() {
        double x = this.getX();
        double y = this.getY();
        double w = this.getBattleFieldWidth();
        double h = this.getBattleFieldHeight();
        int wall = 50;
        double wallTurnSp = 1.6;
        int wallTurn = 40;
        this.setMaxVelocity(8.0);
        if (x < 50.0 || y < 50.0 || x > w - 50.0 || y > h - 50.0) {
            if (x < 50.0 && this.getHeading() > 180.0) {
                if (this.getHeading() < 270.0) {
                    this.setTurnLeft(40.0);
                } else {
                    this.setTurnRight(40.0);
                }
                this.setMaxVelocity(1.6);
            } else if (y < 50.0 && this.getHeading() > 90.0 && this.getHeading() < 270.0) {
                if (this.getHeading() < 180.0) {
                    this.setTurnLeft(40.0);
                } else {
                    this.setTurnRight(40.0);
                }
                this.setMaxVelocity(1.6);
            }
            if (y > h - 50.0 && (this.getHeading() > 270.0 || this.getHeading() < 90.0)) {
                if (this.getHeading() > 270.0) {
                    this.setTurnLeft(40.0);
                } else {
                    this.setTurnRight(40.0);
                }
                this.setMaxVelocity(1.6);
            } else if (x > w - 50.0 && this.getHeading() < 180.0) {
                if (this.getHeading() < 90.0) {
                    this.setTurnLeft(40.0);
                } else {
                    this.setTurnRight(40.0);
                }
                this.setMaxVelocity(1.6);
            }
        } else if (this.lastRange > 200.0) {
            this.driveAt(this.tracker.getAimPoint(this.lastTarget), 1.0);
        } else if (this.lastRange < 100.0) {
            this.driveAt(this.tracker.getAimPoint(this.lastTarget), -1.0);
        } else {
            this.setTurnLeft(9.0 * (Math.random() - Math.random() * 0.999));
        }
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        this.out.println("Skipped a turn!");
    }

    private final /* synthetic */ void this() {
        this.aiming = false;
        this.lastTarget = null;
        this.lastSighting = 0L;
        this.lastRange = 100000.0;
        this.tracker = new RobotTracker((Robot)this);
    }

    public Ar1() {
        this.this();
    }
}

