/*
 * Decompiled with CFR 0.152.
 */
package agd.radar;

import agd.util.Compass;
import agd.util.Enemy;
import agd.util.RobotInformation;
import java.util.Comparator;

class HeadingComparator
implements Comparator {
    private Enemy focusedEnemy;
    private RobotInformation robotinfo;
    Compass targetHeading;

    public HeadingComparator(RobotInformation ri, Enemy f) {
        this.focusedEnemy = f;
        this.robotinfo = ri;
        this.targetHeading = this.robotinfo.getPosition().headingTo(this.focusedEnemy.getLastSighting().getTheirPosition());
    }

    public int compare(Object o1, Object o2) {
        Enemy e1 = (Enemy)o1;
        Enemy e2 = (Enemy)o2;
        Compass heading1 = this.robotinfo.getPosition().headingTo(e1.getLastSighting().getPosition());
        Compass heading2 = this.robotinfo.getPosition().headingTo(e2.getLastSighting().getPosition());
        double bearing1 = this.targetHeading.bearingTo(heading1);
        double bearing2 = this.targetHeading.bearingTo(heading2);
        return (int)(bearing1 - bearing2);
    }
}

