/*
 * Decompiled with CFR 0.152.
 */
package bh.util;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import robocode.BattleEndedEvent;
import robocode.BattleResults;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.MessageEvent;
import robocode.RobotDeathEvent;
import robocode.RobotStatus;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.WinEvent;

public class Util {
    public static final String format = "%1$6.4f";

    public static boolean equalsCheckNull(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static String toString(double x, double y) {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(String.format(format, x)).append(",").append(String.format(format, y)).append(">");
        return sb.toString();
    }

    public static String toString(Bullet b) {
        StringBuilder sb = new StringBuilder();
        sb.append("Bullet:").append(" pwr(").append(String.format(format, b.getPower())).append(") loc").append(Util.toString(b.getX(), b.getY())).append(") spd(").append(String.format(format, b.getVelocity())).append(") hdg(").append(String.format(format, b.getHeading())).append(") by(").append(b.getName()).append(") hit(").append(b.getVictim()).append(") <");
        if (!b.isActive()) {
            sb.append("not ");
        }
        sb.append("active>");
        return sb.toString();
    }

    public static String toString(RobotStatus rs) {
        StringBuilder sb = new StringBuilder();
        sb.append("RobotStatus: rnd(").append(rs.getRoundNum()).append(") tm(").append(rs.getTime()).append(") -<BOT>-").append(" nrg(").append(String.format(format, rs.getEnergy())).append(") loc").append(Util.toString(rs.getX(), rs.getY())).append(" spd(").append(String.format(format, rs.getVelocity())).append(") hdg(").append(String.format(format, rs.getHeading())).append(")");
        if (rs.getTurnRemaining() != 0.0) {
            sb.append(" trnRm(").append(String.format(format, rs.getTurnRemaining())).append(")");
        }
        if (rs.getDistanceRemaining() != 0.0) {
            sb.append(" dstRm(").append(String.format(format, rs.getDistanceRemaining())).append(")");
        }
        sb.append(" -<GUN>-").append(" ht(").append(String.format(format, rs.getGunHeat())).append(") hdg(").append(String.format(format, rs.getGunHeading())).append(")");
        if (rs.getGunTurnRemaining() != 0.0) {
            sb.append(" trnRm(").append(String.format(format, rs.getGunTurnRemaining())).append(")");
        }
        sb.append(" -<RADAR>-").append(" hdg(").append(String.format(format, rs.getRadarHeading())).append(")");
        if (rs.getRadarTurnRemaining() != 0.0) {
            sb.append(" trnRm(").append(String.format(format, rs.getRadarTurnRemaining())).append(")");
        }
        return sb.toString();
    }

    public static String toString(BattleResults br) {
        StringBuilder sb = new StringBuilder();
        sb.append("BattleResults:").append(" scr(").append(br.getScore()).append(") bltDmg(").append(br.getBulletDamage()).append(") bltBns(").append(br.getBulletDamageBonus()).append(") rmDmg(").append(br.getRamDamage()).append(") rmBns(").append(br.getRamDamageBonus()).append(") svr(").append(br.getSurvival()).append(") svrBns(").append(br.getLastSurvivorBonus()).append(") rnk(").append(br.getRank()).append(") 1sts(").append(br.getFirsts()).append(") 2nds(").append(br.getSeconds()).append(") 3rds(").append(br.getThirds()).append(") tmLdr(").append(br.getTeamLeaderName()).append(")");
        return sb.toString();
    }

    public static String toString(BulletHitEvent e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(": ").append(e.getName()).append(" remaining energy ").append(e.getEnergy()).append("; [").append(Util.toString(e.getBullet())).append("]");
        return sb.toString();
    }

    public static String toString(BulletHitBulletEvent e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(": [").append(Util.toString(e.getBullet())).append("]<->[").append(Util.toString(e.getHitBullet())).append("]");
        return sb.toString();
    }

    public static String toString(BulletMissedEvent e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(": [").append(Util.toString(e.getBullet())).append("]");
        return sb.toString();
    }

    public static String toString(HitRobotEvent e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(": ").append(" hit(").append(e.getName()).append(") rmnNrg(").append(String.format(format, e.getEnergy())).append(") brng(").append(String.format(format, e.getBearing())).append(") <");
        if (!e.isMyFault()) {
            sb.append("not ");
        }
        sb.append("my fault>");
        return sb.toString();
    }

    public static String toString(HitWallEvent e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(": bearing ").append(e.getBearing());
        return sb.toString();
    }

    public static String toString(HitByBulletEvent e) {
        assert (e.getName().equals(e.getBullet().getName()));
        assert (e.getPower() == e.getBullet().getPower());
        assert (e.getVelocity() == e.getBullet().getVelocity());
        assert (e.getHeading() == e.getBullet().getHeading());
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(": [").append(Util.toString(e.getBullet())).append("]").append(" brng(").append(String.format(format, e.getBearing())).append(")");
        return sb.toString();
    }

    public static String toString(RobotDeathEvent e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(": ").append(e.getName());
        return sb.toString();
    }

    public static String toString(ScannedRobotEvent e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(": ").append(e.getName()).append(" energy ").append(e.getEnergy()).append(" speed ").append(e.getVelocity()).append(" heading ").append(e.getHeading()).append(" distance ").append(e.getDistance()).append(" bearing ").append(e.getBearing());
        return sb.toString();
    }

    public static String toString(StatusEvent e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(": status: [").append(Util.toString(e.getStatus())).append("]");
        return sb.toString();
    }

    public static String toString(SkippedTurnEvent e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(": ");
        return sb.toString();
    }

    public static String toString(DeathEvent e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(": ");
        return sb.toString();
    }

    public static String toString(WinEvent e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(": ");
        return sb.toString();
    }

    public static String toString(BattleEndedEvent e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(": ");
        if (e.isAborted()) {
            sb.append("was aborted ");
        }
        sb.append("[").append(Util.toString(e.getResults())).append("]");
        return sb.toString();
    }

    public static String toString(CustomEvent e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(": ");
        return sb.toString();
    }

    public static String toString(MessageEvent event) {
        StringBuilder sb = new StringBuilder();
        sb.append(event.getClass().getName()).append(": from ").append(event.getSender()).append(": ").append(event.getMessage());
        return sb.toString();
    }

    public static String toString(KeyEvent e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(": ").append(e.paramString());
        return sb.toString();
    }

    public static String toString(MouseEvent e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(": ").append(e.paramString());
        return sb.toString();
    }

    public static String toString(MouseWheelEvent e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(": ").append(e.paramString());
        return sb.toString();
    }
}

