/*
 * Decompiled with CFR 0.152.
 */
package spinnercat;

import java.awt.geom.Point2D;
import robocode.util.Utils;
import spinnercat.EnemyBot;

public class Wave {
    private double startX;
    private double startY;
    private double startBearing;
    private double power;
    private long fireTime;
    private int direction;
    private int[] returnSegment;
    public int radius = 0;

    public Wave(double x, double y, double zzPower) {
        this.startX = x;
        this.startY = y;
        this.power = zzPower;
    }

    public Wave(double x, double y, double b, double pow, long time, int dir, int[] seg) {
        this.startX = x;
        this.startY = y;
        this.startBearing = b;
        this.power = pow;
        this.fireTime = time;
        this.direction = dir;
        this.returnSegment = seg;
    }

    public double getBulletSpeed() {
        return 20.0 - 3.0 * this.power;
    }

    public double maxEscapeAngle() {
        return Math.asin(8.0 / this.getBulletSpeed());
    }

    public void expand() {
        this.radius = (int)((double)this.radius + this.getBulletSpeed());
    }

    public boolean hasBroken(EnemyBot en) {
        return (double)this.radius >= new Point2D.Double(this.startX, this.startY).distance(en.getX(), en.getY());
    }

    public boolean checkHit(double ex, double ey, long time) {
        if (Point2D.Double.distance(this.startX, this.startY, ex, ey) <= (double)(time - this.fireTime) * this.getBulletSpeed()) {
            int index;
            double dd = this.absoluteBearing(this.startX, this.startY, ex, ey);
            double offset = Utils.normalRelativeAngle((double)(dd - this.startBearing));
            double gf = Math.min(Math.max(offset / this.maxEscapeAngle(), -1.0), 1.0) * (double)this.direction;
            int n = index = (int)Math.round((gf + 1.0) * (double)(this.returnSegment.length - 1) / 2.0);
            this.returnSegment[n] = this.returnSegment[n] + 1;
            return true;
        }
        return false;
    }

    private double absoluteBearing(double x1, double y1, double x2, double y2) {
        return Math.atan2(x2 - x1, y2 - y1);
    }
}

