/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import shrub.Heading;
import shrub.Phasor;
import shrub.RobotDataStore;
import shrub.TurretInstruction;
import shrub.TurretModeAPI;
import shrub.TurretModeRTH;

public class TurretModePAH
implements TurretModeAPI {
    private Heading mTargetHdng = Heading.ZERO;
    private final Phasor mPhasor;
    private final RobotDataStore mDataStore = RobotDataStore.getInstance();
    private final TurretModeRTH mTurretModeRTH;

    public TurretModePAH(double scanSpeed, Phasor scanPhasor) {
        this.mPhasor = scanPhasor;
        this.mTurretModeRTH = new TurretModeRTH(scanSpeed);
    }

    public void setTargetHdng(Heading targetHdng) {
        this.mTargetHdng = targetHdng;
    }

    public TurretInstruction generateInstruction() {
        long timeNow = this.mDataStore.getCurrentTime();
        this.mPhasor.SetTimeNow(timeNow);
        double phasedOffset = this.mPhasor.GetPhaseValue();
        Heading adjHdng = Heading.valueOfAdjust(this.mTargetHdng, phasedOffset);
        this.mTurretModeRTH.setTargetHdng(adjHdng);
        TurretInstruction instruct = this.mTurretModeRTH.generateInstruction();
        return instruct;
    }
}

